/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.backend.XUBlockTESR;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.BoxQuadListDeferred;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.crafting.CraftingHelper;
import com.rwtema.extrautils2.items.ItemIngredients;
import com.rwtema.extrautils2.items.itemmatching.IMatcherMaker;
import com.rwtema.extrautils2.transfernodes.FacingHelper;
import com.rwtema.extrautils2.utils.MCTimer;
import com.rwtema.extrautils2.utils.datastructures.ItemRef;
import com.rwtema.extrautils2.utils.helpers.QuadHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockOpinium
extends XUBlockTESR {
    public static final int NUM_TIERS;
    static final IMatcherMaker[] tierList;
    static final int NUMBER_ORBITS = 4;
    static final int NUMBER_SUBORBITS = 0;
    static final float ORBIT_REDUCTION = 0.25f;
    static final float CORE_REDUCTION = 0.375f;
    static final float ORBIT_DISTANCE = 0.4375f;
    static final float SUB_ORBIT_DISTANCE = 0.25f;
    static final float SUB_ORBIT_REDUCTION = 0.0625f;

    public static void addRecipes() {
        CraftingHelper.addShaped("opinium_0", new ItemStack((Block)XU2Entries.openium.value, 1, 0), " o ", "oio", " o ", Character.valueOf('o'), tierList[0].getCraftingObject(), Character.valueOf('i'), tierList[1].getCraftingObject());
        for (int i = 1; i < NUM_TIERS; ++i) {
            ItemStack outside = new ItemStack((Block)XU2Entries.openium.value, 1, i - 1);
            Object middle = tierList[i].getCraftingObject();
            Object inside = tierList[i + 1].getCraftingObject();
            CraftingHelper.addShaped("opinium_" + i, new ItemStack((Block)XU2Entries.openium.value, 1, i), " o ", "mim", " o ", Character.valueOf('o'), outside, Character.valueOf('i'), inside, Character.valueOf('m'), middle);
        }
    }

    @Override
    public BoxModel getWorldModel(@Nullable ItemStack stack, IBlockState state, float timer) {
        return new BoxModel(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public String getSuffix(ItemStack stack) {
        return String.valueOf(stack.func_77960_j());
    }

    @Override
    public void getSubBlocksBase(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < NUM_TIERS; ++i) {
            list.add(new ItemStack(itemIn, 1, i));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BoxModel getRenderModel(ItemStack raw, IBlockState state, float renderTimer) {
        BoxModel model = new BoxModel();
        model.sprite = this.getModel(new ItemStack(Items.field_151042_j)).func_177554_e();
        if (StackHelper.isEmpty(raw)) {
            return model;
        }
        int tier = raw.func_77960_j();
        if (tier < 0 || tier >= NUM_TIERS) {
            return model;
        }
        model.add(new BoxQuadListDeferred(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, () -> this.getModel(tierList[tier + 1].getMainStack()).func_177554_e(), side -> side == null ? this.createQuads(tier) : ImmutableList.of()));
        return model;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> createQuads(int tier) {
        Vector3f[] vecs;
        float renderTimer = MCTimer.renderTimer;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        renderTimer /= 2.0f;
        renderTimer += (float)(tier * tier) + (float)tier * 1.21f;
        IBakedModel centerModel = this.getModel(tierList[tier + 1].getMainStack());
        IBakedModel orbitModel = this.getModel(tierList[tier].getMainStack());
        IBakedModel subOrbitModel = tier == 0 ? null : this.getModel(tierList[tier - 1].getMainStack());
        Vector3f ring_axis_a = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f ring_axis_b = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f ring_axis_c = new Vector3f(0.0f, 0.0f, 1.0f);
        Matrix4f mat = new Matrix4f();
        mat.setIdentity();
        float r = renderTimer / 5.0f;
        for (Vector3f subAxis : vecs = new Vector3f[]{new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f)}) {
            QuadHelper.rotate(r, subAxis.x, subAxis.y, subAxis.z, mat, mat);
            r *= 0.546f;
        }
        mat.transform(ring_axis_a);
        mat.transform(ring_axis_b);
        mat.transform(ring_axis_c);
        mat.setIdentity();
        r = renderTimer / 2.0f;
        for (Vector3f subAxis : vecs) {
            QuadHelper.rotate(r, subAxis.x, subAxis.y, subAxis.z, mat, mat);
            r /= 2.0f;
        }
        Vector3f orbit_axis = new Vector3f(0.0f, 1.0f, 0.0f);
        mat.transform(orbit_axis);
        mat.setIdentity();
        QuadHelper.translate(mat, -0.5f, -0.5f, -0.5f);
        mat.mul(0.375f);
        QuadHelper.rotate(MCTimer.renderTimer / 15.0f, 0.0f, 1.0f, 0.0f, mat, mat);
        QuadHelper.translate(mat, 0.5f, 0.5f, 0.5f);
        if (centerModel != null) {
            for (EnumFacing facing : FacingHelper.facingPlusNull) {
                for (BakedQuad bakedQuad : centerModel.func_188616_a(null, facing, 0L)) {
                    quads.add(QuadHelper.applyMatrixTransform(bakedQuad, mat));
                }
            }
        }
        for (int i = 0; i < 4; ++i) {
            float ang = (float)((double)i * Math.PI * 2.0) / 4.0f;
            mat.setIdentity();
            QuadHelper.translate(mat, -0.5f, -0.5f, -0.5f);
            QuadHelper.scale(mat, 0.25f);
            QuadHelper.rotate(renderTimer / 6.0f + ang, orbit_axis, mat);
            float ca = (float)Math.cos(ang);
            float sa = (float)Math.sin(ang);
            QuadHelper.translate(mat, (ring_axis_a.x * ca + ring_axis_b.x * sa) * 0.4375f, (ring_axis_a.y * ca + ring_axis_b.y * sa) * 0.4375f, (ring_axis_a.z * ca + ring_axis_b.z * sa) * 0.4375f);
            QuadHelper.translate(mat, 0.5f, 0.5f, 0.5f);
            if (orbitModel != null) {
                for (EnumFacing facing : FacingHelper.facingPlusNull) {
                    for (BakedQuad bakedQuad : orbitModel.func_188616_a(null, facing, 0L)) {
                        quads.add(QuadHelper.applyMatrixTransform(bakedQuad, mat));
                    }
                }
            }
            if (subOrbitModel == null) continue;
            for (int j = 0; j < 0; ++j) {
                float ang2 = (float)((double)j * Math.PI * 2.0) / 0.0f + renderTimer / 4.6f + ang * 24.434f + (float)(i * i);
                mat.setIdentity();
                QuadHelper.translate(mat, -0.5f, -0.5f, -0.5f);
                QuadHelper.scale(mat, 0.0625f);
                float ca2 = (float)Math.cos(ang2);
                float sa2 = (float)Math.sin(ang2);
                QuadHelper.translate(mat, (ring_axis_c.x * ca2 + ring_axis_b.x * sa2) * 0.25f, (ring_axis_c.y * ca2 + ring_axis_b.y * sa2) * 0.25f, (ring_axis_c.z * ca2 + ring_axis_b.z * sa2) * 0.25f);
                QuadHelper.rotate(renderTimer / 6.0f + ang2 + ang + (float)i, orbit_axis, mat);
                QuadHelper.translate(mat, (ring_axis_a.x * ca + ring_axis_b.x * sa) * 0.4375f, (ring_axis_a.y * ca + ring_axis_b.y * sa) * 0.4375f, (ring_axis_a.z * ca + ring_axis_b.z * sa) * 0.4375f);
                QuadHelper.translate(mat, 0.5f, 0.5f, 0.5f);
                for (EnumFacing facing : FacingHelper.facingPlusNull) {
                    for (BakedQuad bakedQuad : subOrbitModel.func_188616_a(null, facing, 0L)) {
                        quads.add(QuadHelper.applyMatrixTransform(bakedQuad, mat));
                    }
                }
            }
        }
        for (BakedQuad quad : quads) {
            int[] vertexData = quad.func_178209_a();
            EnumFacing enumfacing = FaceBakery.func_178410_a((int[])vertexData);
            ForgeHooksClient.fillNormal((int[])vertexData, (EnumFacing)enumfacing);
        }
        return quads;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    private IBakedModel getModel(ItemStack stack) {
        IBakedModel duplicateModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
        return duplicateModel.func_188617_f().handleItemState(duplicateModel, stack, null, null);
    }

    static {
        tierList = new IMatcherMaker[]{ItemRef.wrap(ItemIngredients.Type.RED_COAL.newStack()), new IMatcherMaker.MatcherMakerOreDic("blockIron"), new IMatcherMaker.MatcherMakerOreDic("blockGold"), new IMatcherMaker.MatcherMakerOreDic("blockDiamond"), new IMatcherMaker.MatcherMakerOreDic("blockEmerald"), ItemRef.wrap(Blocks.field_185766_cS), ItemRef.wrap(Items.field_151062_by), ItemRef.wrap(Items.field_185160_cR), ItemRef.wrap(Items.field_151156_bN), new IMatcherMaker.MatcherMakerOreDic("ingotIron")};
        NUM_TIERS = tierList.length - 1;
    }
}

