/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.base.tile;

import com.bartz24.skyresources.base.IHeatSource;
import com.bartz24.skyresources.base.gui.ItemHandlerSpecial;
import com.bartz24.skyresources.base.item.ItemMachine;
import com.bartz24.skyresources.base.tile.TileGenericPower;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileCasing
extends TileGenericPower
implements IFluidHandler,
ITickable,
IHeatSource {
    private FluidTank tank;
    public ItemStack machineStored = ItemStack.field_190927_a;
    public NBTTagCompound machineData = new NBTTagCompound();

    public TileCasing() {
        super("machinecasing", 0, 0, 0);
        this.tank = new FluidTank(0);
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public void func_73660_a() {
        if (!this.machineStored.func_190926_b()) {
            this.getMachine().update(this.func_145831_w(), this.func_174877_v(), this.machineStored, this.machineData);
        } else {
            this.machineData = new NBTTagCompound();
        }
        this.func_70296_d();
    }

    public ItemMachine getMachine() {
        return (ItemMachine)this.machineStored.func_77973_b();
    }

    public void setMachine(ItemStack machine, EntityPlayer player) {
        for (int i = 0; i < this.getInventory().getSlots(); ++i) {
            ItemStack itemstack = this.getInventory().getStackInSlot(i);
            if (itemstack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)itemstack);
        }
        this.machineStored = machine;
        this.updateHandlerData();
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        NBTTagCompound stackTag = compound.func_74775_l("Machine");
        if (stackTag != null) {
            this.machineStored = new ItemStack(stackTag);
        }
        this.machineData = compound.func_74775_l("MachineData");
        this.tank.readFromNBT(compound);
        super.func_145839_a(compound);
        this.updateHandlerData();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound stackTag = new NBTTagCompound();
        if (!this.machineStored.func_190926_b()) {
            this.machineStored.func_77955_b(stackTag);
        }
        compound.func_74782_a("Machine", (NBTBase)stackTag);
        compound.func_74782_a("MachineData", (NBTBase)this.machineData);
        this.tank.writeToNBT(compound);
        compound = super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void dropInventory() {
        if (!this.machineStored.func_190926_b()) {
            InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.machineStored);
        }
        super.dropInventory();
    }

    public void updateHandlerData() {
        if (!this.machineStored.func_190926_b()) {
            this.maxEnergy = this.getMachine().getMaxEnergy(this.machineStored) != 0 ? this.getMachine().getMaxEnergy(this.machineStored) : 0;
            this.energy = this.getMachine().getMaxEnergy(this.machineStored) != 0 ? this.energy : 0;
            this.maxExtract = this.getMachine().getMaxEnergy(this.machineStored) != 0 ? this.getMachine().getMaxExtract(this.machineStored) : 0;
            int n = this.maxReceive = this.getMachine().getMaxEnergy(this.machineStored) != 0 ? this.getMachine().getMaxReceive(this.machineStored) : 0;
            if (this.getInventory().getSlots() == 0) {
                this.setInventory(new ItemHandlerSpecial(this.getMachine().getItemSlots(this.machineStored), this.getMachine().getInsertBlacklist(this.machineStored), this.getMachine().getExtractBlacklist(this.machineStored)){

                    protected void onContentsChanged(int slot) {
                        super.onContentsChanged(slot);
                        TileCasing.this.func_70296_d();
                    }
                });
            }
            if (this.getMachine().getFluid(this.machineStored) != null) {
                this.tank = new FluidTank(this.getMachine().getFluid(this.machineStored), 0, this.getMachine().getMaxFluid(this.machineStored));
            }
        } else {
            this.maxEnergy = 0;
            this.energy = 0;
            this.maxExtract = 0;
            this.maxReceive = 0;
            this.setInventory(new ItemHandlerSpecial(0));
            this.tank = new FluidTank(0);
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145854_h, false);
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return this.machineStored.func_190926_b() ? false : this.getMachine().getMaxEnergy(this.machineStored) != 0;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.machineStored.func_190926_b() ? false : this.getMachine().getItemSlots(this.machineStored) != 0;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.machineStored.func_190926_b() ? false : this.getMachine().getFluid(this.machineStored) != null;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.getInventory());
        }
        if (capability == CapabilityEnergy.ENERGY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public int getHeatValue() {
        return this.machineStored.func_190926_b() ? 0 : this.getMachine().getHeatProv(this.machineStored, this.field_145850_b, this.field_174879_c);
    }
}

