/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.recipe;

import com.bartz24.skyresources.ItemHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class ProcessRecipe {
    private List<ItemStack> outputs = new ArrayList<ItemStack>();
    private List<Object> inputs = new ArrayList<Object>();
    private List<FluidStack> fluidOutputs = new ArrayList<FluidStack>();
    private List<FluidStack> fluidInputs = new ArrayList<FluidStack>();
    private float intParameter;
    private String type;

    public ProcessRecipe(List<Object> output, List<Object> input, float param, String type) {
        this.intParameter = param;
        this.type = type;
        for (Object o : output) {
            if (o instanceof ItemStack) {
                this.outputs.add((ItemStack)o);
                continue;
            }
            if (!(o instanceof FluidStack)) continue;
            this.fluidOutputs.add((FluidStack)o);
        }
        for (Object o : input) {
            if (o instanceof ItemStack || o instanceof String) {
                this.inputs.add(o);
                continue;
            }
            if (!(o instanceof FluidStack)) continue;
            this.fluidInputs.add((FluidStack)o);
        }
    }

    public ProcessRecipe(List<Object> input, float param, String type) {
        this.intParameter = param;
        this.type = type;
        for (Object o : input) {
            if (o instanceof ItemStack || o instanceof String) {
                this.inputs.add(o);
                continue;
            }
            if (!(o instanceof FluidStack)) continue;
            this.fluidInputs.add((FluidStack)o);
        }
    }

    public String getRecipeType() {
        return this.type;
    }

    public boolean isInputRecipeEqualTo(ProcessRecipe recipe, boolean forceEqual) {
        return this.stacksAreValid(recipe, forceEqual) && this.fluidsValid(recipe, forceEqual) && this.intValid(recipe);
    }

    public boolean isInputRecipeLess(ProcessRecipe recipe) {
        return this.stacksAreValidLess(recipe) && this.fluidsValid(recipe, false) && this.intValid(recipe);
    }

    public boolean isInputMultiRecipeEqualTo(ProcessRecipe recipe) {
        return this.stacksAreValidMulti(recipe) && this.intValid(recipe);
    }

    boolean fluidsValid(ProcessRecipe recipe, boolean forceEqual) {
        if (this.fluidInputs.size() != recipe.fluidInputs.size()) {
            return false;
        }
        int fluidsChecked = 0;
        for (FluidStack i : this.fluidInputs) {
            boolean valid = false;
            for (FluidStack i2 : recipe.fluidInputs) {
                if (!i.isFluidEqual(i2) || !(forceEqual ? i.amount == i2.amount : i.amount >= i2.amount)) continue;
                valid = true;
            }
            if (!valid) {
                return false;
            }
            ++fluidsChecked;
        }
        return fluidsChecked == this.fluidInputs.size();
    }

    boolean stacksAreValidMulti(ProcessRecipe recipe) {
        HashMap<ItemStack, Integer> items = new HashMap<ItemStack, Integer>();
        for (Object o : this.inputs) {
            if (o instanceof String) continue;
            ItemStack i = ((ItemStack)o).func_77946_l();
            int count = i.func_190916_E();
            i.func_190920_e(1);
            boolean added = false;
            for (ItemStack i2 : items.keySet()) {
                if (!i2.func_77969_a(i)) continue;
                items.put(i2, (Integer)items.get(i2) + count);
                added = true;
            }
            if (added) continue;
            items.put(i, count);
        }
        if (items.size() != recipe.inputs.size()) {
            return false;
        }
        int itemsChecked = 0;
        float ratio = -1.0f;
        for (ItemStack i : items.keySet()) {
            if (i.func_190926_b()) continue;
            boolean valid = false;
            for (Object o2 : recipe.inputs) {
                ItemStack i2;
                if (o2 instanceof String) {
                    int[] ids;
                    for (int id : ids = OreDictionary.getOreIDs((ItemStack)i)) {
                        if (id != OreDictionary.getOreID((String)o2.toString())) continue;
                        valid = true;
                    }
                    continue;
                }
                if (!(o2 instanceof ItemStack) || !ItemHelper.itemStacksEqualOD(i, i2 = (ItemStack)o2) || (Integer)items.get(i) < i2.func_190916_E() || ratio != -1.0f && (float)((Integer)items.get(i)).intValue() / (float)i2.func_190916_E() != ratio) continue;
                valid = true;
                if (ratio != -1.0f) break;
                ratio = (float)((Integer)items.get(i)).intValue() / (float)i2.func_190916_E();
                break;
            }
            if (!valid) {
                return false;
            }
            ++itemsChecked;
        }
        return itemsChecked == items.size();
    }

    boolean stacksAreValid(ProcessRecipe recipe, boolean forceEqual) {
        if (this.inputs.size() != recipe.inputs.size()) {
            return false;
        }
        ArrayList<Integer> itemsChecked = new ArrayList<Integer>();
        int index = 0;
        for (Object i : this.inputs) {
            if (i instanceof ItemStack && ((ItemStack)i).func_190926_b()) continue;
            boolean valid = false;
            int index2 = 0;
            for (Object i2 : recipe.inputs) {
                if (!itemsChecked.contains(index2)) {
                    if (i instanceof ItemStack && i2 instanceof String) {
                        int[] ids;
                        for (int id : ids = OreDictionary.getOreIDs((ItemStack)((ItemStack)i))) {
                            if (id != OreDictionary.getOreID((String)i2.toString())) continue;
                            valid = true;
                            itemsChecked.add(index2);
                        }
                    } else if (i instanceof ItemStack && i2 instanceof ItemStack && ItemHelper.itemStacksEqualOD((ItemStack)i, (ItemStack)i2) && (forceEqual ? ((ItemStack)i).func_190916_E() == ((ItemStack)i2).func_190916_E() : ((ItemStack)i).func_190916_E() >= ((ItemStack)i2).func_190916_E())) {
                        valid = true;
                        itemsChecked.add(index2);
                    }
                }
                ++index2;
            }
            if (!valid) {
                return false;
            }
            ++index;
        }
        return itemsChecked.size() == this.inputs.size();
    }

    boolean stacksAreValidLess(ProcessRecipe recipe) {
        ArrayList<Integer> itemsChecked = new ArrayList<Integer>();
        int index = 0;
        for (Object i2 : recipe.inputs) {
            boolean valid = false;
            int index2 = 0;
            for (Object i : this.inputs) {
                if (i instanceof ItemStack && ((ItemStack)i).func_190926_b()) continue;
                if (!itemsChecked.contains(index2)) {
                    if (i instanceof ItemStack && i2 instanceof String) {
                        int[] ids;
                        for (int id : ids = OreDictionary.getOreIDs((ItemStack)((ItemStack)i))) {
                            if (id != OreDictionary.getOreID((String)i2.toString())) continue;
                            valid = true;
                            itemsChecked.add(index2);
                        }
                    } else if (i instanceof ItemStack && i2 instanceof ItemStack && ItemHelper.itemStacksEqualOD((ItemStack)i, (ItemStack)i2) && ((ItemStack)i).func_190916_E() >= ((ItemStack)i2).func_190916_E()) {
                        valid = true;
                        itemsChecked.add(index2);
                    }
                }
                ++index2;
            }
            if (!valid) {
                return false;
            }
            ++index;
        }
        return itemsChecked.size() == recipe.inputs.size();
    }

    boolean intValid(ProcessRecipe recipe) {
        return this.intParameter >= recipe.intParameter;
    }

    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    public List<Object> getInputs() {
        return this.inputs;
    }

    public List<FluidStack> getFluidOutputs() {
        return this.fluidOutputs;
    }

    public List<FluidStack> getFluidInputs() {
        return this.fluidInputs;
    }

    public float getIntParameter() {
        return this.intParameter;
    }
}

