/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.botania.handlers;

import com.blamejared.compat.botania.LocalizationHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import net.minecraft.util.text.TextFormatting;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import vazkii.botania.api.BotaniaAPI;

@ZenClass(value="mods.botania.Knowledge")
@ModOnly(value="botania")
@ZenRegister
public class Knowledge {
    private static final String typeName = "Botania Knowledge Variable:";

    @ZenMethod
    public static void registerKnowledgeType(String unlocalized, String localized, String color, boolean autoUnlock) {
        if (unlocalized == null || unlocalized.isEmpty()) {
            CraftTweakerAPI.logError((String)"Found null String in Botania Knowledge Variable: name");
        } else if (color == null || color.isEmpty()) {
            CraftTweakerAPI.logError((String)"Found null String in Botania Knowledge Variable: color");
        } else {
            LocalizationHelper.setLocale("botania.knowledge." + unlocalized, localized);
            CraftTweakerAPI.apply((IAction)new Add(unlocalized, color, autoUnlock));
        }
    }

    private static class Add
    implements IAction {
        String unlocalized;
        String color;
        boolean autoUnlock;

        public Add(String name, String color, boolean autoUnlock) {
            this.unlocalized = name;
            this.color = color;
            this.autoUnlock = autoUnlock;
        }

        public void apply() {
            BotaniaAPI.registerKnowledgeType((String)this.unlocalized, (TextFormatting)TextFormatting.func_96300_b((String)this.color.toUpperCase()), (boolean)this.autoUnlock);
        }

        public String describe() {
            String Output = this.autoUnlock ? "Enabled" : "Disabled";
            return "Adding Knowledge Type: " + this.unlocalized + " With Auto-Unlock: " + Output;
        }
    }
}

