/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.registry.internal;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.adapter.RecipeAdapter;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementType;
import hellfirepvp.modularmachinery.common.crafting.tooltip.RequirementTip;
import hellfirepvp.modularmachinery.common.registry.RegistryBlocks;
import hellfirepvp.modularmachinery.common.registry.RegistryComponentTypes;
import hellfirepvp.modularmachinery.common.registry.RegistryItems;
import hellfirepvp.modularmachinery.common.registry.RegistryRecipeAdapters;
import hellfirepvp.modularmachinery.common.registry.RegistryRegistries;
import hellfirepvp.modularmachinery.common.registry.RegistryRequirementTips;
import hellfirepvp.modularmachinery.common.registry.RegistryRequirementTypes;
import hellfirepvp.modularmachinery.common.registry.internal.InternalRegistryPrimer;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PrimerEventHandler {
    private final InternalRegistryPrimer registry;

    public PrimerEventHandler(InternalRegistryPrimer registry) {
        this.registry = registry;
    }

    @SubscribeEvent
    public void registerRegistries(RegistryEvent.NewRegistry event) {
        RegistryRegistries.buildRegistries();
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        this.registry.wipe(event.getGenericType());
        RegistryItems.initialize();
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        this.registry.wipe(event.getGenericType());
        RegistryBlocks.initialize();
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    @SubscribeEvent
    public void registerAdapters(RegistryEvent.Register<RecipeAdapter> event) {
        this.registry.wipe(event.getGenericType());
        RegistryRecipeAdapters.initialize();
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    @SubscribeEvent
    public void registerComponentTypes(RegistryEvent.Register<ComponentType> event) {
        this.registry.wipe(event.getGenericType());
        RegistryComponentTypes.initialize();
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    @SubscribeEvent
    public void registerRequirementTips(RegistryEvent.Register<RequirementTip> event) {
        this.registry.wipe(event.getGenericType());
        RegistryRequirementTips.initialize();
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    @SubscribeEvent
    public void registerComponentRequirementTypes(RegistryEvent.Register event) {
        if (RequirementType.class != event.getGenericType()) {
            return;
        }
        this.registry.wipe(event.getGenericType());
        RegistryRequirementTypes.initialize();
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private <T extends IForgeRegistryEntry<T>> void fillRegistry(Class<T> registrySuperType, IForgeRegistry<T> forgeRegistry) {
        List<?> entries = this.registry.getEntries(registrySuperType);
        if (entries != null) {
            entries.forEach(e -> forgeRegistry.register((IForgeRegistryEntry)e));
        }
    }
}

