/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.util;

import hellfirepvp.modularmachinery.common.util.nbt.NBTMatchingHelper;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;

public class ItemUtils {
    public static void decrStackInInventory(ItemStackHandler handler, int slot) {
        if (slot < 0 || slot >= handler.getSlots()) {
            return;
        }
        ItemStack st = handler.getStackInSlot(slot);
        if (st.func_190926_b()) {
            return;
        }
        st.func_190920_e(st.func_190916_E() - 1);
        if (st.func_190916_E() <= 0) {
            handler.setStackInSlot(slot, ItemStack.field_190927_a);
        }
    }

    public static int consumeFromInventoryFuel(IItemHandlerModifiable handler, int fuelAmtToConsume, boolean simulate, @Nullable NBTTagCompound matchNBTTag) {
        Map<Integer, ItemStack> contents = ItemUtils.findItemsIndexedInInventoryFuel(handler, matchNBTTag);
        if (contents.isEmpty()) {
            return fuelAmtToConsume;
        }
        for (int slot : contents.keySet()) {
            ItemStack inSlot = contents.get(slot);
            if (inSlot.func_77973_b().hasContainerItem(inSlot)) {
                if (inSlot.func_190916_E() > 1) continue;
                ItemStack stack = ForgeHooks.getContainerItem((ItemStack)inSlot);
                fuelAmtToConsume -= TileEntityFurnace.func_145952_a((ItemStack)inSlot);
                if (!simulate) {
                    handler.setStackInSlot(slot, stack.func_77946_l());
                }
                if (fuelAmtToConsume <= 0) break;
            }
            int fuelPer = TileEntityFurnace.func_145952_a((ItemStack)inSlot);
            int toConsumeDiv = fuelAmtToConsume / fuelPer;
            int fuelMod = fuelAmtToConsume % fuelPer;
            int toConsume = toConsumeDiv + (fuelMod > 0 ? 1 : 0);
            int toRemove = toConsume > inSlot.func_190916_E() ? inSlot.func_190916_E() : toConsume;
            fuelAmtToConsume -= toRemove * fuelPer;
            if (!simulate) {
                handler.setStackInSlot(slot, ItemUtils.copyStackWithSize(inSlot, inSlot.func_190916_E() - toRemove));
            }
            if (fuelAmtToConsume > 0) continue;
            break;
        }
        return fuelAmtToConsume;
    }

    public static boolean consumeFromInventory(IItemHandlerModifiable handler, ItemStack toConsume, boolean simulate, @Nullable NBTTagCompound matchNBTTag) {
        Map<Integer, ItemStack> contents = ItemUtils.findItemsIndexedInInventory(handler, toConsume, false, matchNBTTag);
        if (contents.isEmpty()) {
            return false;
        }
        int cAmt = toConsume.func_190916_E();
        for (int slot : contents.keySet()) {
            ItemStack inSlot = contents.get(slot);
            if (inSlot.func_77973_b().hasContainerItem(inSlot)) {
                if (inSlot.func_190916_E() > 1) continue;
                ItemStack stack = ForgeHooks.getContainerItem((ItemStack)inSlot);
                --cAmt;
                if (!simulate) {
                    handler.setStackInSlot(slot, stack.func_77946_l());
                }
                if (cAmt <= 0) break;
            }
            int toRemove = cAmt > inSlot.func_190916_E() ? inSlot.func_190916_E() : cAmt;
            cAmt -= toRemove;
            if (!simulate) {
                handler.setStackInSlot(slot, ItemUtils.copyStackWithSize(inSlot, inSlot.func_190916_E() - toRemove));
            }
            if (cAmt > 0) continue;
            break;
        }
        return cAmt <= 0;
    }

    public static boolean consumeFromInventoryOreDict(IItemHandlerModifiable handler, String oreName, int amount, boolean simulate, @Nullable NBTTagCompound matchNBTTag) {
        Map<Integer, ItemStack> contents = ItemUtils.findItemsIndexedInInventoryOreDict(handler, oreName, matchNBTTag);
        if (contents.isEmpty()) {
            return false;
        }
        int cAmt = amount;
        for (int slot : contents.keySet()) {
            ItemStack inSlot = contents.get(slot);
            if (inSlot.func_77973_b().hasContainerItem(inSlot)) {
                if (inSlot.func_190916_E() > 1) continue;
                ItemStack stack = ForgeHooks.getContainerItem((ItemStack)inSlot);
                --cAmt;
                if (!simulate) {
                    handler.setStackInSlot(slot, stack.func_77946_l());
                }
                if (cAmt <= 0) break;
            }
            int toRemove = cAmt > inSlot.func_190916_E() ? inSlot.func_190916_E() : cAmt;
            cAmt -= toRemove;
            if (!simulate) {
                handler.setStackInSlot(slot, ItemUtils.copyStackWithSize(inSlot, inSlot.func_190916_E() - toRemove));
            }
            if (cAmt > 0) continue;
            break;
        }
        return cAmt <= 0;
    }

    public static int tryPlaceItemInInventory(@Nonnull ItemStack stack, IItemHandlerModifiable handler, boolean simulate) {
        return ItemUtils.tryPlaceItemInInventory(stack, handler, 0, handler.getSlots(), simulate);
    }

    public static int tryPlaceItemInInventory(@Nonnull ItemStack stack, IItemHandlerModifiable handler, int start, int end, boolean simulate) {
        ItemStack toAdd = stack.func_77946_l();
        if (!ItemUtils.hasInventorySpace(toAdd, (IItemHandler)handler, start, end)) {
            return 0;
        }
        int insertedAmt = 0;
        int max = toAdd.func_77976_d();
        for (int i = start; i < end; ++i) {
            ItemStack in = handler.getStackInSlot(i);
            if (in.func_190926_b()) {
                int added = Math.min(stack.func_190916_E(), max);
                stack.func_190920_e(stack.func_190916_E() - added);
                if (!simulate) {
                    handler.setStackInSlot(i, ItemUtils.copyStackWithSize(toAdd, added));
                }
                insertedAmt += added;
                if (stack.func_190916_E() > 0) continue;
                return insertedAmt;
            }
            if (!ItemUtils.stackEqualsNonNBT(toAdd, in) || !ItemUtils.matchTags(toAdd, in)) continue;
            int space = max - in.func_190916_E();
            int added = Math.min(stack.func_190916_E(), space);
            insertedAmt += added;
            stack.func_190920_e(stack.func_190916_E() - added);
            if (!simulate) {
                handler.getStackInSlot(i).func_190920_e(handler.getStackInSlot(i).func_190916_E() + added);
            }
            if (stack.func_190916_E() > 0) continue;
            return insertedAmt;
        }
        return insertedAmt;
    }

    public static boolean hasInventorySpace(@Nonnull ItemStack stack, IItemHandler handler, int rangeMin, int rangeMax) {
        int size = stack.func_190916_E();
        int max = stack.func_77976_d();
        for (int i = rangeMin; i < rangeMax && size > 0; ++i) {
            ItemStack in = handler.getStackInSlot(i);
            if (in.func_190926_b()) {
                size -= max;
                continue;
            }
            if (!ItemUtils.stackEqualsNonNBT(stack, in) || !ItemUtils.matchTags(stack, in)) continue;
            int space = max - in.func_190916_E();
            size -= space;
        }
        return size <= 0;
    }

    public static boolean stackEqualsNonNBT(@Nonnull ItemStack stack, @Nonnull ItemStack other) {
        if (stack.func_190926_b() && other.func_190926_b()) {
            return true;
        }
        if (stack.func_190926_b() || other.func_190926_b()) {
            return false;
        }
        Item sItem = stack.func_77973_b();
        Item oItem = other.func_77973_b();
        if (sItem.func_77614_k() || oItem.func_77614_k()) {
            return sItem.equals(other.func_77973_b()) && (stack.func_77952_i() == other.func_77952_i() || stack.func_77952_i() == Short.MAX_VALUE || other.func_77952_i() == Short.MAX_VALUE);
        }
        return sItem.equals(other.func_77973_b());
    }

    public static boolean matchTags(@Nonnull ItemStack stack, @Nonnull ItemStack other) {
        return ItemStack.func_77970_a((ItemStack)stack, (ItemStack)other);
    }

    @Nonnull
    public static ItemStack copyStackWithSize(@Nonnull ItemStack stack, int amount) {
        if (stack.func_190926_b() || amount <= 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack s = stack.func_77946_l();
        s.func_190920_e(amount);
        return s;
    }

    public static Map<Integer, ItemStack> findItemsIndexedInInventoryFuel(IItemHandlerModifiable handler, @Nullable NBTTagCompound matchNBTTag) {
        HashMap<Integer, ItemStack> stacksOut = new HashMap<Integer, ItemStack>();
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack s = handler.getStackInSlot(j);
            if (TileEntityFurnace.func_145952_a((ItemStack)s) <= 0 || !NBTMatchingHelper.matchNBTCompound(matchNBTTag, s.func_77978_p())) continue;
            stacksOut.put(j, s.func_77946_l());
        }
        return stacksOut;
    }

    public static Map<Integer, ItemStack> findItemsIndexedInInventoryOreDict(IItemHandlerModifiable handler, String oreDict, @Nullable NBTTagCompound matchNBTTag) {
        HashMap<Integer, ItemStack> stacksOut = new HashMap<Integer, ItemStack>();
        for (int j = 0; j < handler.getSlots(); ++j) {
            int[] ids;
            ItemStack s = handler.getStackInSlot(j);
            if (s.func_190926_b()) continue;
            for (int id : ids = OreDictionary.getOreIDs((ItemStack)s)) {
                if (!OreDictionary.getOreName((int)id).equals(oreDict) || !NBTMatchingHelper.matchNBTCompound(matchNBTTag, s.func_77978_p())) continue;
                stacksOut.put(j, s.func_77946_l());
            }
        }
        return stacksOut;
    }

    public static Map<Integer, ItemStack> findItemsIndexedInInventory(IItemHandlerModifiable handler, ItemStack match, boolean strict, @Nullable NBTTagCompound matchNBTTag) {
        HashMap<Integer, ItemStack> stacksOut = new HashMap<Integer, ItemStack>();
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack s = handler.getStackInSlot(j);
            if (!(strict ? ItemUtils.matchStacks(s, match) : ItemUtils.matchStackLoosely(s, match)) || !NBTMatchingHelper.matchNBTCompound(matchNBTTag, s.func_77978_p())) continue;
            stacksOut.put(j, s.func_77946_l());
        }
        return stacksOut;
    }

    public static boolean matchStacks(@Nonnull ItemStack stack, @Nonnull ItemStack other) {
        if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)other)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack, (ItemStack)other);
    }

    public static boolean matchStackLoosely(@Nonnull ItemStack stack, @Nonnull ItemStack other) {
        if (stack.func_190926_b()) {
            return other.func_190926_b();
        }
        return OreDictionary.itemMatches((ItemStack)other, (ItemStack)stack, (boolean)false);
    }
}

