/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.util;

import com.google.common.base.Preconditions;
import com.infinityraider.agricraft.api.v1.util.UnlistedPropertyByte;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.property.IUnlistedProperty;

public class AgriSideMetaMatrix {
    private byte up;
    private byte down;
    private byte north;
    private byte south;
    private byte west;
    private byte east;

    public AgriSideMetaMatrix() {
        this.up = 0;
        this.down = 0;
        this.north = 0;
        this.south = 0;
        this.west = 0;
        this.east = 0;
    }

    public AgriSideMetaMatrix(@Nonnull AgriSideMetaMatrix from) {
        this.up = from.up;
        this.down = from.down;
        this.north = from.north;
        this.south = from.south;
        this.west = from.west;
        this.east = from.east;
    }

    public byte get(@Nonnull EnumFacing side) {
        switch (side) {
            case UP: {
                return this.up;
            }
            case DOWN: {
                return this.down;
            }
            case NORTH: {
                return this.north;
            }
            case SOUTH: {
                return this.south;
            }
            case WEST: {
                return this.west;
            }
            case EAST: {
                return this.east;
            }
        }
        throw new NullPointerException();
    }

    public void set(@Nonnull EnumFacing side, byte value) {
        switch (side) {
            case UP: {
                this.up = value;
                return;
            }
            case DOWN: {
                this.down = value;
                return;
            }
            case NORTH: {
                this.north = value;
                return;
            }
            case SOUTH: {
                this.south = value;
                return;
            }
            case WEST: {
                this.west = value;
                return;
            }
            case EAST: {
                this.east = value;
                return;
            }
        }
        throw new NullPointerException();
    }

    public void writeToNbt(@Nonnull NBTTagCompound tag) {
        Preconditions.checkNotNull((Object)tag);
        for (ConnectionSide side : ConnectionSide.values()) {
            tag.func_74774_a(side.id, this.get(side.aliased));
        }
    }

    public void readFromNbt(@Nonnull NBTTagCompound tag) {
        Preconditions.checkNotNull((Object)tag);
        for (ConnectionSide side : ConnectionSide.values()) {
            if (tag.func_74764_b(side.id)) {
                this.set(side.aliased, tag.func_74771_c(side.id));
                continue;
            }
            this.set(side.aliased, (byte)0);
        }
    }

    public AgriSideMetaMatrix copy() {
        return new AgriSideMetaMatrix(this);
    }

    @Nonnull
    public <T extends IBlockState> T writeToBlockState(@Nonnull T state) {
        Preconditions.checkNotNull(state);
        for (ConnectionSide side : ConnectionSide.values()) {
            state = side.property.setValue(state, this.get(side.aliased));
        }
        return state;
    }

    public void readFromBlockState(@Nonnull IBlockState state) {
        for (ConnectionSide side : ConnectionSide.values()) {
            this.set(side.aliased, side.property.getValue(state, (byte)0));
        }
    }

    public void toString(@Nonnull Consumer<String> consumer) {
        Preconditions.checkNotNull(consumer);
        consumer.accept("Side Meta Matrix:");
        for (EnumFacing side : EnumFacing.field_82609_l) {
            consumer.accept(" - " + side + ": " + this.get(side));
        }
    }

    public static void addUnlistedProperties(Consumer<IUnlistedProperty> consumer) {
        for (ConnectionSide side : ConnectionSide.values()) {
            consumer.accept(side.property);
        }
    }

    public static enum ConnectionSide {
        UP(EnumFacing.UP),
        DOWN(EnumFacing.DOWN),
        NORTH(EnumFacing.NORTH),
        SOUTH(EnumFacing.SOUTH),
        WEST(EnumFacing.WEST),
        EAST(EnumFacing.EAST);

        public static final String ID_PREFIX = "agri_side_meta_";
        public final String id = "agri_side_meta_" + this.name().toLowerCase();
        public final EnumFacing aliased;
        public final UnlistedPropertyByte property;

        private ConnectionSide(EnumFacing aliased) {
            this.aliased = (EnumFacing)Preconditions.checkNotNull((Object)aliased);
            this.property = new UnlistedPropertyByte(this.id);
        }

        @Nonnull
        public static ConnectionSide getFor(@Nonnull EnumFacing side) {
            switch (side) {
                case UP: {
                    return UP;
                }
                case DOWN: {
                    return DOWN;
                }
                case NORTH: {
                    return NORTH;
                }
                case SOUTH: {
                    return SOUTH;
                }
                case WEST: {
                    return WEST;
                }
                case EAST: {
                    return EAST;
                }
            }
            throw new NullPointerException();
        }
    }
}

