/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.robit;

import java.io.IOException;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.button.GuiButtonDisableableImage;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.entity.EntityRobit;
import mekanism.common.inventory.container.robit.ContainerRobitMain;
import mekanism.common.network.PacketRobit;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiRobitMain
extends GuiMekanism {
    private final EntityRobit robit;
    private boolean displayNameChange;
    private GuiTextField nameChangeField;
    private GuiButton confirmName;
    private GuiButton teleportHomeButton;
    private GuiButton pickupButton;
    private GuiButton renameButton;
    private GuiButton followButton;
    private GuiButton mainButton;
    private GuiButton craftingButton;
    private GuiButton inventoryButton;
    private GuiButton smeltingButton;
    private GuiButton repairButton;

    public GuiRobitMain(InventoryPlayer inventory, EntityRobit entity) {
        super(new ContainerRobitMain(inventory, entity));
        this.field_146999_f += 25;
        this.robit = entity;
    }

    private void toggleNameChange() {
        this.confirmName.field_146125_m = this.displayNameChange = !this.displayNameChange;
        this.nameChangeField.func_146195_b(this.displayNameChange);
    }

    private void changeName() {
        if (!this.nameChangeField.func_146179_b().isEmpty()) {
            Mekanism.packetHandler.sendToServer(new PacketRobit.RobitMessage(PacketRobit.RobitPacketType.NAME, this.robit.func_145782_y(), this.nameChangeField.func_146179_b()));
            this.toggleNameChange();
            this.nameChangeField.func_146180_a("");
        }
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton.field_146127_k == this.confirmName.field_146127_k) {
            this.changeName();
        } else if (guibutton.field_146127_k == this.teleportHomeButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketRobit.RobitMessage(PacketRobit.RobitPacketType.GO_HOME, this.robit.func_145782_y(), null));
            this.field_146297_k.func_147108_a(null);
        } else if (guibutton.field_146127_k == this.pickupButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketRobit.RobitMessage(PacketRobit.RobitPacketType.DROP_PICKUP, this.robit.func_145782_y(), null));
        } else if (guibutton.field_146127_k == this.renameButton.field_146127_k) {
            this.toggleNameChange();
        } else if (guibutton.field_146127_k == this.followButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketRobit.RobitMessage(PacketRobit.RobitPacketType.FOLLOW, this.robit.func_145782_y(), null));
        } else if (guibutton.field_146127_k != this.mainButton.field_146127_k) {
            if (guibutton.field_146127_k == this.craftingButton.field_146127_k) {
                MekanismUtils.openEntityGui((EntityPlayer)this.field_146297_k.field_71439_g, (Entity)this.robit, 22);
            } else if (guibutton.field_146127_k == this.inventoryButton.field_146127_k) {
                MekanismUtils.openEntityGui((EntityPlayer)this.field_146297_k.field_71439_g, (Entity)this.robit, 23);
            } else if (guibutton.field_146127_k == this.smeltingButton.field_146127_k) {
                MekanismUtils.openEntityGui((EntityPlayer)this.field_146297_k.field_71439_g, (Entity)this.robit, 24);
            } else if (guibutton.field_146127_k == this.repairButton.field_146127_k) {
                MekanismUtils.openEntityGui((EntityPlayer)this.field_146297_k.field_71439_g, (Entity)this.robit, 25);
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.confirmName = new GuiButton(0, this.field_147003_i + 58, this.field_147009_r + 47, 60, 20, LangUtils.localize("gui.confirm"));
        this.field_146292_n.add(this.confirmName);
        this.confirmName.field_146125_m = this.displayNameChange;
        this.nameChangeField = new GuiTextField(1, this.field_146289_q, this.field_147003_i + 48, this.field_147009_r + 21, 80, 12);
        this.nameChangeField.func_146203_f(12);
        this.nameChangeField.func_146195_b(true);
        this.teleportHomeButton = new GuiButtonDisableableImage(2, this.field_147003_i + 6, this.field_147009_r + 16, 18, 18, 219, 54, -18, this.getGuiLocation());
        this.field_146292_n.add(this.teleportHomeButton);
        this.pickupButton = new GuiButtonDisableableImage(3, this.field_147003_i + 6, this.field_147009_r + 35, 18, 18, 219, 90, -18, this.getGuiLocation());
        this.field_146292_n.add(this.pickupButton);
        this.renameButton = new GuiButtonDisableableImage(4, this.field_147003_i + 6, this.field_147009_r + 54, 18, 18, 201, 234, -18, this.getGuiLocation());
        this.field_146292_n.add(this.renameButton);
        this.followButton = new GuiButtonDisableableImage(5, this.field_147003_i + 152, this.field_147009_r + 54, 18, 18, 201, 198, -18, this.getGuiLocation());
        this.field_146292_n.add(this.followButton);
        this.mainButton = new GuiButtonDisableableImage(6, this.field_147003_i + 179, this.field_147009_r + 10, 18, 18, 201, 18, -18, this.getGuiLocation());
        this.field_146292_n.add(this.mainButton);
        this.craftingButton = new GuiButtonDisableableImage(7, this.field_147003_i + 179, this.field_147009_r + 30, 18, 18, 201, 54, -18, this.getGuiLocation());
        this.field_146292_n.add(this.craftingButton);
        this.inventoryButton = new GuiButtonDisableableImage(8, this.field_147003_i + 179, this.field_147009_r + 50, 18, 18, 201, 90, -18, this.getGuiLocation());
        this.field_146292_n.add(this.inventoryButton);
        this.smeltingButton = new GuiButtonDisableableImage(9, this.field_147003_i + 179, this.field_147009_r + 70, 18, 18, 201, 126, -18, this.getGuiLocation());
        this.field_146292_n.add(this.smeltingButton);
        this.repairButton = new GuiButtonDisableableImage(10, this.field_147003_i + 179, this.field_147009_r + 90, 18, 18, 201, 162, -18, this.getGuiLocation());
        this.field_146292_n.add(this.repairButton);
    }

    public void func_73869_a(char c, int i) throws IOException {
        if (!this.displayNameChange) {
            super.func_73869_a(c, i);
        } else {
            if (i == 28) {
                this.changeName();
            } else if (i == 1) {
                this.field_146297_k.field_71439_g.func_71053_j();
            }
            this.nameChangeField.func_146201_a(c, i);
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.robit"), 76, 6, 0x404040);
        if (!this.displayNameChange) {
            String owner = this.robit.getOwnerName().length() > 14 ? this.robit.getOwnerName().subSequence(0, 14) : this.robit.getOwnerName();
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.robit.greeting") + " " + this.robit.func_70005_c_() + "!", 29, 18, 52480);
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.energy") + ": " + MekanismUtils.getEnergyDisplay(this.robit.getEnergy(), this.robit.MAX_ELECTRICITY), 29, 32, 52480);
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.robit.following") + ": " + this.robit.getFollowing(), 29, 41, 52480);
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.robit.dropPickup") + ": " + this.robit.getDropPickup(), 29, 50, 52480);
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.robit.owner") + ": " + owner, 29, 59, 52480);
        }
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (xAxis >= 28 && xAxis <= 148 && yAxis >= 75 && yAxis <= 79) {
            this.displayTooltip(MekanismUtils.getEnergyDisplay(this.robit.getEnergy(), this.robit.MAX_ELECTRICITY), xAxis, yAxis);
        } else if (this.followButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.robit.toggleFollow"), xAxis, yAxis);
        } else if (this.renameButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.robit.rename"), xAxis, yAxis);
        } else if (this.teleportHomeButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.robit.teleport"), xAxis, yAxis);
        } else if (this.pickupButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.robit.togglePickup"), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        this.func_73729_b(this.field_147003_i + 28, this.field_147009_r + 75, 0, 166, this.getScaledEnergyLevel(120), 4);
        if (this.displayNameChange) {
            this.func_73729_b(this.field_147003_i + 28, this.field_147009_r + 17, 0, 170, 120, 54);
            this.nameChangeField.func_146194_f();
            MekanismRenderer.resetColor();
        }
    }

    private int getScaledEnergyLevel(int i) {
        return (int)(this.robit.getEnergy() * (double)i / this.robit.MAX_ELECTRICITY);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.nameChangeField.func_146178_a();
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        this.nameChangeField.func_146192_a(mouseX, mouseY, button);
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiRobitMain.png");
    }
}

