/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.tesslocator.block.part;

import com.latmod.mods.tesslocator.block.TileTesslocator;
import com.latmod.mods.tesslocator.block.part.TesslocatorPart;
import com.latmod.mods.tesslocator.data.TessNet;
import com.latmod.mods.tesslocator.data.TessNetKey;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public abstract class AdvancedTesslocatorPart
extends TesslocatorPart {
    private static int[] dyes = null;
    public UUID owner = TessNetKey.UUID_00;
    public boolean isPublic = false;
    public int colors = 0;
    private TessNetKey key = null;

    @Nullable
    public static EnumDyeColor getDye(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151100_aR) {
            return EnumDyeColor.func_176766_a((int)stack.func_77960_j());
        }
        if (stack.func_190926_b()) {
            return null;
        }
        if (dyes == null) {
            String[] names = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
            dyes = new int[names.length];
            for (int i = 0; i < dyes.length; ++i) {
                AdvancedTesslocatorPart.dyes[i] = OreDictionary.getOreID((String)names[i]);
            }
        }
        for (int i : OreDictionary.getOreIDs((ItemStack)stack)) {
            for (int index = 0; index < dyes.length; ++index) {
                if (dyes[index] != i) continue;
                return EnumDyeColor.func_176766_a((int)index);
            }
        }
        return null;
    }

    public AdvancedTesslocatorPart(TileTesslocator t, EnumFacing f) {
        super(t, f);
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74772_a("owner_most", this.owner.getMostSignificantBits());
        nbt.func_74772_a("owner_least", this.owner.getLeastSignificantBits());
        if (this.isPublic) {
            nbt.func_74757_a("public", true);
        }
        nbt.func_74774_a("colors", (byte)this.colors);
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.owner = TessNetKey.uuid(nbt.func_74763_f("owner_most"), nbt.func_74763_f("owner_least"));
        this.isPublic = nbt.func_74767_n("public");
        this.colors = nbt.func_74771_c("colors") & 0xFF;
    }

    @Override
    public int getColor(int layer) {
        if (layer == 0) {
            return EnumDyeColor.func_176764_b((int)(this.colors & 0xF)).func_193350_e();
        }
        if (layer == 1) {
            return EnumDyeColor.func_176764_b((int)(this.colors >> 4 & 0xF)).func_193350_e();
        }
        return 0xFFFFFF;
    }

    @Override
    public void onPlaced(EntityPlayer player, ItemStack stack) {
        this.owner = player.func_110124_au();
        this.colors = stack.func_77942_o() ? stack.func_77978_p().func_74771_c("colors") & 0xFF : 0;
    }

    @Override
    public void clearCache() {
        super.clearCache();
        this.key = null;
    }

    public TessNetKey getKey() {
        if (this.key == null) {
            this.key = new TessNetKey(this.owner.getMostSignificantBits(), this.owner.getLeastSignificantBits(), this.colors);
        }
        return this.key;
    }

    @Override
    public void drop(World world, BlockPos pos) {
        ItemStack stack = new ItemStack(this.getType().item.get());
        stack.func_77983_a("colors", (NBTBase)new NBTTagByte((byte)this.colors));
        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
    }

    @Override
    public void onRightClick(EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND && !player.func_184586_b(EnumHand.OFF_HAND).func_190926_b()) {
            EnumDyeColor dyeA = AdvancedTesslocatorPart.getDye(player.func_184586_b(EnumHand.MAIN_HAND));
            EnumDyeColor dyeB = AdvancedTesslocatorPart.getDye(player.func_184586_b(EnumHand.OFF_HAND));
            if (dyeA != null && dyeB != null) {
                this.colors = (dyeA.func_176765_a() | dyeB.func_176765_a() << 4) & 0xFF;
                this.block.func_145836_u();
                this.block.func_70296_d();
                this.block.rerender();
                if (!this.block.func_145831_w().field_72995_K && TessNet.SERVER != null) {
                    TessNet.SERVER.markDirty();
                }
            }
        }
    }
}

