/*
 * Decompiled with CFR 0.152.
 */
package reborncore.api.praescriptum.recipes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import reborncore.api.praescriptum.Utils.LogUtils;
import reborncore.api.praescriptum.ingredients.input.FluidStackInputIngredient;
import reborncore.api.praescriptum.ingredients.input.InputIngredient;
import reborncore.api.praescriptum.ingredients.input.ItemStackInputIngredient;
import reborncore.api.praescriptum.ingredients.input.OreDictionaryInputIngredient;
import reborncore.api.praescriptum.ingredients.output.FluidStackOutputIngredient;
import reborncore.api.praescriptum.ingredients.output.ItemStackOutputIngredient;
import reborncore.api.praescriptum.ingredients.output.OutputIngredient;
import reborncore.api.praescriptum.recipes.RecipeHandler;
import reborncore.common.util.ItemUtils;

public class Recipe
implements Serializable {
    private final RecipeHandler manager;
    private List<InputIngredient> inputIngredients = new ArrayList<InputIngredient>();
    private List<OutputIngredient> outputIngredients = new ArrayList<OutputIngredient>();
    private int energyCostPerTick;
    private int operationDuration;

    public Recipe(RecipeHandler manager) {
        this.manager = manager;
    }

    public Recipe withInput(List<InputIngredient> inputs) {
        this.inputIngredients.addAll(inputs);
        return this;
    }

    public Recipe withInput(ItemStack itemStack) {
        if (ItemUtils.isEmpty(itemStack)) {
            throw new IllegalArgumentException("Input cannot be empty");
        }
        this.inputIngredients.add(ItemStackInputIngredient.of(itemStack));
        return this;
    }

    public Recipe withInput(String oreDict) {
        this.inputIngredients.add(OreDictionaryInputIngredient.of(oreDict));
        return this;
    }

    public Recipe withInput(String oreDict, int amount) {
        if (amount <= 0) {
            throw new IllegalArgumentException("Input cannot be empty");
        }
        this.inputIngredients.add(OreDictionaryInputIngredient.of(oreDict, amount));
        return this;
    }

    public Recipe withInput(String oreDict, int amount, Integer meta) {
        if (amount <= 0) {
            throw new IllegalArgumentException("Input cannot be empty");
        }
        this.inputIngredients.add(OreDictionaryInputIngredient.of(oreDict, amount, meta));
        return this;
    }

    public Recipe withInput(FluidStack fluidStack) {
        if (fluidStack.amount <= 0) {
            throw new IllegalArgumentException("Input cannot be empty");
        }
        this.inputIngredients.add(FluidStackInputIngredient.of(fluidStack));
        return this;
    }

    public Recipe withOutput(List<OutputIngredient> outputs) {
        this.outputIngredients.addAll(outputs);
        return this;
    }

    public Recipe withOutput(ItemStack itemStack) {
        if (ItemUtils.isEmpty(itemStack)) {
            throw new IllegalArgumentException("Output cannot be empty");
        }
        this.outputIngredients.add(ItemStackOutputIngredient.of(itemStack));
        return this;
    }

    public Recipe withOutput(FluidStack fluidStack) {
        if (fluidStack.amount <= 0) {
            throw new IllegalArgumentException("Output cannot be empty");
        }
        this.outputIngredients.add(FluidStackOutputIngredient.of(fluidStack));
        return this;
    }

    public Recipe withEnergyCostPerTick(int energyCostPerTick) {
        if (energyCostPerTick < 0) {
            throw new IllegalArgumentException("Energy cost per tick cannot be less than 0");
        }
        this.energyCostPerTick = energyCostPerTick;
        return this;
    }

    public Recipe withOperationDuration(int operationDuration) {
        if (operationDuration < 0) {
            throw new IllegalArgumentException("Operation duration cannot be less than 0");
        }
        this.operationDuration = operationDuration;
        return this;
    }

    public void register() {
        this.register(false);
    }

    public void register(boolean replace) {
        boolean success = false;
        success = this.manager.addRecipe(this, replace);
        if (!success) {
            LogUtils.LOGGER.warn("Registration failed for input " + this);
        }
    }

    public List<InputIngredient> getInputIngredients() {
        return this.inputIngredients;
    }

    public List<OutputIngredient> getOutputIngredients() {
        return this.outputIngredients;
    }

    public int getEnergyCostPerTick() {
        return this.energyCostPerTick;
    }

    public int getOperationDuration() {
        return this.operationDuration;
    }
}

