/*
 * Decompiled with CFR 0.152.
 */
package reborncore.api.praescriptum.recipes;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import reborncore.api.praescriptum.Utils.IngredientUtils;
import reborncore.api.praescriptum.Utils.LogUtils;
import reborncore.api.praescriptum.ingredients.input.FluidStackInputIngredient;
import reborncore.api.praescriptum.ingredients.input.InputIngredient;
import reborncore.api.praescriptum.ingredients.input.ItemStackInputIngredient;
import reborncore.api.praescriptum.ingredients.output.OutputIngredient;
import reborncore.api.praescriptum.recipes.Recipe;
import reborncore.common.util.ItemUtils;

public class RecipeHandler {
    protected final List<Recipe> recipes = new ArrayList<Recipe>();
    protected final LoadingCache<ImmutableList<InputIngredient>, Recipe> cachedRecipes = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maximumSize(100L).build(ingredients -> this.recipes.stream().filter(recipe -> {
        ArrayList<InputIngredient> listA = new ArrayList<InputIngredient>(recipe.getInputIngredients());
        ingredients.forEach(entry -> listA.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount()));
        return listA.isEmpty();
    }).findAny().orElse(null));

    public Recipe createRecipe() {
        return new Recipe(this);
    }

    public boolean addRecipe(Recipe recipe, boolean replace) {
        Objects.requireNonNull(recipe.getInputIngredients(), "The input input is null");
        if (recipe.getInputIngredients().size() <= 0) {
            throw new IllegalArgumentException("No inputs");
        }
        Objects.requireNonNull(recipe.getOutputIngredients(), "The input output is null");
        if (recipe.getOutputIngredients().size() <= 0) {
            throw new IllegalArgumentException("No outputs");
        }
        ImmutableList listOfInputs = (ImmutableList)recipe.getInputIngredients().stream().filter(IngredientUtils.isIngredientEmpty(ingredient -> LogUtils.LOGGER.warn(String.format("The %s %s is invalid. Skipping...", ingredient.getClass().getSimpleName(), ingredient.toFormattedString())))).collect(ImmutableList.toImmutableList());
        ImmutableList listOfOutputs = (ImmutableList)recipe.getOutputIngredients().stream().filter(IngredientUtils.isIngredientEmpty(ingredient -> LogUtils.LOGGER.warn(String.format("The %s %s is invalid. Skipping...", ingredient.getClass().getSimpleName(), ingredient.toFormattedString())))).collect(ImmutableList.toImmutableList());
        Optional<Recipe> temp = this.getRecipe((ImmutableList<InputIngredient>)listOfInputs);
        if (temp.isPresent()) {
            if (replace) {
                do {
                    if (this.removeRecipe((ImmutableList<InputIngredient>)listOfInputs)) continue;
                    LogUtils.LOGGER.error(String.format("Something went wrong while removing the recipe with inputs %s", listOfInputs));
                } while (this.getRecipe((ImmutableList<InputIngredient>)listOfInputs).isPresent());
            } else {
                LogUtils.LOGGER.error(String.format("Skipping %s => %s due to duplicate input for %s (%s => %s)", listOfInputs, listOfOutputs, listOfInputs, listOfInputs, listOfOutputs));
                return false;
            }
        }
        Recipe newRecipe = this.createRecipe().withInput((List<InputIngredient>)listOfInputs).withOutput((List<OutputIngredient>)listOfOutputs).withEnergyCostPerTick(recipe.getEnergyCostPerTick()).withOperationDuration(recipe.getOperationDuration());
        this.recipes.add(newRecipe);
        return true;
    }

    protected Optional<Recipe> getRecipe(ImmutableList<InputIngredient> ingredients) {
        return this.recipes.stream().filter(recipe -> {
            ArrayList<InputIngredient> listA = new ArrayList<InputIngredient>(recipe.getInputIngredients());
            ingredients.forEach(entry -> listA.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount()));
            return listA.isEmpty();
        }).findAny();
    }

    public Optional<Recipe> findRecipe(ImmutableList<ItemStack> items, ImmutableList<FluidStack> fluids) {
        Stream<ItemStackInputIngredient> itemIngredients = items.stream().filter(stack -> !ItemUtils.isEmpty(stack)).map(ItemStackInputIngredient::copyOf);
        Stream<FluidStackInputIngredient> fluidIngredients = fluids.stream().filter(stack -> stack.amount <= 0).map(FluidStackInputIngredient::copyOf);
        ImmutableList ingredients = (ImmutableList)Stream.concat(itemIngredients, fluidIngredients).collect(ImmutableList.toImmutableList());
        return Optional.ofNullable(this.cachedRecipes.get((ImmutableList<InputIngredient>)ingredients));
    }

    public Optional<Recipe> findAndApply(ImmutableList<ItemStack> items, ImmutableList<FluidStack> fluids, boolean simulate) {
        Stream<FluidStackInputIngredient> fluidIngredients;
        Stream<ItemStackInputIngredient> itemIngredients = items.stream().filter(stack -> !ItemUtils.isEmpty(stack)).map(ItemStackInputIngredient::of);
        ImmutableList ingredients = (ImmutableList)Stream.concat(itemIngredients, fluidIngredients = fluids.stream().filter(stack -> stack.amount <= 0).map(FluidStackInputIngredient::of)).collect(ImmutableList.toImmutableList());
        if (ingredients.isEmpty()) {
            return Optional.empty();
        }
        Optional<Recipe> ret = Optional.ofNullable(this.cachedRecipes.get((ImmutableList<InputIngredient>)ingredients));
        ret.map(recipe -> {
            if (ingredients.size() != recipe.getInputIngredients().size()) {
                return Optional.empty();
            }
            ArrayList<InputIngredient> listA = new ArrayList<InputIngredient>(recipe.getInputIngredients());
            ingredients.forEach(entry -> listA.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount()));
            if (!listA.isEmpty()) {
                return Optional.empty();
            }
            if (!simulate) {
                ArrayList<InputIngredient> listB = new ArrayList<InputIngredient>(recipe.getInputIngredients());
                ingredients.forEach(entry -> listB.removeIf(temp -> {
                    if (temp.matches(entry.ingredient)) {
                        entry.shrink(temp.getCount());
                        return true;
                    }
                    return false;
                }));
            }
            return Optional.of(recipe);
        });
        return ret;
    }

    public boolean apply(Recipe recipe, ImmutableList<ItemStack> items, ImmutableList<FluidStack> fluids, boolean simulate) {
        Stream<FluidStackInputIngredient> fluidIngredients;
        Stream<ItemStackInputIngredient> itemIngredients = items.stream().filter(stack -> !ItemUtils.isEmpty(stack)).map(ItemStackInputIngredient::of);
        ImmutableList ingredients = (ImmutableList)Stream.concat(itemIngredients, fluidIngredients = fluids.stream().filter(stack -> stack.amount <= 0).map(FluidStackInputIngredient::of)).collect(ImmutableList.toImmutableList());
        if (ingredients.size() != recipe.getInputIngredients().size()) {
            return false;
        }
        ArrayList<InputIngredient> listA = new ArrayList<InputIngredient>(recipe.getInputIngredients());
        ingredients.forEach(entry -> listA.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount()));
        if (!listA.isEmpty()) {
            return false;
        }
        if (!simulate) {
            ArrayList<InputIngredient> listB = new ArrayList<InputIngredient>(recipe.getInputIngredients());
            ingredients.forEach(entry -> listB.removeIf(temp -> {
                if (temp.matches(entry.ingredient)) {
                    entry.shrink(temp.getCount());
                    return true;
                }
                return false;
            }));
        }
        return true;
    }

    public boolean removeRecipe(ImmutableList<InputIngredient> ingredients) {
        Recipe recipe = this.getRecipe(ingredients).orElse(null);
        if (recipe == null) {
            return false;
        }
        this.cachedRecipes.invalidate(ingredients);
        return this.recipes.remove(recipe);
    }

    public List<Recipe> getRecipes() {
        return this.recipes;
    }
}

