/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items;

import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.DispenseFluidContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.ItemHandlerHelper;
import reborncore.common.util.FluidUtils;
import reborncore.common.util.StringUtils;
import techreborn.events.TRRecipeHandler;
import techreborn.init.ModItems;
import techreborn.items.ItemTRFluidContainer;
import techreborn.utils.TechRebornCreativeTab;

public class ItemDynamicCell
extends Item {
    public static final int CAPACITY = 1000;

    public ItemDynamicCell() {
        this.func_77637_a(TechRebornCreativeTab.instance);
        this.func_77655_b("techreborn.cell");
        this.func_77625_d(64);
        TRRecipeHandler.hideEntry(this);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)DispenseFluidContainer.getInstance());
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        RayTraceResult target = this.func_77621_a(worldIn, playerIn, true);
        if (target == null || target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)heldItem);
        }
        ItemStack singleContainer = heldItem.func_77946_l();
        singleContainer.func_190920_e(1);
        FluidActionResult filledResult = FluidUtil.tryPickUpFluid((ItemStack)singleContainer, (EntityPlayer)playerIn, (World)worldIn, (BlockPos)target.func_178782_a(), (EnumFacing)target.field_178784_b);
        if (filledResult.isSuccess()) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)filledResult.result);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                heldItem.func_190918_g(1);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)heldItem);
        }
        FluidActionResult emptiedResult = FluidUtil.tryPlaceFluid((EntityPlayer)playerIn, (World)worldIn, (BlockPos)target.func_178782_a().func_177972_a(target.field_178784_b), (ItemStack)singleContainer, (FluidStack)FluidUtils.getFluidHandler((ItemStack)singleContainer).drain(1000, false));
        if (emptiedResult.isSuccess()) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)emptiedResult.result);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                heldItem.func_190918_g(1);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)heldItem);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public boolean tryAddCellToInventory(EntityPlayer player, ItemStack stack, Fluid fluid) {
        if (player.field_71071_by.func_70441_a(ItemDynamicCell.getCellWithFluid(fluid))) {
            stack.func_190918_g(1);
            return true;
        }
        return false;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        subItems.add((Object)ItemDynamicCell.getEmptyCell(1));
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            subItems.add((Object)ItemDynamicCell.getCellWithFluid(fluid));
        }
    }

    public String func_77653_i(ItemStack stack) {
        FluidStack fluidStack = FluidUtils.getFluidContained((ItemStack)stack);
        if (fluidStack == null) {
            return super.func_77653_i(stack);
        }
        return StringUtils.t((String)"item.techreborn.cell.fluid.name").replaceAll("\\$fluid\\$", fluidStack.getLocalizedName());
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ItemTRFluidContainer(stack);
    }

    public static ItemStack getCellWithFluid(Fluid fluid, int stackSize) {
        ItemStack ret = new ItemStack((Item)ModItems.CELL);
        ItemTRFluidContainer fluidHandler = new ItemTRFluidContainer(ret);
        if (fluidHandler.fill(new FluidStack(fluid, 1000), true) == 1000) {
            ret = fluidHandler.getContainer();
        }
        ret.func_190920_e(stackSize);
        return ret;
    }

    public static ItemStack getEmptyCell(int amount) {
        return new ItemStack((Item)ModItems.CELL, amount);
    }

    public static ItemStack getCellWithFluid(Fluid fluid) {
        return ItemDynamicCell.getCellWithFluid(fluid, 1);
    }
}

