/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.ForgeHooks;
import sonar.core.utils.Pair;

public class RayTraceHelper {
    @Nonnull
    public static Pair<RayTraceResult, AxisAlignedBB> rayTraceBoxes(BlockPos pos, Vec3d start, Vec3d end, List<AxisAlignedBB> boxes) {
        Vec3d vec3d = start.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        Vec3d vec3d1 = end.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        RayTraceResult raytraceresult = null;
        AxisAlignedBB currentBB = null;
        for (AxisAlignedBB bb : boxes) {
            raytraceresult = bb.func_72327_a(vec3d, vec3d1);
            if (raytraceresult == null) continue;
            currentBB = bb;
            break;
        }
        return raytraceresult == null ? new Pair<Object, Object>(null, null) : new Pair<RayTraceResult, AxisAlignedBB>(new RayTraceResult(raytraceresult.field_72307_f.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), raytraceresult.field_178784_b, pos), currentBB);
    }

    public static double getBlockReach(EntityPlayer player) {
        double blockReachDistance = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        return blockReachDistance + 1.0;
    }

    public static Pair<Vec3d, Vec3d> getPlayerLookVec(EntityPlayer entity) {
        double length = RayTraceHelper.getBlockReach(entity);
        Vec3d startPos = new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v);
        Vec3d endPos = startPos.func_178787_e(new Vec3d(entity.func_70040_Z().field_72450_a * length, entity.func_70040_Z().field_72448_b * length, entity.func_70040_Z().field_72449_c * length));
        return new Pair<Vec3d, Vec3d>(startPos, endPos);
    }

    public static Pair<Vec3d, Vec3d> getStandardLookVec(Entity entity, double reach) {
        Vec3d startPos = new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v);
        Vec3d endPos = startPos.func_178787_e(new Vec3d(entity.func_70040_Z().field_72450_a * reach, entity.func_70040_Z().field_72448_b * reach, entity.func_70040_Z().field_72449_c * reach));
        return new Pair<Vec3d, Vec3d>(startPos, endPos);
    }

    public static RayTraceResult getRayTraceEyes(EntityPlayer player) {
        return ForgeHooks.rayTraceEyes((EntityLivingBase)player, (double)RayTraceHelper.getBlockReach(player));
    }
}

