/*
 * Decompiled with CFR 0.152.
 */
package hqbanana.skycompression.base.tools;

import com.bartz24.skyresources.recipe.ProcessRecipe;
import hqbanana.skycompression.AdditionalProcessRecipesManager;
import hqbanana.skycompression.SkyCompression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class ItemCompressedWaterExtractor
extends Item
implements IFluidHandler {
    public static final int MAX_WATER_MB = 20000;
    FluidTank tank;

    public ItemCompressedWaterExtractor(String name) {
        this.func_77655_b("sc." + name);
        this.setRegistryName(name);
        this.func_77637_a(SkyCompression.SKY_COMPRESSION_TAB);
        this.field_77777_bU = 1;
        this.tank = new FluidTank(new FluidStack(FluidRegistry.WATER, 0), 20000);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 70000;
    }

    public ItemStack onItemUseFinish(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!world.field_72995_K && timeLeft <= this.func_77626_a(stack) - 25) {
                Vec3d vec3d = player.func_174791_d().func_72441_c(0.0, (double)player.eyeHeight, 0.0);
                Vec3d vec3d1 = player.func_70040_Z();
                Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * 5.0, vec3d1.field_72448_b * 5.0, vec3d1.field_72449_c * 5.0);
                RayTraceResult rayTrace = world.func_147447_a(vec3d, vec3d2, false, false, true);
                if (rayTrace != null) {
                    BlockPos pos = rayTrace.func_178782_a();
                    EnumFacing blockHitSide = rayTrace.field_178784_b;
                    Block block = world.func_180495_p(pos).func_177230_c();
                    ProcessRecipe recipe = AdditionalProcessRecipesManager.compressedWaterExtractorExtractionRecipes.getRecipe((Object)new ItemStack(block, 1, block.func_176201_c(world.func_180495_p(pos))), 0.0f, false, false);
                    if (recipe != null) {
                        for (int x = -1; x <= 1; ++x) {
                            for (int y = -1; y <= 1; ++y) {
                                for (int z = -1; z <= 1; ++z) {
                                    ProcessRecipe radiusBlockRecipe;
                                    BlockPos blockPos = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                                    Block radiusBlock = world.func_180495_p(blockPos).func_177230_c();
                                    if (block != radiusBlock || (radiusBlockRecipe = AdditionalProcessRecipesManager.compressedWaterExtractorExtractionRecipes.getRecipe((Object)new ItemStack(radiusBlock, 1, radiusBlock.func_176201_c(world.func_180495_p(blockPos))), 0.0f, false, false)) == null) continue;
                                    IBlockState recipeOut = Block.func_149634_a((Item)((ItemStack)radiusBlockRecipe.getOutputs().get(0)).func_77973_b()).func_176203_a(((ItemStack)radiusBlockRecipe.getOutputs().get(0)).func_77960_j());
                                    int newAmount = 0;
                                    newAmount = this.GetCompound(stack).func_74762_e("amount") + this.tank.fill(((FluidStack)radiusBlockRecipe.getFluidOutputs().get(0)).copy(), true) <= 20000 ? this.GetCompound(stack).func_74762_e("amount") + this.tank.fill(((FluidStack)radiusBlockRecipe.getFluidOutputs().get(0)).copy(), true) : 20000;
                                    this.GetCompound(stack).func_74768_a("amount", newAmount);
                                    this.tank.getFluid().amount = this.GetCompound(stack).func_74762_e("amount");
                                    world.func_180501_a(blockPos, radiusBlockRecipe.getOutputs().get(0) == ItemStack.field_190927_a ? Blocks.field_150350_a.func_176223_P() : recipeOut, 3);
                                }
                            }
                        }
                        world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187806_ee, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
                        return;
                    }
                    if (world.func_180495_p(pos.func_177971_a(blockHitSide.func_176730_m())) == Blocks.field_150355_j.func_176223_P() && this.GetCompound(stack).func_74762_e("amount") < 20000) {
                        world.func_175698_g(pos.func_177971_a(blockHitSide.func_176730_m()));
                        int newAmount = 0;
                        newAmount = this.GetCompound(stack).func_74762_e("amount") + 1000 <= 20000 ? this.GetCompound(stack).func_74762_e("amount") + 1000 : 20000;
                        this.GetCompound(stack).func_74768_a("amount", newAmount);
                        world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187806_ee, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
                    }
                }
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        ItemStack stack = playerIn.func_184586_b(hand);
        this.tank.setFluid(new FluidStack(FluidRegistry.WATER, this.GetCompound(stack).func_74762_e("amount")));
        if (world.func_175625_s(pos) instanceof IFluidHandler) {
            IFluidHandler tile = (IFluidHandler)world.func_175625_s(pos);
            this.GetCompound(stack).func_74768_a("amount", stack.func_77978_p().func_74762_e("amount") - tile.fill(this.tank.getFluid(), true));
            this.tank.getFluid().amount = this.GetCompound(stack).func_74762_e("amount");
            return EnumActionResult.SUCCESS;
        }
        ProcessRecipe recipe = AdditionalProcessRecipesManager.compressedWaterExtractorInsertionRecipes.getRecipe(new ArrayList<Object>(Arrays.asList(new ItemStack(block, 1, block.func_176201_c(world.func_180495_p(pos))), this.tank.getFluid().copy())), 0.0f, false, false);
        if (recipe != null) {
            IBlockState recipeOut = Block.func_149634_a((Item)((ItemStack)recipe.getOutputs().get(0)).func_77973_b()).func_176203_a(((ItemStack)recipe.getOutputs().get(0)).func_77960_j());
            world.func_180501_a(pos, recipeOut, 3);
            this.GetCompound(stack).func_74768_a("amount", stack.func_77978_p().func_74762_e("amount") - ((FluidStack)recipe.getFluidInputs().get((int)0)).amount);
            this.tank.getFluid().amount = this.GetCompound(stack).func_74762_e("amount");
            world.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187806_ee, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
            return EnumActionResult.SUCCESS;
        }
        if (this.GetCompound(stack).func_74762_e("amount") >= 1000 && playerIn.func_70093_af()) {
            if (block == Blocks.field_150431_aC && (Integer)blockState.func_177229_b((IProperty)BlockSnow.field_176315_a) < 1) {
                side = EnumFacing.UP;
            } else if (!block.func_176200_f((IBlockAccess)world, pos)) {
                pos = pos.func_177972_a(side);
            }
            if (!playerIn.func_175151_a(pos, side, stack) || stack.func_190916_E() == 0) {
                return EnumActionResult.FAIL;
            }
            if (FluidUtil.tryPlaceFluid((EntityPlayer)playerIn, (World)world, (BlockPos)pos, (IFluidHandler)this.tank, (FluidStack)this.tank.getFluid())) {
                this.GetCompound(stack).func_74768_a("amount", this.GetCompound(stack).func_74762_e("amount") - 1000);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.FAIL;
    }

    public NBTTagCompound GetCompound(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            this.func_77622_d(stack, null, null);
        }
        compound = stack.func_77978_p();
        return compound;
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer player) {
        itemStack.func_77982_d(new NBTTagCompound());
        itemStack.func_77978_p().func_74768_a("amount", 0);
        this.tank.getFluid().amount = itemStack.func_77978_p().func_74762_e("amount");
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null) {
            int filled = this.tank.fill(resource, doFill);
            return filled;
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource != null) {
            return this.tank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77978_p() != null) {
            tooltip.add("Water: " + stack.func_77978_p().func_74762_e("amount") + "mB");
        } else {
            tooltip.add("Water: 0 mb");
        }
        tooltip.add("Extracts water in a 3x3x3 area around the block you're looking at");
    }

    public int getMaxAmount() {
        return 20000;
    }
}

