/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.button.GuiButtonDisableableImage;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.inventory.container.ContainerUpgradeManagement;
import mekanism.common.network.PacketRemoveUpgrade;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiUpgradeManagement
extends GuiMekanism {
    private GuiButton backButton;
    private GuiButton removeButton;
    private IUpgradeTile tileEntity;
    private Upgrade selectedType;
    private boolean isDragging = false;
    private int dragOffset = 0;
    private int supportedIndex;
    private int delay;
    private float scroll;

    public GuiUpgradeManagement(InventoryPlayer inventory, IUpgradeTile tile) {
        super(new ContainerUpgradeManagement(inventory, tile));
        this.tileEntity = tile;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.backButton = new GuiButtonDisableableImage(0, this.field_147003_i + 6, this.field_147009_r + 6, 14, 14, 176, 14, -14, this.getGuiLocation());
        this.field_146292_n.add(this.backButton);
        this.removeButton = new GuiButtonDisableableImage(1, this.field_147003_i + 136, this.field_147009_r + 57, 12, 12, 190, 12, -12, 12, this.getGuiLocation());
        this.field_146292_n.add(this.removeButton);
        this.updateEnabledButtons();
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        TileEntity tile = (TileEntity)this.tileEntity;
        if (guibutton.field_146127_k == this.backButton.field_146127_k) {
            int guiId = BlockStateMachine.MachineType.get((Block)tile.func_145838_q(), (int)tile.func_145832_p()).guiId;
            Mekanism.packetHandler.sendToServer(new PacketSimpleGui.SimpleGuiMessage(Coord4D.get(tile), 0, guiId));
        } else if (guibutton.field_146127_k == this.removeButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketRemoveUpgrade.RemoveUpgradeMessage(Coord4D.get(tile), this.selectedType.ordinal()));
        }
    }

    private boolean overUpgradeType(int xAxis, int yAxis, int xPos, int yPos) {
        return xAxis >= xPos && xAxis <= xPos + 58 && yAxis >= yPos && yAxis <= yPos + 12;
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.delay < 40) {
            ++this.delay;
        } else {
            this.delay = 0;
            ++this.supportedIndex;
            this.supportedIndex %= this.tileEntity.getComponent().getSupportedTypes().size();
        }
        this.updateEnabledButtons();
    }

    private void updateEnabledButtons() {
        this.removeButton.field_146124_l = this.selectedType != null;
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        int index;
        Upgrade[] supported;
        this.field_146297_k.field_71446_o.func_110577_a(this.getGuiLocation());
        this.func_73729_b(84, 8 + this.getScroll(), 202, 0, 4, 4);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.upgrades.supported") + ":", 26, 59, 0x404040);
        if (this.selectedType == null) {
            this.renderText(LangUtils.localize("gui.upgrades.noSelection") + ".", 92, 8, 0.8f, true);
        } else {
            int amount = this.tileEntity.getComponent().getUpgrades(this.selectedType);
            this.renderText(this.selectedType.getName() + " " + LangUtils.localize("gui.upgrade"), 92, 8, 0.6f, true);
            this.renderText(LangUtils.localize("gui.upgrades.amount") + ": " + amount + "/" + this.selectedType.getMax(), 92, 16, 0.6f, true);
            int text = 0;
            for (String s : this.selectedType.getInfo((TileEntity)this.tileEntity)) {
                this.renderText(s, 92, 22 + 6 * text++, 0.6f, true);
            }
        }
        if (!this.tileEntity.getComponent().getSupportedTypes().isEmpty() && (supported = this.tileEntity.getComponent().getSupportedTypes().toArray(new Upgrade[0])).length > this.supportedIndex) {
            this.renderUpgrade(supported[this.supportedIndex], 80, 57, 0.8f, true);
            this.field_146289_q.func_78276_b(supported[this.supportedIndex].getName(), 96, 59, 0x404040);
        }
        Upgrade[] upgrades = this.getCurrentUpgrades().toArray(new Upgrade[0]);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        for (int i = 0; i < 4 && (index = this.getUpgradeIndex() + i) <= upgrades.length - 1; ++i) {
            Upgrade upgrade = upgrades[index];
            int xPos = 25;
            int yPos = 7 + i * 12;
            this.field_146289_q.func_78276_b(upgrade.getName(), xPos + 12, yPos + 2, 0x404040);
            this.renderUpgrade(upgrade, xPos + 2, yPos + 2, 0.5f, true);
            if (!this.overUpgradeType(xAxis, yAxis, xPos, yPos)) continue;
            this.displayTooltips(MekanismUtils.splitTooltip(upgrade.getDescription(), upgrade.getStack()), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    private void renderText(String text, int x, int y, float size, boolean scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)size, (float)size, (float)size);
        this.field_146289_q.func_78276_b(text, scale ? (int)(1.0f / size * (float)x) : x, scale ? (int)(1.0f / size * (float)y) : y, 52480);
        GlStateManager.func_179121_F();
    }

    private void renderUpgrade(Upgrade type, int x, int y, float size, boolean scale) {
        if (scale) {
            this.renderItem(type.getStack(), (int)((float)x / size), (int)((float)y / size), size);
        } else {
            this.renderItem(type.getStack(), x, y, size);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        int index;
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        int displayInt = this.tileEntity.getComponent().getScaledUpgradeProgress(14);
        this.func_73729_b(this.field_147003_i + 154, this.field_147009_r + 26, 176, 28, 10, displayInt);
        if (this.selectedType != null && this.tileEntity.getComponent().getUpgrades(this.selectedType) == 0) {
            this.selectedType = null;
        }
        Upgrade[] upgrades = this.getCurrentUpgrades().toArray(new Upgrade[0]);
        for (int i = 0; i < 4 && (index = this.getUpgradeIndex() + i) <= upgrades.length - 1; ++i) {
            Upgrade upgrade = upgrades[index];
            int xPos = 25;
            int yPos = 7 + i * 12;
            int yRender = upgrade == this.selectedType ? 190 : (this.overUpgradeType(xAxis, yAxis, xPos, yPos) ? 166 : 178);
            MekanismRenderer.color(upgrade.getColor(), 1.0f, 2.5f);
            this.func_73729_b(this.field_147003_i + xPos, this.field_147009_r + yPos, 0, yRender, 58, 12);
            MekanismRenderer.resetColor();
        }
    }

    private Set<Upgrade> getCurrentUpgrades() {
        return this.tileEntity.getComponent().getInstalledTypes();
    }

    public int getScroll() {
        return Math.max(Math.min((int)(this.scroll * 42.0f), 42), 0);
    }

    public int getUpgradeIndex() {
        if (this.getCurrentUpgrades().size() <= 4) {
            return 0;
        }
        return (int)((float)this.getCurrentUpgrades().size() * this.scroll - 4.0f / (float)this.getCurrentUpgrades().size() * this.scroll);
    }

    @Override
    protected void func_146273_a(int mouseX, int mouseY, int button, long ticks) {
        super.func_146273_a(mouseX, mouseY, button, ticks);
        if (this.isDragging) {
            int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
            this.scroll = Math.min(Math.max((float)(yAxis - 8 - this.dragOffset) / 42.0f, 0.0f), 1.0f);
        }
    }

    @Override
    protected void func_146286_b(int mouseX, int mouseY, int type) {
        super.func_146286_b(mouseX, mouseY, type);
        if (type == 0 && this.isDragging) {
            this.dragOffset = 0;
            this.isDragging = false;
        }
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiUpgradeManagement.png");
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        if (button == 0) {
            int xAxis = mouseX - this.field_147003_i;
            int yAxis = mouseY - this.field_147009_r;
            if (xAxis >= 84 && xAxis <= 88 && yAxis >= this.getScroll() + 8 && yAxis <= this.getScroll() + 8 + 4) {
                if (this.getCurrentUpgrades().size() > 4) {
                    this.dragOffset = yAxis - (this.getScroll() + 8);
                    this.isDragging = true;
                } else {
                    this.scroll = 0.0f;
                }
            }
            int counter = 0;
            for (Upgrade upgrade : this.getCurrentUpgrades()) {
                int yPos;
                int xPos = 25;
                if (!this.overUpgradeType(xAxis, yAxis, xPos, yPos = 7 + counter++ * 12)) continue;
                this.selectedType = upgrade;
                break;
            }
        }
    }
}

