/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.filter;

import java.io.IOException;
import mekanism.api.Coord4D;
import mekanism.client.gui.button.GuiButtonDisableableImage;
import mekanism.client.gui.filter.GuiTextFilterBase;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerFilter;
import mekanism.common.network.PacketEditFilter;
import mekanism.common.network.PacketNewFilter;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.tile.TileEntityOredictionificator;
import mekanism.common.util.ItemRegistryUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

@SideOnly(value=Side.CLIENT)
public class GuiOredictionificatorFilter
extends GuiTextFilterBase<TileEntityOredictionificator.OredictionificatorFilter, TileEntityOredictionificator> {
    private GuiButton saveButton;
    private GuiButton deleteButton;
    private GuiButton backButton;
    private GuiButton prevButton;
    private GuiButton nextButton;
    private GuiButton checkboxButton;

    public GuiOredictionificatorFilter(EntityPlayer player, TileEntityOredictionificator tile, int index) {
        super(tile, new ContainerFilter(player.field_71071_by, tile));
        this.origFilter = ((TileEntityOredictionificator)this.tileEntity).filters.get(index);
        this.filter = ((TileEntityOredictionificator)this.tileEntity).filters.get(index).clone();
        this.updateRenderStack();
    }

    public GuiOredictionificatorFilter(EntityPlayer player, TileEntityOredictionificator tile) {
        super(tile, new ContainerFilter(player.field_71071_by, tile));
        this.filter = new TileEntityOredictionificator.OredictionificatorFilter();
        this.isNew = true;
    }

    @Override
    protected void addButtons() {
        this.saveButton = new GuiButton(0, this.field_147003_i + 31, this.field_147009_r + 62, 54, 20, LangUtils.localize("gui.save"));
        this.field_146292_n.add(this.saveButton);
        this.deleteButton = new GuiButton(1, this.field_147003_i + 89, this.field_147009_r + 62, 54, 20, LangUtils.localize("gui.delete"));
        this.field_146292_n.add(this.deleteButton);
        this.backButton = new GuiButtonDisableableImage(2, this.field_147003_i + 5, this.field_147009_r + 5, 11, 11, 212, 11, -11, this.getGuiLocation());
        this.field_146292_n.add(this.backButton);
        this.prevButton = new GuiButtonDisableableImage(3, this.field_147003_i + 31, this.field_147009_r + 21, 12, 12, 200, 12, -12, this.getGuiLocation());
        this.field_146292_n.add(this.prevButton);
        this.nextButton = new GuiButtonDisableableImage(4, this.field_147003_i + 63, this.field_147009_r + 21, 12, 12, 188, 12, -12, this.getGuiLocation());
        this.field_146292_n.add(this.nextButton);
        this.checkboxButton = new GuiButtonDisableableImage(5, this.field_147003_i + 130, this.field_147009_r + 48, 12, 12, 176, 12, -12, this.getGuiLocation());
        this.field_146292_n.add(this.checkboxButton);
    }

    @Override
    protected void sendPacketToServer(int guiID) {
        Mekanism.packetHandler.sendToServer(new PacketSimpleGui.SimpleGuiMessage(Coord4D.get(this.tileEntity), 0, guiID));
    }

    @Override
    public void setText() {
        String newFilter = this.text.func_146179_b();
        if (TileEntityOredictionificator.possibleFilters.stream().anyMatch(newFilter::startsWith)) {
            ((TileEntityOredictionificator.OredictionificatorFilter)this.filter).filter = newFilter;
            ((TileEntityOredictionificator.OredictionificatorFilter)this.filter).index = 0;
            this.text.func_146180_a("");
            this.updateRenderStack();
        }
        this.updateButtons();
    }

    public void updateButtons() {
        this.saveButton.field_146124_l = ((TileEntityOredictionificator.OredictionificatorFilter)this.filter).filter != null && !((TileEntityOredictionificator.OredictionificatorFilter)this.filter).filter.isEmpty();
        this.deleteButton.field_146124_l = !this.isNew;
    }

    @Override
    protected GuiTextField createTextField() {
        return new GuiTextField(2, this.field_146289_q, this.field_147003_i + 33, this.field_147009_r + 48, 96, 12);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.updateButtons();
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        String text = (this.isNew ? LangUtils.localize("gui.new") : LangUtils.localize("gui.edit")) + " " + LangUtils.localize("gui.filter");
        this.field_146289_q.func_78276_b(text, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(text) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.index") + ": " + ((TileEntityOredictionificator.OredictionificatorFilter)this.filter).index, 79, 23, 0x404040);
        if (((TileEntityOredictionificator.OredictionificatorFilter)this.filter).filter != null) {
            this.renderScaledText(((TileEntityOredictionificator.OredictionificatorFilter)this.filter).filter, 32, 38, 0x404040, 111);
        }
        this.renderItem(this.renderStack, 45, 19);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (xAxis >= 31 && xAxis <= 43 && yAxis >= 21 && yAxis <= 33) {
            this.displayTooltip(LangUtils.localize("gui.lastItem"), xAxis, yAxis);
        } else if (xAxis >= 63 && xAxis <= 75 && yAxis >= 21 && yAxis <= 33) {
            this.displayTooltip(LangUtils.localize("gui.nextItem"), xAxis, yAxis);
        } else if (xAxis >= 33 && xAxis <= 129 && yAxis >= 48 && yAxis <= 60) {
            this.displayTooltip(LangUtils.localize("gui.oreDictCompat"), xAxis, yAxis);
        } else if (xAxis >= 45 && xAxis <= 61 && yAxis >= 19 && yAxis <= 35 && !this.renderStack.func_190926_b()) {
            String name = ItemRegistryUtils.getMod(this.renderStack);
            String extra = name.equals("null") ? "" : " (" + name + ")";
            this.displayTooltip(this.renderStack.func_82833_r() + extra, xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        this.text.func_146194_f();
        MekanismRenderer.resetColor();
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == this.saveButton.field_146127_k) {
            if (!this.text.func_146179_b().isEmpty()) {
                this.setText();
            }
            if (((TileEntityOredictionificator.OredictionificatorFilter)this.filter).filter != null && !((TileEntityOredictionificator.OredictionificatorFilter)this.filter).filter.isEmpty()) {
                if (this.isNew) {
                    Mekanism.packetHandler.sendToServer(new PacketNewFilter.NewFilterMessage(Coord4D.get(this.tileEntity), this.filter));
                } else {
                    Mekanism.packetHandler.sendToServer(new PacketEditFilter.EditFilterMessage(Coord4D.get(this.tileEntity), false, this.origFilter, this.filter));
                }
                this.sendPacketToServer(52);
            }
        } else if (guibutton.field_146127_k == this.deleteButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketEditFilter.EditFilterMessage(Coord4D.get(this.tileEntity), true, this.origFilter, null));
            this.sendPacketToServer(52);
        } else if (guibutton.field_146127_k == this.backButton.field_146127_k) {
            this.sendPacketToServer(52);
        } else if (guibutton.field_146127_k == this.prevButton.field_146127_k) {
            if (((TileEntityOredictionificator.OredictionificatorFilter)this.filter).filter != null) {
                NonNullList ores = OreDictionary.getOres((String)((TileEntityOredictionificator.OredictionificatorFilter)this.filter).filter, (boolean)false);
                ((TileEntityOredictionificator.OredictionificatorFilter)this.filter).index = ((TileEntityOredictionificator.OredictionificatorFilter)this.filter).index > 0 ? --((TileEntityOredictionificator.OredictionificatorFilter)this.filter).index : ores.size() - 1;
                this.updateRenderStack();
            }
        } else if (guibutton.field_146127_k == this.nextButton.field_146127_k) {
            if (((TileEntityOredictionificator.OredictionificatorFilter)this.filter).filter != null) {
                NonNullList ores = OreDictionary.getOres((String)((TileEntityOredictionificator.OredictionificatorFilter)this.filter).filter, (boolean)false);
                ((TileEntityOredictionificator.OredictionificatorFilter)this.filter).index = ((TileEntityOredictionificator.OredictionificatorFilter)this.filter).index < ores.size() - 1 ? ++((TileEntityOredictionificator.OredictionificatorFilter)this.filter).index : 0;
                this.updateRenderStack();
            }
        } else if (guibutton.field_146127_k == this.checkboxButton.field_146127_k) {
            this.setText();
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        this.text.func_146192_a(mouseX, mouseY, button);
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiOredictionificatorFilter.png");
    }

    private void updateRenderStack() {
        if (((TileEntityOredictionificator.OredictionificatorFilter)this.filter).filter == null || ((TileEntityOredictionificator.OredictionificatorFilter)this.filter).filter.isEmpty()) {
            this.renderStack = ItemStack.field_190927_a;
            return;
        }
        NonNullList stacks = OreDictionary.getOres((String)((TileEntityOredictionificator.OredictionificatorFilter)this.filter).filter, (boolean)false);
        if (stacks.isEmpty()) {
            this.renderStack = ItemStack.field_190927_a;
            return;
        }
        this.renderStack = stacks.size() - 1 >= ((TileEntityOredictionificator.OredictionificatorFilter)this.filter).index ? ((ItemStack)stacks.get(((TileEntityOredictionificator.OredictionificatorFilter)this.filter).index)).func_77946_l() : ItemStack.field_190927_a;
    }
}

