/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.util.comparator;

import ic2.core.block.base.util.comparator.IComparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class ComparatorManager {
    public String[] sides = new String[7];
    public int[] valueSides = new int[7];
    public byte[] byteValues = new byte[7];
    public boolean[] staticSides = new boolean[7];
    public boolean[] inverted = new boolean[7];
    public boolean[] byteSide = new boolean[7];
    public Map<String, IComparator> comparators = new HashMap<String, IComparator>();
    TileEntity tile;

    public ComparatorManager(TileEntity entity) {
        this.tile = entity;
    }

    public void addComparatorMode(IComparator comparator) {
        String id = comparator.getID();
        if (this.comparators.containsKey(id)) {
            return;
        }
        this.comparators.put(id, comparator);
    }

    public void removeComparator(String id) {
        this.comparators.remove(id);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.sides = new String[7];
        this.staticSides = new boolean[7];
        this.byteSide = new boolean[7];
        this.inverted = new boolean[7];
        NBTTagList list = nbt.func_150295_c("Data", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            String id = data.func_74779_i("ID");
            if (!this.comparators.containsKey(id)) continue;
            int side = data.func_74762_e("Slot");
            this.sides[side] = id;
            this.staticSides[side] = data.func_74767_n("Static");
            this.byteSide[side] = data.func_74767_n("ByteValue");
            this.inverted[side] = data.func_74767_n("Inverted");
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < 7; ++i) {
            if (this.sides[i] == null) continue;
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("Slot", (byte)i);
            data.func_74778_a("ID", this.sides[i]);
            data.func_74757_a("Static", this.staticSides[i]);
            data.func_74757_a("ByteValue", this.byteSide[i]);
            data.func_74757_a("Inverted", this.inverted[i]);
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("Data", (NBTBase)list);
    }

    public int getValue(EnumFacing side) {
        return this.valueSides[side == null ? 6 : side.func_176745_a()];
    }

    public byte getByteValue(EnumFacing side) {
        return this.byteValues[side == null ? 6 : side.func_176745_a()];
    }

    public boolean isInverted(EnumFacing side) {
        int index = side == null ? 6 : side.func_176745_a();
        return this.inverted[index];
    }

    public boolean shouldBeStatic(EnumFacing side) {
        int index = side == null ? 6 : side.func_176745_a();
        return this.staticSides[index];
    }

    public boolean shouldBeByte(EnumFacing side) {
        int index = side == null ? 6 : side.func_176745_a();
        return this.byteSide[index];
    }

    private void updateValues(boolean forced) {
        if (this.tile.func_145831_w().func_82737_E() % 5L != 0L && !forced) {
            return;
        }
        boolean requiresUpdate = false;
        for (int i = 0; i < 7; ++i) {
            String id = this.sides[i];
            if (id == null) {
                if (this.valueSides[i] == 0) continue;
                this.valueSides[i] = 0;
                this.byteValues[i] = 0;
                requiresUpdate = true;
                continue;
            }
            IComparator comp = this.comparators.get(id);
            if (comp == null) {
                this.sides[i] = null;
                if (this.valueSides[i] == 0) continue;
                this.valueSides[i] = 0;
                this.byteValues[i] = 0;
                requiresUpdate = true;
                continue;
            }
            int newValue = comp.getNormalValue();
            byte newByteValue = comp.getByteValue();
            if (this.valueSides[i] != newValue) {
                requiresUpdate = true;
            }
            this.valueSides[i] = newValue;
            this.byteValues[i] = newByteValue;
        }
        if (requiresUpdate || forced) {
            this.tile.func_145831_w().func_175666_e(this.tile.func_174877_v(), this.tile.func_145838_q());
        }
    }

    public void forceUpdate() {
        this.updateValues(true);
    }

    public void update() {
        this.updateValues(false);
    }
}

