/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tile;

import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.custom.ILiquidFuelGeneratorRegistry;
import ic2.api.classic.tile.machine.IFuelMachine;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityFuelGeneratorBase;
import ic2.core.block.generator.container.ContainerLiquidFuelGenerator;
import ic2.core.fluid.IC2Fluid;
import ic2.core.fluid.IC2Tank;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.filters.InvertedFilter;
import ic2.core.inventory.gui.custom.MachineGui;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Resources;
import ic2.core.util.math.Box2D;
import ic2.core.util.misc.FluidHelper;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IClickable;
import ic2.core.util.obj.ITankListener;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityLiquidFuelGenerator
extends TileEntityFuelGeneratorBase
implements IFluidHandler,
IFuelMachine,
ITankListener,
IClickable {
    @NetworkField(index=7)
    public IC2Tank tank = new IC2Tank(16000);
    public float subProduction;
    @NetworkField(index=8)
    public float fluidProduction = 0.0f;
    @NetworkField(index=9)
    public float maxFuel = 0.0f;
    public float config;

    public TileEntityLiquidFuelGenerator() {
        super(2);
        this.addGuiFields("tank", "fluidProduction", "maxFuel");
        this.tank.addListener(this);
        this.maxStorage = 10000;
        this.production = 32;
        this.config = (float)IC2.config.getInt("liquidGenerator") / 100.0f;
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, 0, 1);
        handler.registerDefaultSlotsForSide(RotationList.DOWN, 0);
        handler.registerDefaultSlotsForSide(RotationList.ALL, 1);
        handler.registerInputFilter(LiquidFuelFilter.fluidFilter, 1);
        handler.registerOutputFilter(new InvertedFilter(LiquidFuelFilter.fluidFilter), 1);
        handler.registerInputFilter(CommonFilters.ChargeEU, 0);
        handler.registerSlotType(SlotType.Charge, 0);
        handler.registerSlotType(SlotType.FluidFuel, 1);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt.func_74775_l("Tank"));
        this.subProduction = nbt.func_74760_g("SubProduction");
        this.fluidProduction = nbt.func_74760_g("FluidProduction");
        this.maxFuel = nbt.func_74760_g("MaxFuel");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.tank.writeToNBT(this.getTag(nbt, "Tank"));
        nbt.func_74776_a("SubProduction", this.subProduction);
        nbt.func_74776_a("FluidProduction", this.fluidProduction);
        nbt.func_74776_a("MaxFuel", this.maxFuel);
        return nbt;
    }

    @Override
    public ResourceLocation getOperationSoundFile() {
        return new ResourceLocation("ic2", "sounds/Generators/WatermillLoop.ogg");
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerLiquidFuelGenerator(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return MachineGui.LiquidFuelGui.class;
    }

    @Override
    public ResourceLocation getTexture() {
        return Ic2Resources.liquidFuelGenerator;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.liquidFuelGenerator;
    }

    @Override
    public Box2D getFuelBox() {
        return Ic2GuiComp.liquidGeneratorFuelBox;
    }

    @Override
    public Box2D getEnergyBox() {
        return Ic2GuiComp.liquidFuelEnergyBox;
    }

    @Override
    public boolean delayActiveUpdate() {
        return true;
    }

    @Override
    public int getDelay() {
        return 60;
    }

    @Override
    public float getFuel() {
        return this.fuel;
    }

    @Override
    public float getMaxFuel() {
        return this.maxFuel;
    }

    @Override
    public int getOutput() {
        return (int)this.fluidProduction;
    }

    @Override
    public boolean gainEnergy() {
        if (this.isConverting()) {
            --this.fuel;
            this.getNetwork().updateTileGuiField(this, "fuel");
            this.subProduction += this.fluidProduction * this.config;
            int toAdd = (int)this.subProduction;
            if (toAdd > 0) {
                this.subProduction -= (float)toAdd;
                this.storage += toAdd;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean gainFuel() {
        int toAdd;
        ILiquidFuelGeneratorRegistry.BurnEntry entry;
        FluidStack drained;
        if (this.fuel <= 0 && this.tank.getFluidAmount() > 0 && (drained = this.tank.drainInternal(1000, false)) != null && (entry = this.getEntry(drained.getFluid())) != null && (toAdd = (int)((float)entry.getTicksLast() * ((float)drained.amount / 1000.0f))) >= 1) {
            this.tank.drainInternal(1000, true);
            this.fuel += toAdd;
            this.maxFuel = toAdd;
            this.fluidProduction = entry.getProduction();
            this.getNetwork().updateTileGuiField(this, "fuel");
            this.getNetwork().updateTileGuiField(this, "maxFuel");
            this.getNetwork().updateTileGuiField(this, "fluidProduction");
        }
        if (this.tank.hasRoom() && !((ItemStack)this.inventory.get(1)).func_190926_b()) {
            if (StackUtil.isStackEqual((ItemStack)this.inventory.get(1), Ic2Items.woodGasCell)) {
                if (this.tank.fill(IC2Fluid.getFluidStack("woodgas", 1000), true) >= 1000) {
                    ((ItemStack)this.inventory.get(1)).func_190918_g(1);
                    return true;
                }
                return false;
            }
            return FluidHelper.drainContainers(this, this, 1);
        }
        return false;
    }

    @Override
    public void onTankChanged(IFluidTank tank) {
        this.getNetwork().updateTileGuiField(this, "tank");
    }

    @Override
    public boolean needsFuel() {
        return this.fuel <= 0 && this.tank.getFluidAmount() > 0 || this.tank.hasRoom() && !((ItemStack)this.inventory.get(1)).func_190926_b();
    }

    public ILiquidFuelGeneratorRegistry.BurnEntry getEntry(Fluid fluid) {
        return ClassicRecipes.fluidGenerator.getBurnEntry(fluid);
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && this.getEntry(resource.getFluid()) != null) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.tank.drain(resource, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasRightClick() {
        return true;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, EnumHand hand, EnumFacing face, Side side) {
        FluidActionResult result;
        ItemStack playerStack = player.func_184586_b(hand);
        if (!playerStack.func_190926_b() && (result = FluidUtil.tryEmptyContainer((ItemStack)playerStack, (IFluidHandler)this, (int)(this.tank.getCapacity() - this.tank.getFluidAmount()), (EntityPlayer)player, (boolean)true)).isSuccess()) {
            playerStack.func_190918_g(1);
            ItemStack resultStack = result.getResult();
            if (!resultStack.func_190926_b()) {
                if (!player.field_71071_by.func_70441_a(resultStack)) {
                    player.func_71019_a(resultStack, false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasLeftClick() {
        return false;
    }

    @Override
    public void onLeftClick(EntityPlayer player, Side side) {
    }

    public static class LiquidFuelFilter
    implements IFilter {
        public static IFilter fluidFilter = new LiquidFuelFilter();

        @Override
        public boolean matches(ItemStack stack) {
            if (stack.func_190926_b()) {
                return false;
            }
            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
            if (fluid != null) {
                return ClassicRecipes.fluidGenerator.getBurnEntry(fluid.getFluid()) != null;
            }
            return false;
        }
    }
}

