/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.misc.tile;

import ic2.api.classic.energy.tile.IEnergyConductorColored;
import ic2.api.classic.event.RetextureEventClassic;
import ic2.api.classic.network.adv.NetworkField;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.block.base.util.texture.ICopyEntry;
import ic2.core.block.base.util.texture.TextureCopyStorage;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class TileEntityTexturedWall
extends TileEntityBlock {
    @NetworkField(index=3)
    public TextureCopyStorage storage = new TextureCopyStorage(6);

    public TileEntityTexturedWall() {
        this.addNetworkFields("storage");
    }

    public boolean changeColor(IEnergyConductorColored.WireColor color, EnumFacing facing) {
        if (this.storage.getColor(facing) == color) {
            return false;
        }
        this.storage.set(facing.func_176745_a(), color);
        this.getNetwork().updateTileEntityField(this, "storage");
        return true;
    }

    @Override
    public void onNetworkUpdate(String field) {
        super.onNetworkUpdate(field);
        if (field.equals("storage")) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.readFromNBT(nbt.func_74775_l("Storage"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.storage.writeToNBT(this.getTag(nbt, "Storage"));
        return nbt;
    }

    public TextureCopyStorage getStorage() {
        return this.storage;
    }

    public boolean add(EnumFacing targetSide, IBlockState model, IBlockState render, int[] color, RetextureEventClassic.Rotation[] rot, EnumFacing facing) {
        if (this.storage.isColored(targetSide.func_176745_a())) {
            this.storage.set(targetSide.func_176745_a(), model, render, color, rot, facing);
            this.getNetwork().updateTileEntityField(this, "storage");
            return true;
        }
        ICopyEntry entry = this.storage.getEntry(targetSide.func_176745_a());
        if (entry.getModelState() == model && entry.getRenderState() == render && entry.getSide() == facing) {
            return false;
        }
        this.storage.set(targetSide.func_176745_a(), model, render, color, rot, facing);
        this.getNetwork().updateTileEntityField(this, "storage");
        return true;
    }
}

