/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy;

import com.google.common.base.Objects;
import com.google.common.math.DoubleMath;
import ic2.api.classic.energy.IPacketEnergyNet;
import ic2.api.classic.energy.PacketStat;
import ic2.api.classic.energy.tile.IEnergySourceInfo;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.NodeStats;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.energy.tile.IMetaDelegate;
import ic2.api.energy.tile.IMultiEnergySource;
import ic2.api.info.ILocatable;
import ic2.core.Direction;
import ic2.core.IC2;
import ic2.core.energy.EnergyNetGrid;
import ic2.core.energy.EnergyNetPathMap;
import ic2.core.entity.IC2DamageSource;
import ic2.core.entity.explosion.ExplosionIC2;
import ic2.core.platform.capabilities.energy.SinkLimiterHandler;
import ic2.core.platform.registry.Ic2Capabilities;
import ic2.core.util.helpers.AabbUtil;
import ic2.core.util.helpers.FilteredList;
import ic2.core.util.math.IntCounter;
import ic2.core.util.math.LongCounter;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class EnergyNetLocal {
    private EnergyNetPathMap energySourceToEnergyPathMap = new EnergyNetPathMap(this);
    Map<EntityLivingBase, Integer> entityLivingToShockEnergyMap = new LinkedHashMap<EntityLivingBase, Integer>();
    private Map<BlockPos, EnergyTileContainer> registeredTiles = new HashMap<BlockPos, EnergyTileContainer>();
    private Map<BlockPos, IEnergySource> sources = new LinkedHashMap<BlockPos, IEnergySource>();
    private Map<IEnergyTile, TargetList> connections = new LinkedHashMap<IEnergyTile, TargetList>();
    private Map<EnergyNetGrid.GridID, EnergyNetGrid> grids = new LinkedHashMap<EnergyNetGrid.GridID, EnergyNetGrid>();
    private Map<IEnergyTile, EnergyNetGrid.GridID> conductorGrids = new LinkedHashMap<IEnergyTile, EnergyNetGrid.GridID>();
    private Set<EnergyNetGrid.GridID> dirtyGrids = new LinkedHashSet<EnergyNetGrid.GridID>();
    private Set<EnergyNetGrid.GridID> splittingGrids = new LinkedHashSet<EnergyNetGrid.GridID>();
    private Set<ConnectingEntry> connectingTodo = new LinkedHashSet<ConnectingEntry>();
    public static boolean easyMode;
    public static boolean burn;
    public static float chance;
    World world;

    public EnergyNetLocal(World world) {
        this.world = world;
    }

    public int emitEnergyFrom(BlockPos pos, IEnergySource energySource, int amount) {
        if (!this.registeredTiles.containsKey(pos)) {
            IC2.log.warn("EnergyNet.emitEnergyFrom: " + energySource + " is not added to the enet");
            return amount;
        }
        Set<EnergyPath> paths = this.energySourceToEnergyPathMap.get(energySource);
        if (paths.isEmpty()) {
            return amount;
        }
        LinkedList<EnergyPath> activeEnergyPaths = new LinkedList<EnergyPath>();
        double totalInvLoss = 0.0;
        int energyWithLoss = amount;
        for (EnergyPath path : paths) {
            if (path.target.getDemandedEnergy() < 1.0 || path.loss >= (double)amount || easyMode && this.hasWeakConductors(path, amount)) continue;
            totalInvLoss += 1.0 / path.loss;
            energyWithLoss -= (int)path.loss;
            activeEnergyPaths.add(path);
        }
        if (activeEnergyPaths.isEmpty()) {
            return amount;
        }
        Collections.shuffle(activeEnergyPaths);
        while (activeEnergyPaths.size() - energyWithLoss > 0 && activeEnergyPaths.size() > 0) {
            EnergyPath path = (EnergyPath)activeEnergyPaths.removeLast();
            totalInvLoss -= 1.0 / path.loss;
            energyWithLoss += (int)path.loss;
        }
        if (activeEnergyPaths.isEmpty()) {
            return amount;
        }
        int sourceTier = (int)EnergyNet.instance.getPowerFromTier(this.getSourceTier(energySource));
        LinkedHashMap<EnergyPath, IntCounter> suppliedEnergyPaths = new LinkedHashMap<EnergyPath, IntCounter>();
        while (!activeEnergyPaths.isEmpty() && amount > 0) {
            int energyConsumed = 0;
            double newTotalInvLoss = 0.0;
            LinkedList<EnergyPath> currentActiveEnergyPaths = activeEnergyPaths;
            activeEnergyPaths = new LinkedList();
            for (EnergyPath energyPath : currentActiveEnergyPaths) {
                int energyLoss;
                IEnergySink target = energyPath.target;
                int n = (int)Math.floor((double)Math.round((double)amount / totalInvLoss / energyPath.loss * 100000.0) / 100000.0);
                if (n > (energyLoss = (int)Math.floor(energyPath.loss))) {
                    int providing = n - energyLoss;
                    int adding = (int)Math.min((double)providing, target.getDemandedEnergy());
                    if (adding <= 0) continue;
                    int maxInput = this.getMaxEnergyInput(target);
                    if (providing > maxInput) {
                        if (easyMode) continue;
                        this.explodeTiles(target);
                        continue;
                    }
                    double energyReturned = target.injectEnergy(energyPath.targetdirection.toFacing(), adding, sourceTier);
                    if (energyReturned == 0.0) {
                        if (target.getDemandedEnergy() >= 1.0) {
                            activeEnergyPaths.add(energyPath);
                            newTotalInvLoss += 1.0 / energyPath.loss;
                        }
                    } else if (energyReturned >= (double)(n - energyLoss)) {
                        energyReturned = n - energyLoss;
                        IC2.log.warn("API ERROR: " + target + " didn't implement demandsEnergy() properly, no energy from injectEnergy accepted although demandsEnergy() returned true.");
                    }
                    energyConsumed = (int)((double)energyConsumed + ((double)adding - energyReturned + (double)energyLoss));
                    int energyInjected = (int)((double)adding - energyReturned);
                    if (energyInjected <= 0) continue;
                    IntCounter counter = (IntCounter)suppliedEnergyPaths.get(energyPath);
                    if (counter == null) {
                        counter = new IntCounter();
                        suppliedEnergyPaths.put(energyPath, counter);
                    }
                    counter.increase(energyInjected);
                    continue;
                }
                activeEnergyPaths.add(energyPath);
                newTotalInvLoss += 1.0 / energyPath.loss;
            }
            if (energyConsumed == 0 && !activeEnergyPaths.isEmpty()) {
                newTotalInvLoss -= 1.0 / ((EnergyPath)activeEnergyPaths.remove((int)(activeEnergyPaths.size() - 1))).loss;
            }
            totalInvLoss = newTotalInvLoss;
            amount -= energyConsumed;
        }
        for (Map.Entry entry : suppliedEnergyPaths.entrySet()) {
            EnergyPath path = (EnergyPath)entry.getKey();
            int injectedEnergy = ((IntCounter)entry.getValue()).getValue();
            path.totalEnergyConducted += (long)injectedEnergy;
            this.addPacket(path, injectedEnergy);
            if (injectedEnergy > path.minInsulationEnergyAbsorption) {
                LinkedHashMap<EntityLivingBase, IntCounter> shockMap = new LinkedHashMap<EntityLivingBase, IntCounter>();
                List entitiesNearEnergyPath = this.world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)(path.minX - 1), (double)(path.minY - 1), (double)(path.minZ - 1), (double)(path.maxX + 2), (double)(path.maxY + 2), (double)(path.maxZ + 2)));
                for (IEnergyConductor iEnergyConductor : path.conductors) {
                    int shockAbsorbing = (int)iEnergyConductor.getInsulationEnergyAbsorption();
                    if (shockAbsorbing >= injectedEnergy) continue;
                    AxisAlignedBB conductorBox = new AxisAlignedBB(EnergyNetLocal.coords(iEnergyConductor)).func_186662_g(1.0);
                    for (EntityLivingBase entity : entitiesNearEnergyPath) {
                        int shockEnergy;
                        if (!entity.func_174813_aQ().func_72326_a(conductorBox) || (shockEnergy = injectedEnergy - shockAbsorbing) <= 0) continue;
                        IntCounter counter = (IntCounter)shockMap.get(entity);
                        if (counter == null) {
                            counter = new IntCounter();
                            shockMap.put(entity, counter);
                        }
                        counter.setIfHigher(shockEnergy);
                    }
                }
                if (shockMap.size() > 0) {
                    for (Map.Entry entry2 : shockMap.entrySet()) {
                        EntityLivingBase base = (EntityLivingBase)entry2.getKey();
                        if (this.entityLivingToShockEnergyMap.containsKey(base)) {
                            this.entityLivingToShockEnergyMap.put(base, ((IntCounter)entry2.getValue()).getValue() + this.entityLivingToShockEnergyMap.get(base));
                            continue;
                        }
                        this.entityLivingToShockEnergyMap.put(base, ((IntCounter)entry2.getValue()).getValue());
                    }
                }
            }
            if (injectedEnergy >= path.minInsulationBreakdownEnergy) {
                for (IEnergyConductor conductor : path.conductors) {
                    if (!((double)injectedEnergy >= conductor.getInsulationBreakdownEnergy())) continue;
                    conductor.removeInsulation();
                    if (conductor.getInsulationEnergyAbsorption() >= (double)path.minInsulationEnergyAbsorption) continue;
                    path.minInsulationEnergyAbsorption = (int)conductor.getInsulationEnergyAbsorption();
                }
            }
            if (injectedEnergy < path.minConductorBreakdownEnergy || easyMode) continue;
            for (IEnergyConductor conductor : path.conductors) {
                if (!((double)injectedEnergy >= conductor.getConductorBreakdownEnergy())) continue;
                conductor.removeConductor();
                this.removeTile(conductor);
            }
        }
        return amount;
    }

    public List<EnergyPath> discoverTargets(IEnergyTile emitter, Set<IEnergyTile> targets, Set<IEnergyConductor> allowedPaths, boolean reverse, int lossLimit) {
        boolean whiteList = allowedPaths.size() > 0;
        boolean anything = targets.isEmpty();
        HashSet<IEnergyTile> toDo = new HashSet<IEnergyTile>(targets);
        HashMap<IEnergyTile, EnergyBlockLink> reachedTileEntities = new HashMap<IEnergyTile, EnergyBlockLink>();
        LinkedList<IEnergyTile> tileEntitiesToCheck = new LinkedList<IEnergyTile>();
        tileEntitiesToCheck.add(emitter);
        ArrayList<IEnergyTile> reachedTargets = new ArrayList<IEnergyTile>(targets.isEmpty() ? 20 : targets.size());
        while (tileEntitiesToCheck.size() > 0) {
            IEnergyTile currentTile = (IEnergyTile)tileEntitiesToCheck.remove();
            if (!(currentTile instanceof ILocatable) && ((TileEntity)currentTile).func_145837_r()) continue;
            BlockPos pos = EnergyNetLocal.coords(currentTile);
            double currentLoss = 0.0;
            if (this.registeredTiles.containsKey(pos) && this.registeredTiles.get((Object)pos).tile != emitter && reachedTileEntities.containsKey(currentTile)) {
                currentLoss = ((EnergyBlockLink)reachedTileEntities.get((Object)currentTile)).loss;
            }
            List<EnergyTarget> list = this.getTarget(currentTile).get(reverse);
            for (EnergyTarget validReceiver : list) {
                EnergyBlockLink link;
                IEnergyTile tile = validReceiver.targetTile;
                if (tile == emitter) continue;
                boolean wire = tile instanceof IEnergyConductor;
                if (whiteList && wire && !allowedPaths.contains(tile)) continue;
                double additionalLoss = 0.0;
                if (wire) {
                    additionalLoss = ((IEnergyConductor)validReceiver.targetTile).getConductionLoss();
                    if (additionalLoss < 1.0E-4) {
                        additionalLoss = 1.0E-4;
                    }
                    if (currentLoss + additionalLoss >= (double)lossLimit) continue;
                }
                if ((link = (EnergyBlockLink)reachedTileEntities.get(tile)) != null && link.loss <= currentLoss + additionalLoss) continue;
                if (!reverse && tile instanceof IEnergySink) {
                    if (!anything && !targets.contains(tile)) continue;
                    toDo.remove(tile);
                    if (anything) {
                        reachedTargets.add(tile);
                    }
                } else if (reverse && tile instanceof IEnergySource) {
                    if (!anything && !targets.contains(tile)) continue;
                    toDo.remove(tile);
                    if (anything) {
                        reachedTargets.add(tile);
                    }
                }
                reachedTileEntities.put(tile, new EnergyBlockLink(validReceiver, currentLoss + additionalLoss));
                if (!wire) continue;
                tileEntitiesToCheck.remove(tile);
                tileEntitiesToCheck.add(tile);
            }
        }
        if (!anything) {
            reachedTargets.addAll(targets);
            reachedTargets.removeAll(toDo);
        }
        ArrayList<EnergyPath> energyPaths = new ArrayList<EnergyPath>(reachedTargets.size());
        for (IEnergyTile tile : reachedTargets) {
            EnergyBlockLink energyBlockLink;
            if ((!reverse || !(tile instanceof IEnergySource)) && (reverse || !(tile instanceof IEnergySink)) || (energyBlockLink = (EnergyBlockLink)reachedTileEntities.get(tile)) == null) continue;
            EnergyPath path = new EnergyPath();
            if (energyBlockLink.loss > 0.1) {
                int max;
                path.loss = energyBlockLink.loss;
                if (reverse && path.loss > (double)(max = this.getMaxEnergy((IEnergySource)tile))) {
                    continue;
                }
            } else {
                path.loss = 0.1;
            }
            if (reverse) {
                path.emitter = (IEnergySource)tile;
                path.emitterDirection = energyBlockLink.direction;
                path.pathSteps.add(EnergyNetLocal.coords(tile));
                path.pathSteps.add(energyBlockLink.targetPos);
            } else {
                path.target = (IEnergySink)tile;
                path.targetdirection = energyBlockLink.direction.getInverse();
                path.pathSteps.add(EnergyNetLocal.coords(tile));
                path.pathSteps.add(energyBlockLink.targetPos);
            }
            while (true) {
                if ((tile = energyBlockLink.next) == emitter) {
                    if (!reverse && emitter instanceof IEnergySource) {
                        path.emitter = (IEnergySource)emitter;
                        path.emitterDirection = energyBlockLink.direction.getInverse();
                        path.pathSteps.add(energyBlockLink.nextPos);
                        path.pathSteps.add(EnergyNetLocal.coords(energyBlockLink.next));
                        Collections.reverse(path.conductors);
                        Collections.reverse(path.pathSteps);
                        break;
                    }
                    if (!reverse || !(emitter instanceof IEnergySink)) break;
                    path.target = (IEnergySink)emitter;
                    path.targetdirection = energyBlockLink.direction;
                    path.pathSteps.add(energyBlockLink.nextPos);
                    path.pathSteps.add(EnergyNetLocal.coords(energyBlockLink.next));
                    break;
                }
                if (!(tile instanceof IEnergyConductor)) break;
                IEnergyConductor energyConductor = (IEnergyConductor)tile;
                BlockPos pos = energyBlockLink.nextPos;
                path.pathSteps.add(pos);
                if (pos.func_177958_n() < path.minX) {
                    path.minX = pos.func_177958_n();
                }
                if (pos.func_177956_o() < path.minY) {
                    path.minY = pos.func_177956_o();
                }
                if (pos.func_177952_p() < path.minZ) {
                    path.minZ = pos.func_177952_p();
                }
                if (pos.func_177958_n() > path.maxX) {
                    path.maxX = pos.func_177958_n();
                }
                if (pos.func_177956_o() > path.maxY) {
                    path.maxY = pos.func_177956_o();
                }
                if (pos.func_177952_p() > path.maxZ) {
                    path.maxZ = pos.func_177952_p();
                }
                path.conductors.add(energyConductor);
                if (energyConductor.getInsulationEnergyAbsorption() < (double)path.minInsulationEnergyAbsorption) {
                    path.minInsulationEnergyAbsorption = (int)energyConductor.getInsulationEnergyAbsorption();
                }
                if (energyConductor.getInsulationBreakdownEnergy() < (double)path.minInsulationBreakdownEnergy) {
                    path.minInsulationBreakdownEnergy = (int)energyConductor.getInsulationBreakdownEnergy();
                }
                if (energyConductor.getConductorBreakdownEnergy() < (double)path.minConductorBreakdownEnergy) {
                    path.minConductorBreakdownEnergy = (int)energyConductor.getConductorBreakdownEnergy();
                }
                if ((energyBlockLink = (EnergyBlockLink)reachedTileEntities.get(tile)) != null) continue;
                IC2.platform.displayError("An energy network pathfinding entry is corrupted.\nThis could happen due to incorrect Minecraft behavior or a bug.\n\n(Technical information: energyBlockLink, tile entities below)\nE: " + emitter + " (" + EnergyNetLocal.coords(emitter) + ")\nC: " + tile + " (" + pos + ")\nR: " + path.target + " (" + EnergyNetLocal.coords(path.target) + ")");
            }
            if (path.target == null || path.emitter == null) continue;
            energyPaths.add(path);
        }
        return energyPaths;
    }

    public List<EnergyTarget> getValidReceivers(IEnergyTile emitter, boolean reverse) {
        boolean meta = emitter instanceof IMetaDelegate;
        ArrayList<EnergyTarget> targets = new ArrayList<EnergyTarget>(meta ? ((IMetaDelegate)emitter).getSubTiles().size() * 6 : 10);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            IEnergyAcceptor receiver;
            IEnergyEmitter sender;
            if (meta) {
                List<IEnergyTile> tiles = ((IMetaDelegate)emitter).getSubTiles();
                for (IEnergyTile subTile : tiles) {
                    IEnergyAcceptor receiver2;
                    IEnergyEmitter sender2;
                    EnergyTileContainer cont = this.getContainer(EnergyNetLocal.coords(subTile).func_177972_a(facing));
                    if (cont == null || cont.tile == null || cont.tile == emitter) continue;
                    if (reverse) {
                        IEnergyEmitter iEnergyEmitter = cont.subTile instanceof IEnergyEmitter ? (IEnergyEmitter)cont.subTile : (sender2 = cont.tile instanceof IEnergyEmitter ? (IEnergyEmitter)cont.tile : null);
                        IEnergyAcceptor iEnergyAcceptor = subTile instanceof IEnergyAcceptor ? (IEnergyAcceptor)subTile : (receiver2 = emitter instanceof IEnergyAcceptor ? (IEnergyAcceptor)emitter : null);
                        if (sender2 == null || receiver2 == null || !sender2.emitsEnergyTo(receiver2, facing.func_176734_d()) || !receiver2.acceptsEnergyFrom(sender2, facing)) continue;
                        targets.add(new EnergyTarget(cont.tile, cont.getPos(), Direction.fromEnumFacing(facing.func_176734_d()), emitter, EnergyNetLocal.coords(subTile)));
                        continue;
                    }
                    IEnergyEmitter iEnergyEmitter = subTile instanceof IEnergyEmitter ? (IEnergyEmitter)subTile : (sender2 = emitter instanceof IEnergyEmitter ? (IEnergyEmitter)emitter : null);
                    IEnergyAcceptor iEnergyAcceptor = cont.subTile instanceof IEnergyAcceptor ? (IEnergyAcceptor)cont.subTile : (receiver2 = cont.tile instanceof IEnergyAcceptor ? (IEnergyAcceptor)cont.tile : null);
                    if (sender2 == null || receiver2 == null || !sender2.emitsEnergyTo(receiver2, facing) || !receiver2.acceptsEnergyFrom(sender2, facing.func_176734_d())) continue;
                    targets.add(new EnergyTarget(cont.tile, cont.getPos(), Direction.fromEnumFacing(facing.func_176734_d()), emitter, EnergyNetLocal.coords(subTile)));
                }
                continue;
            }
            EnergyTileContainer cont = this.getContainer(EnergyNetLocal.coords(emitter).func_177972_a(facing));
            if (cont == null || cont.tile == null || cont.tile == emitter) continue;
            if (reverse) {
                sender = cont.subTile instanceof IEnergyEmitter ? (IEnergyEmitter)cont.subTile : (cont.tile instanceof IEnergyEmitter ? (IEnergyEmitter)cont.tile : null);
                IEnergyAcceptor iEnergyAcceptor = receiver = emitter instanceof IEnergyAcceptor ? (IEnergyAcceptor)emitter : null;
                if (sender == null || receiver == null || !sender.emitsEnergyTo(receiver, facing.func_176734_d()) || !receiver.acceptsEnergyFrom(sender, facing)) continue;
                targets.add(new EnergyTarget(cont.tile, cont.getPos(), Direction.fromEnumFacing(facing.func_176734_d()), emitter, EnergyNetLocal.coords(emitter)));
                continue;
            }
            IEnergyEmitter iEnergyEmitter = sender = emitter instanceof IEnergyEmitter ? (IEnergyEmitter)emitter : null;
            IEnergyAcceptor iEnergyAcceptor = cont.subTile instanceof IEnergyAcceptor ? (IEnergyAcceptor)cont.subTile : (receiver = cont.tile instanceof IEnergyAcceptor ? (IEnergyAcceptor)cont.tile : null);
            if (sender == null || receiver == null || !sender.emitsEnergyTo(receiver, facing) || !receiver.acceptsEnergyFrom(sender, facing.func_176734_d())) continue;
            targets.add(new EnergyTarget(cont.tile, cont.getPos(), Direction.fromEnumFacing(facing.func_176734_d()), emitter, EnergyNetLocal.coords(emitter)));
        }
        return targets;
    }

    private boolean hasWeakConductors(EnergyPath path, int energyToSend) {
        if (path.minConductorBreakdownEnergy > energyToSend) {
            return false;
        }
        for (IEnergyConductor wire : path.conductors) {
            if (!(wire.getConductorBreakdownEnergy() <= (double)energyToSend)) continue;
            return true;
        }
        return false;
    }

    public void onTickStart() {
        if (this.entityLivingToShockEnergyMap.size() > 0) {
            for (Map.Entry<EntityLivingBase, Integer> entry : this.entityLivingToShockEnergyMap.entrySet()) {
                EntityLivingBase target = entry.getKey();
                int damage = (entry.getValue() + 63) / 64;
                if (!target.func_70089_S() || damage <= 0) continue;
                target.func_70097_a((DamageSource)IC2DamageSource.electricity, (float)damage);
                if (!(target instanceof EntityPlayer)) continue;
                IC2.achievements.issueStat((EntityPlayer)target, "cableShockDamage", damage);
            }
            this.entityLivingToShockEnergyMap.clear();
        }
    }

    public void onTickEnd() {
        IEnergySource source;
        EnergyNetGrid grid;
        ArrayList<EnergyNetGrid.GridID> processed;
        if (this.splittingGrids.size() > 0) {
            while (this.splittingGrids.size() > 0) {
                processed = new ArrayList<EnergyNetGrid.GridID>(this.splittingGrids);
                this.splittingGrids = new HashSet<EnergyNetGrid.GridID>();
                for (EnergyNetGrid.GridID gridID : processed) {
                    grid = this.grids.get(gridID);
                    if (grid == null) continue;
                    if (!grid.hasConductors()) {
                        this.grids.remove(gridID);
                        continue;
                    }
                    grid.processChanges();
                }
            }
        }
        if (this.dirtyGrids.size() > 0) {
            while (this.dirtyGrids.size() > 0) {
                processed = new ArrayList<EnergyNetGrid.GridID>(this.dirtyGrids);
                this.dirtyGrids = new HashSet<EnergyNetGrid.GridID>();
                for (EnergyNetGrid.GridID gridID : processed) {
                    grid = this.grids.get(gridID);
                    if (grid == null) continue;
                    if (!grid.hasConductors()) {
                        this.grids.remove(gridID);
                        continue;
                    }
                    grid.processChanges();
                }
            }
        }
        if (this.connectingTodo.size() > 0) {
            LinkedHashMap<IEnergySource, HashSet<IEnergySink>> todo = new LinkedHashMap<IEnergySource, HashSet<IEnergySink>>();
            for (ConnectingEntry connectingEntry : this.connectingTodo) {
                HashSet<IEnergySink> sinks = (HashSet<IEnergySink>)todo.get(connectingEntry.source);
                if (sinks == null) {
                    sinks = new HashSet<IEnergySink>();
                    todo.put(connectingEntry.source, sinks);
                }
                sinks.add(connectingEntry.sink);
            }
            this.connectingTodo = new LinkedHashSet<ConnectingEntry>();
            for (Map.Entry entry : todo.entrySet()) {
                source = (IEnergySource)entry.getKey();
                HashSet<IEnergyTile> targets = new HashSet<IEnergyTile>((Collection)entry.getValue());
                this.energySourceToEnergyPathMap.addSources(source, this.discoverTargets(source, targets, new HashSet<IEnergyConductor>(), false, this.getMaxEnergy(source)));
            }
        }
        if (this.sources.size() > 0) {
            for (Map.Entry<BlockPos, IEnergySource> entry : new LinkedHashMap<BlockPos, IEnergySource>(this.sources).entrySet()) {
                int offered;
                BlockPos blockPos = entry.getKey();
                source = entry.getValue();
                if (!this.sources.containsKey(blockPos) || source == null || (offered = DoubleMath.roundToInt((double)source.getOfferedEnergy(), (RoundingMode)RoundingMode.DOWN)) < 1) continue;
                if (source instanceof IMultiEnergySource && ((IMultiEnergySource)source).sendMultipleEnergyPackets()) {
                    int removed;
                    int maxPackets = ((IMultiEnergySource)source).getMultipleEnergyPacketAmount();
                    for (int i = 0; i < maxPackets && offered >= 1 && (removed = offered - this.emitEnergyFrom(blockPos, source, offered)) > 0; ++i) {
                        source.drawEnergy(removed);
                        offered = DoubleMath.roundToInt((double)source.getOfferedEnergy(), (RoundingMode)RoundingMode.DOWN);
                    }
                    continue;
                }
                int removed = offered - this.emitEnergyFrom(blockPos, source, offered);
                if (removed <= 0) continue;
                source.drawEnergy(removed);
            }
        }
    }

    int getMaxEnergy(IEnergySource source) {
        if (source instanceof IEnergySourceInfo) {
            return ((IEnergySourceInfo)source).getMaxSendingEnergy() - 1;
        }
        return (int)EnergyNet.instance.getPowerFromTier(source.getSourceTier()) - 1;
    }

    void removeConnectionCases(Collection<ConnectingEntry> list) {
        this.connectingTodo.removeAll(list);
    }

    public static BlockPos coords(IEnergyTile par1) {
        if (par1 instanceof TileEntity) {
            return ((TileEntity)par1).func_174877_v().func_185334_h();
        }
        if (par1 instanceof ILocatable) {
            return ((ILocatable)((Object)par1)).getPosition().func_185334_h();
        }
        throw new RuntimeException("Invalid EnergyNet Entity: " + par1);
    }

    int getSourceTier(IEnergySource source) {
        int tier = source.getSourceTier();
        if (tier > 13) {
            tier = 13;
        }
        return tier;
    }

    int getMaxEnergyInput(IEnergySink sink) {
        int tier = sink.getSinkTier();
        if (tier > 13) {
            TileEntity tile;
            tier = sink instanceof TileEntity ? ((tile = (TileEntity)sink).hasCapability(Ic2Capabilities.SinkLimiterCapability, null) ? ((SinkLimiterHandler)tile.getCapability(Ic2Capabilities.SinkLimiterCapability, null)).getTier() : 1) : 2;
        }
        return (int)EnergyNet.instance.getPowerFromTier(tier);
    }

    void update(BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos sidedPos = pos.func_177972_a(facing);
            if (!this.world.func_175667_e(sidedPos)) continue;
            this.world.func_190524_a(sidedPos, Blocks.field_150350_a, pos);
        }
        if (this.world.func_175667_e(pos)) {
            this.world.func_190524_a(pos, Blocks.field_150350_a, pos);
        }
    }

    void markGridDirty(EnergyNetGrid.GridID id) {
        this.dirtyGrids.add(id);
    }

    void markGridToSplit(EnergyNetGrid.GridID id) {
        this.splittingGrids.add(id);
    }

    void addWireToGrid(IEnergyTile tile, EnergyNetGrid.GridID id) {
        this.conductorGrids.put(tile, id);
    }

    boolean hasWiresLeft(IEnergyTile tile, EnergyNetGrid.GridID grid) {
        TargetList list = this.getTarget(tile);
        for (EnergyTarget target : list.getBoth()) {
            EnergyNetGrid.GridID id;
            IEnergyTile neighbor = target.targetTile;
            if (!(neighbor instanceof IEnergyConductor) || !grid.equals(id = this.conductorGrids.get(neighbor))) continue;
            return true;
        }
        return false;
    }

    public TargetList getTarget(IEnergyTile tile) {
        return this.connections.getOrDefault(tile, TargetList.nullList);
    }

    public void onUnload() {
        for (EnergyNetGrid grid : this.grids.values()) {
            grid.unload();
        }
        this.grids.clear();
        this.conductorGrids.clear();
        this.connectingTodo.clear();
        this.dirtyGrids.clear();
        this.registeredTiles.clear();
        this.sources.clear();
        this.energySourceToEnergyPathMap.clear();
        this.connections.clear();
    }

    EnergyNetPathMap.EnergyNetSubPathMap createSubList() {
        return this.energySourceToEnergyPathMap.createSubList();
    }

    public EnergyTileContainer getContainer(BlockPos pos) {
        return this.registeredTiles.get(pos);
    }

    public NodeStats getNodeStats(IEnergyTile tile) {
        int n;
        EnergyNetGrid.GridID id;
        double out = 0.0;
        double in = 0.0;
        HashMap<Object, Integer> tierStorage = new HashMap<Object, Integer>();
        if (tile instanceof IEnergySource) {
            IEnergySource source = (IEnergySource)tile;
            for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(source)) {
                out += (double)energyPath.totalEnergyConducted;
            }
            tierStorage.put(source, this.getSourceTier(source));
        }
        if (tile instanceof IEnergySink) {
            for (EnergyPath energyPath : this.energySourceToEnergyPathMap.getReverse((IEnergySink)tile)) {
                in += (double)energyPath.totalEnergyConducted;
                tierStorage.put(energyPath.emitter, this.getSourceTier(energyPath.emitter));
            }
        }
        if (tile instanceof IEnergyConductor && (id = this.conductorGrids.get(tile)) != null) {
            for (EnergyPath energyPath : this.grids.get(id).getPaths((IEnergyConductor)tile)) {
                in += (double)energyPath.totalEnergyConducted;
                out += (double)energyPath.totalEnergyConducted;
                tierStorage.put(energyPath.emitter, this.getSourceTier(energyPath.emitter));
            }
        }
        HashMap<Integer, IntCounter> map = new HashMap<Integer, IntCounter>();
        boolean bl = false;
        for (Integer currentTier : tierStorage.values()) {
            IntCounter counter = (IntCounter)map.get(currentTier);
            if (counter == null) {
                counter = new IntCounter(0);
                map.put(currentTier, counter);
            }
            counter.increase();
            if (currentTier <= n) continue;
            n = currentTier;
        }
        double d = n;
        for (Map.Entry entry : map.entrySet()) {
            IntCounter counter = (IntCounter)entry.getValue();
            d += (double)counter.getValue() / Math.pow(4.0, n + 1 - (Integer)entry.getKey());
        }
        return new NodeStats(in, out, EnergyNet.instance.getPowerFromTier((int)d));
    }

    public List<PacketStat> getPackets(IEnergyTile tile, IPacketEnergyNet.PacketType type) {
        EnergyNetGrid.GridID id;
        boolean receiving;
        LinkedHashMap<Integer, LongCounter> out = new LinkedHashMap<Integer, LongCounter>();
        LinkedHashMap<Integer, LongCounter> in = new LinkedHashMap<Integer, LongCounter>();
        boolean sending = type == IPacketEnergyNet.PacketType.Sended || type == IPacketEnergyNet.PacketType.Both;
        boolean bl = receiving = type == IPacketEnergyNet.PacketType.Received || type == IPacketEnergyNet.PacketType.Both;
        if (sending && tile instanceof IEnergySource) {
            for (EnergyPath path : this.energySourceToEnergyPathMap.get((IEnergySource)tile)) {
                if (path.mesuredEnergyPackets.isEmpty() && path.backupEnergyPackets.isEmpty()) {
                    path.backupEnergyPackets.putAll(path.mesuredEnergyPackets);
                    path.mesuredEnergyPackets = new LinkedHashMap<Integer, LongCounter>();
                }
                this.addPackets(out, path.backupEnergyPackets);
            }
        }
        if (receiving && tile instanceof IEnergySink) {
            for (EnergyPath path : this.energySourceToEnergyPathMap.getReverse((IEnergySink)tile)) {
                if (path.mesuredEnergyPackets.isEmpty() && path.backupEnergyPackets.isEmpty()) {
                    path.backupEnergyPackets.putAll(path.mesuredEnergyPackets);
                    path.mesuredEnergyPackets = new LinkedHashMap<Integer, LongCounter>();
                }
                this.addPackets(in, path.backupEnergyPackets);
            }
        }
        if (tile instanceof IEnergyConductor && (id = this.conductorGrids.get(tile)) != null) {
            for (EnergyPath path : this.grids.get(id).getPaths((IEnergyConductor)tile)) {
                if (path.mesuredEnergyPackets.isEmpty() && path.backupEnergyPackets.isEmpty()) {
                    path.backupEnergyPackets.putAll(path.mesuredEnergyPackets);
                    path.mesuredEnergyPackets = new LinkedHashMap<Integer, LongCounter>();
                }
                if (sending) {
                    this.addPackets(out, path.backupEnergyPackets);
                }
                if (!receiving) continue;
                this.addPackets(in, path.backupEnergyPackets);
            }
        }
        ArrayList<PacketStat> result = new ArrayList<PacketStat>();
        if (sending) {
            for (Map.Entry entry : out.entrySet()) {
                result.add(new PacketStat(true, (Integer)entry.getKey(), ((LongCounter)entry.getValue()).getValue()));
            }
        }
        if (receiving) {
            for (Map.Entry entry : in.entrySet()) {
                result.add(new PacketStat(false, (Integer)entry.getKey(), ((LongCounter)entry.getValue()).getValue()));
            }
        }
        return result;
    }

    public List<PacketStat> getTotalPackets(IEnergyTile tile, IPacketEnergyNet.PacketType type) {
        EnergyNetGrid.GridID id;
        boolean receiving;
        LinkedHashMap<Integer, LongCounter> out = new LinkedHashMap<Integer, LongCounter>();
        LinkedHashMap<Integer, LongCounter> in = new LinkedHashMap<Integer, LongCounter>();
        boolean sending = type == IPacketEnergyNet.PacketType.Sended || type == IPacketEnergyNet.PacketType.Both;
        boolean bl = receiving = type == IPacketEnergyNet.PacketType.Received || type == IPacketEnergyNet.PacketType.Both;
        if (sending && tile instanceof IEnergySource) {
            for (EnergyPath path : this.energySourceToEnergyPathMap.get((IEnergySource)tile)) {
                this.addPackets(out, path.totalEnergyPackets);
            }
        }
        if (receiving && tile instanceof IEnergySink) {
            for (EnergyPath path : this.energySourceToEnergyPathMap.getReverse((IEnergySink)tile)) {
                this.addPackets(in, path.totalEnergyPackets);
            }
        }
        if (tile instanceof IEnergyConductor && (id = this.conductorGrids.get(tile)) != null) {
            for (EnergyPath path : this.grids.get(id).getPaths((IEnergyConductor)tile)) {
                if (sending) {
                    this.addPackets(out, path.totalEnergyPackets);
                }
                if (!receiving) continue;
                this.addPackets(in, path.totalEnergyPackets);
            }
        }
        ArrayList<PacketStat> result = new ArrayList<PacketStat>();
        if (sending) {
            for (Map.Entry entry : out.entrySet()) {
                result.add(new PacketStat(true, (Integer)entry.getKey(), ((LongCounter)entry.getValue()).getValue()));
            }
        }
        if (receiving) {
            for (Map.Entry entry : in.entrySet()) {
                result.add(new PacketStat(false, (Integer)entry.getKey(), ((LongCounter)entry.getValue()).getValue()));
            }
        }
        return result;
    }

    public IEnergyTile getNeighbor(IEnergyTile tile, Direction dir) {
        return this.getContainer((BlockPos)EnergyNetLocal.coords((IEnergyTile)tile).func_177972_a((EnumFacing)dir.toFacing())).tile;
    }

    public EnergyTileContainer getNeighborContainer(IEnergyTile tile, Direction dir) {
        return this.getContainer(EnergyNetLocal.coords(tile).func_177972_a(dir.toFacing()));
    }

    public void addTile(IEnergyTile tile) {
        if (!(tile instanceof IEnergySource || tile instanceof IEnergySink || tile instanceof IEnergyConductor)) {
            return;
        }
        if (tile instanceof IMetaDelegate) {
            this.addMetaTileEntity((IMetaDelegate)tile);
        } else {
            this.addTileEntity(tile);
        }
    }

    public void removeTile(IEnergyTile tile) {
        if (tile instanceof IMetaDelegate) {
            this.removeMetaTileEntity((IMetaDelegate)tile);
        } else {
            this.removeTileEntity(tile);
        }
    }

    public void addMetaTileEntity(IMetaDelegate tile) {
        List<IEnergyTile> subTiles = tile.getSubTiles();
        for (IEnergyTile subTile : subTiles) {
            BlockPos pos = EnergyNetLocal.coords(subTile);
            if (this.registeredTiles.containsKey(pos)) continue;
            this.registeredTiles.put(pos, new EnergyTileContainer(subTile, tile));
            this.update(pos);
        }
        this.addToGrids(tile);
        if (tile instanceof IEnergySource) {
            this.sources.put(EnergyNetLocal.coords(subTiles.get(0)), (IEnergySource)((Object)tile));
        }
    }

    public void addTileEntity(IEnergyTile tile) {
        BlockPos pos = EnergyNetLocal.coords(tile);
        if (this.registeredTiles.containsKey(pos)) {
            return;
        }
        this.registeredTiles.put(pos, new EnergyTileContainer(tile));
        this.update(pos);
        this.addToGrids(tile);
        if (tile instanceof IEnergySource) {
            this.sources.put(pos, (IEnergySource)tile);
        }
    }

    public void removeMetaTileEntity(IMetaDelegate tile) {
        List<IEnergyTile> subTiles = tile.getSubTiles();
        for (IEnergyTile subTile : subTiles) {
            BlockPos pos = EnergyNetLocal.coords(subTile);
            if (!this.registeredTiles.containsKey(pos)) continue;
            this.registeredTiles.remove(pos);
            this.update(pos);
            if (!(tile instanceof IEnergySource)) continue;
            this.sources.remove(pos);
        }
        this.removeFromGrids(tile);
    }

    public void removeTileEntity(IEnergyTile tile) {
        BlockPos pos = EnergyNetLocal.coords(tile);
        if (!this.registeredTiles.containsKey(pos)) {
            return;
        }
        EnergyTileContainer cont = this.registeredTiles.remove(pos);
        this.update(pos);
        this.removeFromGrids(cont.tile);
        if (tile instanceof IEnergySource) {
            this.sources.remove(pos);
        }
    }

    private void removeFromGrids(IEnergyTile tile) {
        TargetList targets = this.connections.remove(tile);
        targets.destory(this);
        boolean conductor = tile instanceof IEnergyConductor;
        boolean sink = tile instanceof IEnergySink;
        boolean source = tile instanceof IEnergySource;
        if (conductor) {
            IEnergyTile target;
            EnergyNetGrid.GridID id = this.conductorGrids.remove(tile);
            EnergyNetGrid grid = this.grids.get(id);
            if (source) {
                IEnergySource iSource = (IEnergySource)tile;
                grid.removeSource(iSource);
                this.energySourceToEnergyPathMap.removeSource(iSource);
            }
            if (sink) {
                IEnergySink iSink = (IEnergySink)tile;
                grid.removeSink(iSink);
                this.energySourceToEnergyPathMap.removeSink(iSink);
            }
            HashSet<IEnergyConductor> wires = new HashSet<IEnergyConductor>();
            for (EnergyTarget entry : targets.getEmitters()) {
                target = entry.targetTile;
                if (target instanceof IEnergyConductor) {
                    wires.add((IEnergyConductor)target);
                }
                if (!(target instanceof IEnergySink) || this.hasWiresLeft(target, id)) continue;
                grid.removeSink((IEnergySink)target);
            }
            for (EnergyTarget entry : targets.getReceivers()) {
                target = entry.targetTile;
                if (target instanceof IEnergyConductor) {
                    wires.add((IEnergyConductor)target);
                }
                if (!(target instanceof IEnergySource) || this.hasWiresLeft(target, id)) continue;
                grid.removeSource((IEnergySource)target);
            }
            if (wires.size() == 0) {
                grid.removeConductor((IEnergyConductor)tile);
                if (!grid.hasConductors()) {
                    this.grids.remove(id);
                }
            } else if (wires.size() == 1) {
                grid.removeConductor((IEnergyConductor)tile);
            } else {
                grid.removeConductor((IEnergyConductor)tile);
                grid.markForSplit();
            }
        } else {
            IEnergyTile target;
            if (source) {
                for (EnergyTarget entry : targets.getEmitters()) {
                    target = entry.targetTile;
                    if (!(target instanceof IEnergyConductor)) continue;
                    this.grids.get(this.conductorGrids.get(target)).removeSource((IEnergySource)tile);
                }
                this.energySourceToEnergyPathMap.removeSource((IEnergySource)tile);
            }
            if (sink) {
                for (EnergyTarget entry : targets.getReceivers()) {
                    target = entry.targetTile;
                    if (!(target instanceof IEnergyConductor)) continue;
                    this.grids.get(this.conductorGrids.get(target)).removeSink((IEnergySink)tile);
                }
                this.energySourceToEnergyPathMap.removeSink((IEnergySink)tile);
            }
        }
        targets.clear();
    }

    private void addToGrids(IEnergyTile tile) {
        block34: {
            IEnergyTile targetTile;
            boolean source;
            boolean sink;
            TargetList targets;
            block33: {
                targets = new TargetList(tile, this);
                this.connections.put(tile, targets);
                boolean conductor = tile instanceof IEnergyConductor;
                sink = tile instanceof IEnergySink;
                source = tile instanceof IEnergySource;
                if (!conductor) break block33;
                IEnergyConductor wire = (IEnergyConductor)tile;
                if (targets.hasNoTargets()) {
                    EnergyNetGrid grid = new EnergyNetGrid(EnergyNetGrid.GridID.createNewID(), this);
                    grid.addConductor((IEnergyConductor)tile);
                    if (sink) {
                        grid.addSinks((IEnergySink)tile);
                    }
                    if (source) {
                        grid.addSource((IEnergySource)tile);
                    }
                    this.grids.put(grid.getGridID(), grid);
                } else {
                    EnergyNetGrid grid;
                    IEnergyTile target;
                    LinkedHashMap<EnergyNetGrid.GridID, IntCounter> gridsToCombine = new LinkedHashMap<EnergyNetGrid.GridID, IntCounter>();
                    LinkedList<IEnergySource> receiving = new LinkedList<IEnergySource>();
                    LinkedList<IEnergySink> emitting = new LinkedList<IEnergySink>();
                    HashSet<IEnergyConductor> wires = new HashSet<IEnergyConductor>();
                    for (EnergyTarget emitters : targets.getEmitters()) {
                        target = emitters.targetTile;
                        if (target instanceof IEnergyConductor) {
                            wires.add((IEnergyConductor)target);
                            EnergyNetGrid.GridID id = this.conductorGrids.get(target);
                            IntCounter counter = (IntCounter)gridsToCombine.get(id);
                            if (counter == null) {
                                counter = new IntCounter();
                                gridsToCombine.put(id, counter);
                            }
                            counter.increase();
                        }
                        if (!(target instanceof IEnergySink)) continue;
                        emitting.add((IEnergySink)target);
                    }
                    for (EnergyTarget receivers : targets.getReceivers()) {
                        IEnergyConductor cable;
                        target = receivers.targetTile;
                        if (target instanceof IEnergyConductor && wires.add(cable = (IEnergyConductor)target)) {
                            EnergyNetGrid.GridID id = this.conductorGrids.get(target);
                            IntCounter counter = (IntCounter)gridsToCombine.get(id);
                            if (counter == null) {
                                counter = new IntCounter();
                                gridsToCombine.put(id, counter);
                            }
                            counter.increase();
                        }
                        if (!(target instanceof IEnergySource)) continue;
                        receiving.add((IEnergySource)target);
                    }
                    if (gridsToCombine.size() == 1) {
                        grid = this.grids.get(gridsToCombine.keySet().iterator().next());
                        grid.addConductor(wire);
                        if (sink) {
                            grid.addSinks((IEnergySink)tile);
                        }
                        if (source) {
                            grid.addSource((IEnergySource)tile);
                        }
                        for (IEnergySource sources : receiving) {
                            grid.addSource(sources);
                        }
                        for (IEnergySink sinks : emitting) {
                            grid.addSinks(sinks);
                        }
                    } else if (gridsToCombine.size() > 1) {
                        grid = new EnergyNetGrid(EnergyNetGrid.GridID.createNewID(), this);
                        for (Map.Entry entry : gridsToCombine.entrySet()) {
                            EnergyNetGrid oldGrid = this.grids.remove(entry.getKey());
                            if (((IntCounter)entry.getValue()).getValue() > 1) {
                                grid.addGrid(oldGrid);
                                continue;
                            }
                            grid.addGridWithPaths(oldGrid);
                        }
                        grid.addConductor(wire);
                        if (sink) {
                            grid.addSinks((IEnergySink)tile);
                        }
                        if (source) {
                            grid.addSource((IEnergySource)tile);
                        }
                        for (IEnergySource sources : receiving) {
                            grid.addSource(sources);
                        }
                        for (IEnergySink sinks : emitting) {
                            grid.addSinks(sinks);
                        }
                        grid.finishCombining();
                        this.grids.put(grid.getGridID(), grid);
                    } else {
                        grid = new EnergyNetGrid(EnergyNetGrid.GridID.createNewID(), this);
                        grid.addConductor((IEnergyConductor)tile);
                        if (sink) {
                            grid.addSinks((IEnergySink)tile);
                        }
                        if (source) {
                            grid.addSource((IEnergySource)tile);
                        }
                        this.grids.put(grid.getGridID(), grid);
                        for (IEnergySource sources : receiving) {
                            grid.addSource(sources);
                        }
                        for (IEnergySink sinks : emitting) {
                            grid.addSinks(sinks);
                        }
                    }
                }
                break block34;
            }
            if (source) {
                IEnergySource sourceTile = (IEnergySource)tile;
                for (EnergyTarget target : targets.getEmitters()) {
                    targetTile = target.targetTile;
                    if (targetTile instanceof IEnergyConductor) {
                        this.grids.get(this.conductorGrids.get(targetTile)).addSource(sourceTile);
                    }
                    if (!(targetTile instanceof IEnergySink)) continue;
                    this.connectingTodo.add(new ConnectingEntry(sourceTile, (IEnergySink)targetTile));
                }
            }
            if (!sink) break block34;
            IEnergySink sinkTile = (IEnergySink)tile;
            for (EnergyTarget target : targets.getReceivers()) {
                targetTile = target.targetTile;
                if (targetTile instanceof IEnergyConductor) {
                    this.grids.get(this.conductorGrids.get(targetTile)).addSinks(sinkTile);
                }
                if (!(targetTile instanceof IEnergySource)) continue;
                this.connectingTodo.add(new ConnectingEntry((IEnergySource)targetTile, sinkTile));
            }
        }
    }

    void splitGrid(EnergyNetGrid grid) {
        this.grids.remove(grid.getGridID());
        ArrayList<EnergyNetGrid> gridsToAdd = new ArrayList<EnergyNetGrid>();
        EnergyNetGrid newGrid = new EnergyNetGrid(EnergyNetGrid.GridID.createNewID(), this);
        newGrid.setIsSplitted();
        gridsToAdd.add(newGrid);
        LinkedHashSet<IEnergyConductor> notConnecting = new LinkedHashSet<IEnergyConductor>(grid.cables);
        FilteredList alreadyAdded = new FilteredList();
        LinkedList<IEnergyConductor> work = new LinkedList<IEnergyConductor>();
        HashSet<IEnergyTile> processedTiles = new HashSet<IEnergyTile>();
        IEnergyConductor newWork = grid.cables.iterator().next();
        work.add(newWork);
        alreadyAdded.add(newWork);
        processedTiles.add(newWork);
        while (work.size() > 0) {
            IEnergyTile tile;
            IEnergyConductor cable = (IEnergyConductor)work.remove();
            if (!this.registeredTiles.containsKey(EnergyNetLocal.coords(cable))) continue;
            newGrid.addConductor(cable);
            TargetList targets = this.getTarget(cable);
            for (EnergyTarget entry : targets.getEmitters()) {
                tile = entry.targetTile;
                if (processedTiles.contains(tile)) continue;
                processedTiles.add(tile);
                if (tile instanceof IEnergyConductor && !alreadyAdded.contains(tile)) {
                    work.add((IEnergyConductor)tile);
                    alreadyAdded.add((IEnergyConductor)tile);
                }
                if (!(tile instanceof IEnergySink)) continue;
                newGrid.addSinks((IEnergySink)tile);
            }
            for (EnergyTarget entry : targets.getReceivers()) {
                tile = entry.targetTile;
                if (processedTiles.contains(tile)) continue;
                processedTiles.add(tile);
                if (tile instanceof IEnergyConductor && !alreadyAdded.contains(tile)) {
                    work.add((IEnergyConductor)tile);
                    alreadyAdded.add((IEnergyConductor)tile);
                }
                if (!(tile instanceof IEnergySource)) continue;
                newGrid.addSource((IEnergySource)tile);
            }
        }
        notConnecting.removeAll(alreadyAdded);
        alreadyAdded = new FilteredList();
        newGrid.pathMap.copyPaths(grid.pathMap.getPaths(newGrid.sources, newGrid.sinks));
        newGrid.processSplit();
        if (notConnecting.size() > 0) {
            while (notConnecting.size() > 0) {
                IEnergyConductor iter = (IEnergyConductor)notConnecting.iterator().next();
                notConnecting.remove(iter);
                work.add(iter);
                alreadyAdded.add(iter);
                newGrid = new EnergyNetGrid(EnergyNetGrid.GridID.createNewID(), this);
                newGrid.setIsSplitted();
                gridsToAdd.add(newGrid);
                while (work.size() > 0) {
                    IEnergyTile tile;
                    IEnergyConductor cable = (IEnergyConductor)work.remove();
                    if (!this.registeredTiles.containsKey(EnergyNetLocal.coords(cable))) continue;
                    newGrid.addConductor(cable);
                    TargetList targets = this.getTarget(cable);
                    for (EnergyTarget entry : targets.getEmitters()) {
                        tile = entry.targetTile;
                        if (tile instanceof IEnergyConductor && !alreadyAdded.contains(tile)) {
                            work.add((IEnergyConductor)tile);
                            alreadyAdded.add((IEnergyConductor)tile);
                        }
                        if (!(tile instanceof IEnergySink)) continue;
                        newGrid.addSinks((IEnergySink)tile);
                    }
                    for (EnergyTarget entry : targets.getReceivers()) {
                        tile = entry.targetTile;
                        if (processedTiles.contains(tile)) continue;
                        processedTiles.add(tile);
                        if (tile instanceof IEnergyConductor && !alreadyAdded.contains(tile)) {
                            work.add((IEnergyConductor)tile);
                            alreadyAdded.add((IEnergyConductor)tile);
                        }
                        if (!(tile instanceof IEnergySource)) continue;
                        newGrid.addSource((IEnergySource)tile);
                    }
                }
                notConnecting.removeAll(alreadyAdded);
                alreadyAdded = new FilteredList();
            }
        }
        for (EnergyNetGrid toAdd : gridsToAdd) {
            this.grids.put(toAdd.getGridID(), toAdd);
            toAdd.pathMap.copyPaths(grid.pathMap.getPaths(toAdd.sources, toAdd.sinks));
            toAdd.processSplit();
        }
        grid.pathMap.clear();
    }

    void explodeTiles(IEnergyTile tile) {
        this.removeTile(tile);
        FilteredList posList = new FilteredList();
        if (tile instanceof IMetaDelegate) {
            for (IEnergyTile subTile : ((IMetaDelegate)tile).getSubTiles()) {
                posList.add(EnergyNetLocal.coords(subTile));
            }
        } else {
            posList.add(EnergyNetLocal.coords(tile));
        }
        for (BlockPos pos : posList) {
            this.world.func_175698_g(pos);
            if (!burn || !(this.world.field_73012_v.nextFloat() < chance)) continue;
            this.world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
        }
        Vec3d adding = new Vec3d(0.5, 0.5, 0.5);
        for (BlockPos pos : posList) {
            ExplosionIC2 explosion = new ExplosionIC2(this.world, null, new Vec3d((Vec3i)pos).func_178787_e(adding), 2.5f, 0.75f, 0.75f, null);
            explosion.doExplosion();
        }
    }

    public EnergyNetGrid.GridID getGridID(IEnergyConductor conductor) {
        return this.conductorGrids.get(conductor);
    }

    public void addPacket(EnergyPath path, int energy) {
        LongCounter totalPackets;
        if (path.backupEnergyPackets.size() > 0) {
            path.backupEnergyPackets = new LinkedHashMap<Integer, LongCounter>();
        }
        if ((totalPackets = path.totalEnergyPackets.get(energy)) == null) {
            totalPackets = new LongCounter();
            path.totalEnergyPackets.put(energy, totalPackets);
        }
        totalPackets.increase();
        LongCounter mesurePackets = path.mesuredEnergyPackets.get(energy);
        if (mesurePackets == null) {
            mesurePackets = new LongCounter();
            path.mesuredEnergyPackets.put(energy, mesurePackets);
        }
        mesurePackets.increase();
    }

    private void addPackets(Map<Integer, LongCounter> input, Map<Integer, LongCounter> output) {
        for (Map.Entry<Integer, LongCounter> entry : output.entrySet()) {
            int key = entry.getKey();
            LongCounter counter = input.get(key);
            if (counter == null) {
                counter = new LongCounter();
                input.put(key, counter);
            }
            counter.increase(entry.getValue().getValue());
        }
    }

    public static void setBurn(float value) {
        burn = value > 0.0f;
        chance = value;
    }

    public Set<IEnergySource> getSourcesFromArea(AabbUtil.BoundingBox box) {
        HashSet<IEnergySource> source = new HashSet<IEnergySource>();
        for (EnergyPath path : this.energySourceToEnergyPathMap.getAllPaths()) {
            if (!box.boxColides(path.getBox())) continue;
            source.add(path.emitter);
        }
        return source;
    }

    public Set<IEnergySink> getSinksFromArea(AabbUtil.BoundingBox box) {
        HashSet<IEnergySink> sinks = new HashSet<IEnergySink>();
        for (EnergyPath path : this.energySourceToEnergyPathMap.getAllPaths()) {
            if (!box.boxColides(path.getBox())) continue;
            sinks.add(path.target);
        }
        return sinks;
    }

    public Set<IEnergySource> getSourcesFromPosition(BlockPos pos) {
        EnergyNetGrid grid;
        EnergyNetGrid.GridID id;
        EnergyTileContainer cont = this.getContainer(pos);
        if (cont == null) {
            return new LinkedHashSet<IEnergySource>();
        }
        IEnergyTile tile = cont.tile;
        LinkedHashSet<IEnergySource> set = new LinkedHashSet<IEnergySource>();
        if (tile instanceof IEnergySource) {
            set.add((IEnergySource)tile);
        }
        if (tile instanceof IEnergySink) {
            for (EnergyPath path : this.energySourceToEnergyPathMap.getReverse((IEnergySink)tile)) {
                set.add(path.emitter);
            }
        }
        if (tile instanceof IEnergyConductor && (id = this.getGridID((IEnergyConductor)tile)) != null && (grid = this.grids.get(id)) != null) {
            set.addAll(grid.getSources());
        }
        return set;
    }

    public Set<IEnergySink> getSinksFromPosition(BlockPos pos) {
        EnergyNetGrid grid;
        EnergyNetGrid.GridID id;
        EnergyTileContainer cont = this.getContainer(pos);
        if (cont == null) {
            return new LinkedHashSet<IEnergySink>();
        }
        IEnergyTile tile = cont.tile;
        LinkedHashSet<IEnergySink> set = new LinkedHashSet<IEnergySink>();
        if (tile instanceof IEnergySource) {
            for (EnergyPath path : this.energySourceToEnergyPathMap.get((IEnergySource)tile)) {
                set.add(path.target);
            }
        }
        if (tile instanceof IEnergySink) {
            set.add((IEnergySink)tile);
        }
        if (tile instanceof IEnergyConductor && (id = this.getGridID((IEnergyConductor)tile)) != null && (grid = this.grids.get(id)) != null) {
            set.addAll(grid.getSinks());
        }
        return set;
    }

    public int getPathCount(IEnergySource source) {
        return this.energySourceToEnergyPathMap.get(source).size();
    }

    public int getPathCount(IEnergySink sink) {
        return this.energySourceToEnergyPathMap.getReverse(sink).size();
    }

    public Tuple<BlockPos, Tuple<Map<BlockPos, List<BlockPos>>, Map<BlockPos, Double>>> getData(IEnergySource source) {
        HashMap nextData = new HashMap();
        HashMap<BlockPos, Double> positionLoss = new HashMap<BlockPos, Double>();
        for (EnergyPath path : this.energySourceToEnergyPathMap.get(source)) {
            int i = 0;
            while (i + 1 < path.pathSteps.size()) {
                BlockPos cuPos = path.pathSteps.get(i);
                FilteredList posList = (FilteredList)nextData.get(cuPos);
                if (posList == null) {
                    posList = new FilteredList();
                    nextData.put(cuPos, posList);
                }
                posList.add(path.pathSteps.get(i + 1));
                EnergyTileContainer container = this.getContainer(cuPos);
                if (container == null) {
                    positionLoss.put(cuPos, 0.0);
                } else {
                    IEnergyTile tile = container.tile;
                    if (!(tile instanceof IEnergyConductor)) {
                        positionLoss.put(cuPos, 0.0);
                    } else {
                        IEnergyConductor wire = (IEnergyConductor)tile;
                        double loss = wire.getConductionLoss();
                        if (loss < 1.0E-4) {
                            loss = 1.0E-4;
                        }
                        positionLoss.put(cuPos, loss);
                    }
                }
                ++i;
            }
        }
        return new Tuple((Object)EnergyNetLocal.coords(source), (Object)new Tuple(nextData, positionLoss));
    }

    public Tuple<BlockPos, Tuple<Map<BlockPos, List<BlockPos>>, Map<BlockPos, Double>>> getData(IEnergySink sink) {
        HashMap nextData = new HashMap();
        HashMap<BlockPos, Double> positionLoss = new HashMap<BlockPos, Double>();
        for (EnergyPath path : this.energySourceToEnergyPathMap.getReverse(sink)) {
            ArrayList<BlockPos> steps = new ArrayList<BlockPos>(path.pathSteps);
            Collections.reverse(steps);
            int i = 0;
            while (i + 1 < steps.size()) {
                BlockPos cuPos = (BlockPos)steps.get(i);
                FilteredList posList = (FilteredList)nextData.get(cuPos);
                if (posList == null) {
                    posList = new FilteredList();
                    nextData.put(cuPos, posList);
                }
                posList.add(steps.get(i + 1));
                EnergyTileContainer container = this.getContainer(cuPos);
                if (container == null) {
                    positionLoss.put(cuPos, 0.0);
                } else {
                    IEnergyTile tile = container.tile;
                    if (!(tile instanceof IEnergyConductor)) {
                        positionLoss.put(cuPos, 0.0);
                    } else {
                        IEnergyConductor wire = (IEnergyConductor)tile;
                        double loss = wire.getConductionLoss();
                        if (loss < 1.0E-4) {
                            loss = 1.0E-4;
                        }
                        positionLoss.put(cuPos, loss);
                    }
                }
                ++i;
            }
        }
        return new Tuple((Object)EnergyNetLocal.coords(sink), (Object)new Tuple(nextData, positionLoss));
    }

    static class ConnectingEntry {
        IEnergySource source;
        IEnergySink sink;

        public ConnectingEntry(IEnergySource par1, IEnergySink par2) {
            this.source = par1;
            this.sink = par2;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConnectingEntry) {
                ConnectingEntry entry = (ConnectingEntry)obj;
                return Objects.equal((Object)this.source, (Object)entry.source) && Objects.equal((Object)this.sink, (Object)entry.sink);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.source, this.sink});
        }
    }

    static class EnergyTileContainer {
        public IEnergyTile tile;
        public IEnergyTile subTile;

        public EnergyTileContainer(IEnergyTile mainTile) {
            this(mainTile, mainTile);
        }

        public EnergyTileContainer(IEnergyTile subTile, IEnergyTile mainTile) {
            this.tile = mainTile;
            this.subTile = subTile;
        }

        public BlockPos getPos() {
            return EnergyNetLocal.coords(this.subTile);
        }
    }

    static class EnergyPath {
        IEnergySink target = null;
        Direction targetdirection = null;
        IEnergySource emitter = null;
        Direction emitterDirection = null;
        List<IEnergyConductor> conductors = new FilteredList<IEnergyConductor>();
        HashMap<Integer, LongCounter> totalEnergyPackets = new LinkedHashMap<Integer, LongCounter>();
        HashMap<Integer, LongCounter> mesuredEnergyPackets = new LinkedHashMap<Integer, LongCounter>();
        HashMap<Integer, LongCounter> backupEnergyPackets = new LinkedHashMap<Integer, LongCounter>();
        List<BlockPos> pathSteps = new FilteredList<BlockPos>();
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int minInsulationEnergyAbsorption = Integer.MAX_VALUE;
        int minInsulationBreakdownEnergy = Integer.MAX_VALUE;
        int minConductorBreakdownEnergy = Integer.MAX_VALUE;
        long totalEnergyConducted = 0L;
        double loss = 0.0;
        private int hashCode = -1;

        EnergyPath() {
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = Objects.hashCode((Object[])new Object[]{this.target, this.emitter});
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof EnergyPath) {
                EnergyPath path = (EnergyPath)obj;
                if (Objects.equal((Object)this.target, (Object)path.target) && Objects.equal((Object)this.emitter, (Object)path.emitter)) {
                    return true;
                }
            }
            return false;
        }

        public AabbUtil.BoundingBox getBox() {
            return new AabbUtil.BoundingBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }

        public String toString() {
            return "EnergyPath. Emitter[" + this.emitter + ", " + this.targetdirection.toFacing() + "], Receiver: [" + this.target + ", " + this.targetdirection.toFacing() + "], Loss: " + this.loss;
        }
    }

    static class EnergyBlockLink {
        IEnergyTile next;
        BlockPos nextPos;
        IEnergyTile targetTile;
        BlockPos targetPos;
        Direction direction;
        double loss;

        EnergyBlockLink(EnergyTarget target, double loss) {
            this.next = target.myTile;
            this.nextPos = target.myPos;
            this.targetTile = target.targetTile;
            this.targetPos = target.targetPos;
            this.direction = target.targetDirection;
            this.loss = loss;
        }
    }

    static class TargetList {
        public static final TargetList nullList = new TargetList();
        IEnergyTile owner;
        List<EnergyTarget> emitters = new FilteredList<EnergyTarget>();
        List<EnergyTarget> receivers = new FilteredList<EnergyTarget>();
        List<EnergyTarget> allTargets = new FilteredList<EnergyTarget>();

        private TargetList() {
        }

        public TargetList(IEnergyTile tile, EnergyNetLocal local) {
            EnergyTarget inverted;
            TargetList list;
            this.owner = tile;
            for (EnergyTarget target : local.getValidReceivers(tile, false)) {
                this.emitters.add(target);
                this.allTargets.add(target);
                list = local.getTarget(target.targetTile);
                if (list == nullList) continue;
                inverted = target.invert();
                list.receivers.add(inverted);
                list.allTargets.add(inverted);
            }
            for (EnergyTarget target : local.getValidReceivers(tile, true)) {
                this.receivers.add(target);
                this.allTargets.add(target);
                list = local.getTarget(target.targetTile);
                if (list == nullList) continue;
                inverted = target.invert();
                list.emitters.add(inverted);
                list.allTargets.add(inverted);
            }
        }

        public void destory(EnergyNetLocal local) {
            EnergyTarget inverted;
            TargetList list;
            for (EnergyTarget target : this.emitters) {
                list = local.getTarget(target.targetTile);
                if (list == nullList) continue;
                inverted = target.invert();
                list.receivers.remove(inverted);
                list.allTargets.remove(inverted);
            }
            for (EnergyTarget target : this.receivers) {
                list = local.getTarget(target.targetTile);
                if (list == nullList) continue;
                inverted = target.invert();
                list.emitters.remove(inverted);
                list.allTargets.remove(inverted);
            }
        }

        public void clear() {
            this.emitters.clear();
            this.receivers.clear();
            this.allTargets.clear();
        }

        public List<EnergyTarget> get(boolean reverse) {
            if (reverse) {
                return this.receivers;
            }
            return this.emitters;
        }

        public List<EnergyTarget> getEmitters() {
            return this.emitters;
        }

        public List<EnergyTarget> getReceivers() {
            return this.receivers;
        }

        public List<EnergyTarget> getBoth() {
            return this.allTargets;
        }

        public boolean hasEmitters() {
            return this.receivers.size() > 0;
        }

        public boolean hasReceivers() {
            return this.emitters.size() > 0;
        }

        public boolean hasTargets() {
            return this.allTargets.size() > 0;
        }

        public boolean hasNoTargets() {
            return this.allTargets.isEmpty();
        }
    }

    static class EnergyTarget {
        IEnergyTile targetTile;
        BlockPos targetPos;
        Direction targetDirection;
        IEnergyTile myTile;
        BlockPos myPos;
        int hashCode;

        EnergyTarget(IEnergyTile par1, BlockPos par2, Direction par3, IEnergyTile par4, BlockPos par5) {
            this.targetTile = par1;
            this.targetPos = par2;
            this.targetDirection = par3;
            this.myTile = par4;
            this.myPos = par5;
            this.hashCode = Objects.hashCode((Object[])new Object[]{this.targetDirection, this.targetTile});
        }

        public boolean equals(Object obj) {
            if (obj instanceof EnergyTarget) {
                EnergyTarget target = (EnergyTarget)obj;
                return Objects.equal((Object)((Object)this.targetDirection), (Object)((Object)target.targetDirection)) && Objects.equal((Object)this.targetTile, (Object)target.targetTile);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return "EnergyTarget, Pos: " + this.targetPos + ", Dir: " + (Object)((Object)this.targetDirection) + ", Tile: " + this.targetTile;
        }

        public EnergyTarget invert() {
            return new EnergyTarget(this.myTile, this.myPos, this.targetDirection.getInverse(), this.targetTile, this.targetPos);
        }
    }
}

