/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor.base;

import ic2.api.classic.reactor.IReactorPlannerComponent;
import ic2.api.classic.reactor.ISteamReactor;
import ic2.api.reactor.IReactor;
import ic2.core.fluid.IC2Fluid;
import ic2.core.item.reactor.ItemReactorHeatStorageBase;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public abstract class ItemHeatVentBase
extends ItemReactorHeatStorageBase {
    @Override
    public int getTextureEntry(int meta) {
        VentProperty prop = this.getProperty(meta);
        if (prop != null) {
            return prop.getIconPlace();
        }
        return 0;
    }

    @Override
    public String getSheet(int meta) {
        VentProperty prop = this.getProperty(meta);
        if (prop != null) {
            return prop.getSprite();
        }
        return "i3";
    }

    public abstract VentProperty getProperty(ItemStack var1);

    public abstract VentProperty getProperty(int var1);

    @Override
    public int getMaxCustomDamage(ItemStack stack) {
        VentProperty prop = this.getProperty(stack);
        if (prop != null) {
            return prop.getMaxHeat();
        }
        return super.getMaxCustomDamage(stack);
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        VentProperty prop = this.getProperty(stack);
        if (prop != null) {
            return prop.getName();
        }
        return super.getLangComponent(stack);
    }

    @Override
    public void processChamber(ItemStack stack, IReactor reactor, int x, int y, boolean heatrun) {
        if (heatrun) {
            boolean electric;
            VentProperty prop = this.getProperty(stack);
            if (prop == null) {
                return;
            }
            boolean producing = reactor.produceEnergy();
            boolean bl = electric = prop.getType() == 2;
            int reactorVent = electric ? (producing ? prop.getReactor() : prop.getReactor() / 2) : prop.getReactor();
            int selfVent = prop.getSelf();
            if (reactorVent > 0) {
                int reactorDrain;
                int rheat = reactorDrain = reactor.getHeat();
                if (reactorDrain > reactorVent) {
                    reactorDrain = reactorVent;
                }
                rheat -= reactorDrain;
                if ((reactorDrain = this.alterHeat(stack, reactor, x, y, reactorDrain)) > 0) {
                    return;
                }
                reactor.setHeat(rheat);
            }
            if (electric) {
                if (producing) {
                    reactor.addOutput(-((float)selfVent * 0.005f));
                }
                this.alterHeat(stack, reactor, x, y, producing ? -prop.getSelf() : -(prop.getSelf() / 2));
                return;
            }
            this.alterHeat(stack, reactor, x, y, -selfVent);
        }
    }

    @Override
    public void processTick(ISteamReactor reactor, ItemStack yourStack, int x, int y, boolean heatrun, boolean damageTick) {
        VentProperty prop = this.getProperty(yourStack);
        if (prop == null) {
            return;
        }
        int type = prop.getType();
        if (type == 2) {
            return;
        }
        if (type == 0) {
            this.processChamber(yourStack, reactor, x, y, heatrun);
            return;
        }
        if (heatrun) {
            int heat;
            int reactorVent = prop.getReactor();
            int selfVent = prop.getSelf();
            if (reactorVent > 0) {
                int reactorDrain;
                int rheat = reactorDrain = reactor.getHeat();
                if (reactorDrain > reactorVent) {
                    reactorDrain = reactorVent;
                }
                rheat -= reactorDrain;
                if ((reactorDrain = this.alterHeat(yourStack, reactor, x, y, reactorDrain)) > 0) {
                    return;
                }
                reactor.setHeat(rheat);
            }
            if ((heat = this.getCustomDamage(yourStack)) < 100) {
                if (reactor.getWorldObj().func_82737_E() % 40L == 0L) {
                    this.alterHeat(yourStack, reactor, x, y, -1);
                }
                return;
            }
            double water = this.getWater(yourStack);
            if (water <= 0.0) {
                if (reactor.getWorldObj().func_82737_E() % 40L == 0L) {
                    this.alterHeat(yourStack, reactor, x, y, -1);
                }
                return;
            }
            double heatStorage = this.getHeatStorage(yourStack);
            double heatLevel = (double)heat / ((double)prop.getMaxHeat() - 100.0);
            double lvl = (double)selfVent * heatLevel;
            double consume = Math.min(water, lvl /= 40.0);
            if (consume <= 0.0) {
                return;
            }
            int steam = (int)(160.0 * consume);
            FluidTank tank = reactor.getSteamTank();
            if (steam <= 0 || tank.getCapacity() - tank.getFluidAmount() < steam) {
                return;
            }
            tank.fill(IC2Fluid.getFluidStack("steam", steam), true);
            reactor.addOutput((float)steam / 1.6f / 2.0f);
            int copy = -((int)(heatStorage += consume * 40.0));
            copy -= this.alterHeat(yourStack, reactor, x, y, copy);
            this.setWater(yourStack, water -= consume);
            this.setHeatStorage(yourStack, heatStorage += (double)copy);
        } else {
            this.refill(reactor, yourStack, prop);
        }
    }

    private void refill(ISteamReactor reactor, ItemStack yourStack, VentProperty prop) {
        double water = this.getWater(yourStack);
        if (water > (double)prop.getSelf() - 1.0) {
            return;
        }
        int needed = (int)((double)prop.getSelf() - water);
        FluidTank tank = reactor.getWaterTank();
        if (tank.getFluidAmount() <= 0) {
            return;
        }
        int min = Math.min(tank.getFluidAmount(), needed);
        FluidStack drained = tank.drain(min, true);
        if (drained != null) {
            this.setWater(yourStack, water += (double)drained.amount);
        }
    }

    private double getWater(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74769_h("WaterBuffer");
    }

    private void setWater(ItemStack stack, double water) {
        StackUtil.getOrCreateNbtData(stack).func_74780_a("WaterBuffer", water);
    }

    private double getHeatStorage(ItemStack par1) {
        return StackUtil.getNbtData(par1).func_74769_h("HeatStorage");
    }

    private void setHeatStorage(ItemStack par1, double amount) {
        StackUtil.getOrCreateNbtData(par1).func_74780_a("HeatStorage", amount);
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        VentProperty prop = this.getProperty(stack);
        if (prop == null || prop.getType() != 1) {
            return;
        }
        if (!GuiScreen.func_146272_n()) {
            tooltip.add(Ic2Lang.pressShift.getLocalized());
            return;
        }
        int waterPer = (int)(this.getWater(stack) / (double)prop.getSelf() * 100.0);
        int customDamage = this.getCustomDamage(stack);
        double effizens = customDamage < 100 ? 0.0 : (double)customDamage / ((double)this.getMaxCustomDamage(stack) - 100.0) * 100.0;
        double steamProduction = (double)prop.getSelf() * effizens;
        steamProduction /= 100.0;
        steamProduction /= 40.0;
        tooltip.add(Ic2InfoLang.steamVentWater.getLocalizedFormatted(waterPer + "%"));
        tooltip.add(Ic2InfoLang.steamVentHeat.getLocalizedFormatted((int)effizens + "%"));
        tooltip.add(Ic2InfoLang.steamVentSteam.getLocalizedFormatted((int)(steamProduction *= 160.0) + "~ mB"));
    }

    @Override
    public short getID(ItemStack stack) {
        VentProperty prop = this.getProperty(stack);
        if (prop != null) {
            return prop.getPlannerID();
        }
        return 0;
    }

    @Override
    public IReactorPlannerComponent.ReactorComponentType getType(ItemStack stack) {
        return IReactorPlannerComponent.ReactorComponentType.Vent;
    }

    @Override
    public NBTPrimitive getReactorStat(IReactorPlannerComponent.ReactorComponentStat stat, ItemStack stack) {
        VentProperty prop = this.getProperty(stack);
        if (prop != null) {
            if (stat == IReactorPlannerComponent.ReactorComponentStat.SelfCooling) {
                return new NBTTagInt(prop.getSelf());
            }
            if (stat == IReactorPlannerComponent.ReactorComponentStat.ReactorCooling) {
                return new NBTTagInt(prop.getReactor());
            }
            if (stat == IReactorPlannerComponent.ReactorComponentStat.EnergyUsage) {
                return new NBTTagFloat((float)prop.getSelf() * 0.005f);
            }
            if (stat == IReactorPlannerComponent.ReactorComponentStat.SteamProduction) {
                return new NBTTagFloat((float)(prop.getSelf() * 4));
            }
            if (stat == IReactorPlannerComponent.ReactorComponentStat.WaterConsumtion) {
                return new NBTTagFloat((float)prop.getSelf() / 40.0f);
            }
            if (stat == IReactorPlannerComponent.ReactorComponentStat.WaterStorage) {
                return new NBTTagFloat((float)prop.getSelf());
            }
        }
        return nulltag;
    }

    @Override
    public boolean isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat stat, ItemStack stack) {
        return false;
    }

    @Override
    public NBTPrimitive getReactorStat(IReactor reactor, int x, int y, ItemStack stack, IReactorPlannerComponent.ReactorComponentStat stat) {
        return nulltag;
    }

    @Override
    public IReactorPlannerComponent.ReactorType getReactorInfo(ItemStack stack) {
        VentProperty prop = this.getProperty(stack);
        if (prop != null) {
            if (prop.getType() == 1) {
                return IReactorPlannerComponent.ReactorType.SteamReactor;
            }
            if (prop.getType() == 2) {
                return IReactorPlannerComponent.ReactorType.Reactor;
            }
        }
        return IReactorPlannerComponent.ReactorType.Both;
    }

    @Override
    public List<IReactorPlannerComponent.ReactorComponentStat> getExtraStats(ItemStack stack) {
        VentProperty prop = this.getProperty(stack);
        if (prop != null) {
            if (prop.getType() == 2) {
                ArrayList<IReactorPlannerComponent.ReactorComponentStat> list = new ArrayList<IReactorPlannerComponent.ReactorComponentStat>();
                list.add(IReactorPlannerComponent.ReactorComponentStat.EnergyUsage);
                return list;
            }
            if (prop.getType() == 1) {
                ArrayList<IReactorPlannerComponent.ReactorComponentStat> list = new ArrayList<IReactorPlannerComponent.ReactorComponentStat>();
                list.add(IReactorPlannerComponent.ReactorComponentStat.WaterConsumtion);
                list.add(IReactorPlannerComponent.ReactorComponentStat.SteamProduction);
                list.add(IReactorPlannerComponent.ReactorComponentStat.WaterStorage);
                return list;
            }
        }
        return null;
    }

    public static class VentProperty {
        int self;
        int reactor;
        String sprite;
        int iconPlace;
        LocaleComp comp;
        int type;
        int maxHeat;
        short id;

        public VentProperty(int type, int self, int reactor, int maxHeat, int icon, LocaleComp name, int plannerID) {
            this.type = type;
            this.self = self;
            this.reactor = reactor;
            this.maxHeat = maxHeat;
            this.sprite = "i3";
            this.iconPlace = icon;
            this.comp = name;
            this.id = (short)plannerID;
        }

        public short getPlannerID() {
            return this.id;
        }

        public int getType() {
            return this.type;
        }

        public int getIconPlace() {
            return this.iconPlace;
        }

        public int getReactor() {
            return this.reactor;
        }

        public int getSelf() {
            return this.self;
        }

        public int getMaxHeat() {
            return this.maxHeat;
        }

        public String getSprite() {
            return this.sprite;
        }

        public LocaleComp getName() {
            return this.comp;
        }
    }
}

