/*
 * Decompiled with CFR 0.152.
 */
package ic2.jeiIntigration.core;

import ic2.api.classic.item.IFoamProvider;
import ic2.api.classic.item.IFuelableItem;
import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.custom.IClassicScrapBoxManager;
import ic2.api.classic.recipe.custom.ILiquidFuelGeneratorRegistry;
import ic2.api.classic.recipe.machine.ICannerRegistry;
import ic2.api.classic.recipe.machine.IElectrolyzerRecipeList;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.classic.recipe.machine.IRareEarthExtractorRecipeList;
import ic2.api.item.ICustomDamageItem;
import ic2.api.recipe.IRecipeInput;
import ic2.core.block.machine.high.TileEntityUraniumEnricher;
import ic2.core.inventory.gui.custom.MachineGui;
import ic2.core.item.reactor.uranTypes.IUranium;
import ic2.core.item.recipe.AdvRecipe;
import ic2.core.item.recipe.AdvShapelessRecipe;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Resources;
import ic2.core.platform.registry.Ic2States;
import ic2.jeiIntigration.SubModul;
import ic2.jeiIntigration.core.crafting.CraftingUpgradeClicker;
import ic2.jeiIntigration.core.crafting.IndustrialWorkbenchClicker;
import ic2.jeiIntigration.core.crafting.ShapedAdvRecipeWrapper;
import ic2.jeiIntigration.core.crafting.ShapelessAdvRecipeWrapper;
import ic2.jeiIntigration.core.machine.basic.MachineRecipe;
import ic2.jeiIntigration.core.machine.basic.MachineRecipeCategory;
import ic2.jeiIntigration.core.machine.basic.MachineRecipeWrapper;
import ic2.jeiIntigration.core.machine.canner.CannerFillWrapper;
import ic2.jeiIntigration.core.machine.canner.CannerRecipeCategory;
import ic2.jeiIntigration.core.machine.canner.CannerRepairWrapper;
import ic2.jeiIntigration.core.machine.canner.FoodCanRecipeWrapper;
import ic2.jeiIntigration.core.machine.canner.FuelCannerRecipeWrapper;
import ic2.jeiIntigration.core.machine.canner.FuelableCannerRecipeWrapper;
import ic2.jeiIntigration.core.machine.electrolyzer.ElectorlyzerRecipeCategory;
import ic2.jeiIntigration.core.machine.electrolyzer.ElectrolyzerRecipeWrapper;
import ic2.jeiIntigration.core.machine.liquidFuel.LiquidFuelCategory;
import ic2.jeiIntigration.core.machine.liquidFuel.LiquidFuelWrapper;
import ic2.jeiIntigration.core.machine.rareEarth.RareEarthCategory;
import ic2.jeiIntigration.core.machine.rareEarth.RareEarthWrapper;
import ic2.jeiIntigration.core.machine.uraniumEnricher.UraniumEnricherCategory;
import ic2.jeiIntigration.core.machine.uraniumEnricher.UraniumEnricherWrapper;
import ic2.jeiIntigration.core.misc.ReactorPlannerHandler;
import ic2.jeiIntigration.core.misc.ScrapBoxCategory;
import ic2.jeiIntigration.core.misc.ScrapBoxWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;

@JEIPlugin
public class JeiPlugin
implements IModPlugin {
    public void onRuntimeAvailable(@Nonnull IJeiRuntime arg0) {
    }

    public void register(@Nonnull IModRegistry registry) {
        if (!SubModul.load) {
            return;
        }
        final IJeiHelpers helper = registry.getJeiHelpers();
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferHandler)new CraftingUpgradeClicker(), "minecraft.crafting");
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferHandler)new IndustrialWorkbenchClicker(), "minecraft.crafting");
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new ReactorPlannerHandler()});
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.handleRecipes(MachineRecipe.class, (IRecipeWrapperFactory)new MachineRecipeWrapper.MachineManager(), "macerator");
        registry.addRecipeCatalyst((Object)Ic2Items.stoneMacerator, new String[]{"macerator"});
        registry.addRecipeCatalyst((Object)Ic2Items.macerator.func_77946_l(), new String[]{"macerator"});
        registry.addRecipeCatalyst((Object)Ic2Items.rotaryMacerator.func_77946_l(), new String[]{"macerator"});
        registry.addRecipeClickArea(MachineGui.MaceratorGui.class, 78, 32, 20, 23, new String[]{"macerator"});
        registry.handleRecipes(MachineRecipe.class, (IRecipeWrapperFactory)new MachineRecipeWrapper.MachineManager(), "extractor");
        registry.addRecipeCatalyst((Object)Ic2Items.extractor.func_77946_l(), new String[]{"extractor"});
        registry.addRecipeCatalyst((Object)Ic2Items.centrifugalExtractor.func_77946_l(), new String[]{"extractor"});
        registry.addRecipeClickArea(MachineGui.ExtractorGui.class, 78, 32, 20, 23, new String[]{"extractor"});
        registry.addRecipeClickArea(MachineGui.CentriExtractorGui.class, 58, 30, 25, 23, new String[]{"extractor"});
        registry.handleRecipes(MachineRecipe.class, (IRecipeWrapperFactory)new MachineRecipeWrapper.MachineManager(), "compressor");
        registry.addRecipeCatalyst((Object)Ic2Items.compressor.func_77946_l(), new String[]{"compressor"});
        registry.addRecipeCatalyst((Object)Ic2Items.singularityCompressor.func_77946_l(), new String[]{"compressor"});
        registry.addRecipeClickArea(MachineGui.CompressorGui.class, 78, 32, 20, 23, new String[]{"compressor"});
        registry.handleRecipes(MachineRecipe.class, (IRecipeWrapperFactory)new MachineRecipeWrapper.MachineManager(), "recycler");
        registry.addRecipeCatalyst((Object)Ic2Items.recycler.func_77946_l(), new String[]{"recycler"});
        registry.addRecipeCatalyst((Object)Ic2Items.compactingRecycler.func_77946_l(), new String[]{"recycler"});
        registry.addRecipeClickArea(MachineGui.RecyclerGui.class, 78, 32, 20, 23, new String[]{"recycler"});
        registry.handleRecipes(MachineRecipe.class, (IRecipeWrapperFactory)new MachineRecipeWrapper.MachineManager(), "sawmill");
        registry.addRecipeCatalyst((Object)Ic2Items.sawMill.func_77946_l(), new String[]{"sawmill"});
        registry.addRecipeClickArea(MachineGui.SawMillGui.class, 78, 32, 20, 23, new String[]{"sawmill"});
        registry.addRecipeCatalyst((Object)Ic2Items.industrialWorktable.func_77946_l(), new String[]{"minecraft.crafting"});
        registry.addRecipeCatalyst((Object)Ic2Items.ironFurnace.func_77946_l(), new String[]{"minecraft.smelting"});
        registry.addRecipeCatalyst((Object)Ic2Items.electroFurnace.func_77946_l(), new String[]{"minecraft.smelting"});
        registry.addRecipeCatalyst((Object)Ic2Items.inductionFurnace.func_77946_l(), new String[]{"minecraft.smelting"});
        registry.addRecipeClickArea(MachineGui.FurnaceGui.class, 78, 32, 20, 23, new String[]{"minecraft.smelting"});
        registry.handleRecipes(ILiquidFuelGeneratorRegistry.BurnEntry.class, (IRecipeWrapperFactory)new IRecipeWrapperFactory<ILiquidFuelGeneratorRegistry.BurnEntry>(){

            public IRecipeWrapper getRecipeWrapper(ILiquidFuelGeneratorRegistry.BurnEntry arg0) {
                return new LiquidFuelWrapper(arg0);
            }
        }, "ic2:liquidFuel");
        registry.addRecipeCatalyst((Object)Ic2Items.liquidFuelGenerator.func_77946_l(), new String[]{"ic2:liquidFuel"});
        registry.addRecipeClickArea(MachineGui.LiquidFuelGui.class, 78, 32, 20, 23, new String[]{"ic2:liquidFuel"});
        registry.handleRecipes(IRareEarthExtractorRecipeList.EarthEntry.class, (IRecipeWrapperFactory)new IRecipeWrapperFactory<IRareEarthExtractorRecipeList.EarthEntry>(){

            public IRecipeWrapper getRecipeWrapper(IRareEarthExtractorRecipeList.EarthEntry arg0) {
                return new RareEarthWrapper(arg0);
            }
        }, "ic2:rareEarth");
        registry.addRecipeCatalyst((Object)Ic2Items.rareEarthExtractor.func_77946_l(), new String[]{"ic2:rareEarth"});
        registry.addRecipeClickArea(MachineGui.RareEarthGui.class, 78, 32, 20, 23, new String[]{"ic2:rareEarth"});
        registry.handleRecipes(IUranium.class, (IRecipeWrapperFactory)new IRecipeWrapperFactory<IUranium>(){

            public IRecipeWrapper getRecipeWrapper(IUranium var1) {
                return new UraniumEnricherWrapper(var1);
            }
        }, "uranium-enricher");
        registry.addRecipeClickArea(MachineGui.EnricherGui.class, 90, 15, 5, 34, new String[]{"uranium-enricher"});
        registry.addRecipeCatalyst((Object)Ic2Items.uraniumEnricher.func_77946_l(), new String[]{"uranium-enricher"});
        registry.addRecipes(this.createRecipeList(), "uranium-enricher");
        registry.addRecipes(this.createMachineRecipes(ClassicRecipes.macerator, "macerator"), "macerator");
        registry.addRecipes(this.createMachineRecipes(ClassicRecipes.extractor, "extractor"), "extractor");
        registry.addRecipes(this.createMachineRecipes(ClassicRecipes.compressor, "compressor"), "compressor");
        registry.addRecipes(this.createMachineRecipes(ClassicRecipes.recycler, "recycler"), "recycler");
        registry.addRecipes(this.createMachineRecipes(ClassicRecipes.sawMill, "sawmill"), "sawmill");
        registry.addRecipes(new ArrayList<ILiquidFuelGeneratorRegistry.BurnEntry>(ClassicRecipes.fluidGenerator.getBurnMap().values()), "ic2:liquidFuel");
        registry.addRecipes(ClassicRecipes.earthExtractor.getRecipeList(), "ic2:rareEarth");
        registry.handleRecipes(IClassicScrapBoxManager.IDrop.class, (IRecipeWrapperFactory)new IRecipeWrapperFactory<IClassicScrapBoxManager.IDrop>(){

            public IRecipeWrapper getRecipeWrapper(IClassicScrapBoxManager.IDrop arg0) {
                return new ScrapBoxWrapper(arg0);
            }
        }, "scrapbox");
        registry.addRecipes(ClassicRecipes.scrapboxDrops.getEntries(), "scrapbox");
        registry.addRecipeCatalyst((Object)Ic2Items.scrapBox.func_77946_l(), new String[]{"scrapbox"});
        registry.handleRecipes(IElectrolyzerRecipeList.RecipeEntry.class, (IRecipeWrapperFactory)new ElectrolyzerRecipeWrapper.Wrapper(), "electrolyzer");
        registry.addRecipes(ClassicRecipes.electrolyzer.getRecipeList(), "electrolyzer");
        registry.addRecipeCatalyst((Object)Ic2Items.electrolyzer.func_77946_l(), new String[]{"electrolyzer"});
        registry.addRecipeCatalyst((Object)Ic2Items.chargedElectrolyzer.func_77946_l(), new String[]{"electrolyzer"});
        registry.handleRecipes(FuelableCannerRecipeWrapper.FuelableItem.class, (IRecipeWrapperFactory)new IRecipeWrapperFactory<FuelableCannerRecipeWrapper.FuelableItem>(){

            public IRecipeWrapper getRecipeWrapper(FuelableCannerRecipeWrapper.FuelableItem arg0) {
                return new FuelableCannerRecipeWrapper(arg0);
            }
        }, "canner");
        registry.handleRecipes(ICannerRegistry.FuelInfo.class, (IRecipeWrapperFactory)new IRecipeWrapperFactory<ICannerRegistry.FuelInfo>(){

            public IRecipeWrapper getRecipeWrapper(ICannerRegistry.FuelInfo arg0) {
                return new FuelCannerRecipeWrapper(arg0);
            }
        }, "canner");
        registry.handleRecipes(FoodCanRecipeWrapper.FoodEntry.class, (IRecipeWrapperFactory)new IRecipeWrapperFactory<FoodCanRecipeWrapper.FoodEntry>(){

            public IRecipeWrapper getRecipeWrapper(FoodCanRecipeWrapper.FoodEntry arg0) {
                return new FoodCanRecipeWrapper(arg0);
            }
        }, "canner");
        registry.handleRecipes(CannerRepairWrapper.RepairEntry.class, (IRecipeWrapperFactory)new IRecipeWrapperFactory<CannerRepairWrapper.RepairEntry>(){

            public IRecipeWrapper getRecipeWrapper(CannerRepairWrapper.RepairEntry arg0) {
                return new CannerRepairWrapper(arg0);
            }
        }, "canner");
        registry.handleRecipes(CannerFillWrapper.FillEntry.class, (IRecipeWrapperFactory)new IRecipeWrapperFactory<CannerFillWrapper.FillEntry>(){

            public IRecipeWrapper getRecipeWrapper(CannerFillWrapper.FillEntry arg0) {
                return new CannerFillWrapper(arg0);
            }
        }, "canner");
        registry.addRecipeCatalyst((Object)Ic2Items.canner.func_77946_l(), new String[]{"canner"});
        registry.addRecipeCatalyst((Object)Ic2Items.vacuumCanner.func_77946_l(), new String[]{"canner"});
        registry.addRecipes((Collection)this.getCanRecipes(), "canner");
        registry.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)Ic2Items.noUse.func_77946_l());
        registry.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(Ic2States.noUse.func_177230_c()));
        registry.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)Ic2Items.displayIcons[0].func_77946_l());
        registry.getJeiHelpers().getItemBlacklist().addItemToBlacklist(Ic2Items.noUse.func_77946_l());
        registry.getJeiHelpers().getItemBlacklist().addItemToBlacklist(new ItemStack(Ic2States.noUse.func_177230_c()));
        registry.getJeiHelpers().getItemBlacklist().addItemToBlacklist(Ic2Items.displayIcons[0].func_77946_l());
        registry.handleRecipes(AdvRecipe.class, (IRecipeWrapperFactory)new IRecipeWrapperFactory<AdvRecipe>(){

            public IRecipeWrapper getRecipeWrapper(AdvRecipe arg0) {
                return new ShapedAdvRecipeWrapper(helper, arg0);
            }
        }, "minecraft.crafting");
        registry.handleRecipes(AdvShapelessRecipe.class, (IRecipeWrapperFactory)new IRecipeWrapperFactory<AdvShapelessRecipe>(){

            public IRecipeWrapper getRecipeWrapper(AdvShapelessRecipe arg0) {
                return new ShapelessAdvRecipeWrapper(helper, arg0);
            }
        }, "minecraft.crafting");
    }

    public void registerIngredients(IModIngredientRegistration arg0) {
    }

    public void registerItemSubtypes(ISubtypeRegistry arg0) {
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper helper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new MachineRecipeCategory(helper, "macerator", Ic2Items.macerator.func_77946_l(), Ic2Resources.macerator), new MachineRecipeCategory(helper, "extractor", Ic2Items.extractor.func_77946_l(), Ic2Resources.extractor), new MachineRecipeCategory(helper, "compressor", Ic2Items.compressor.func_77946_l(), Ic2Resources.compressor), new MachineRecipeCategory(helper, "recycler", Ic2Items.recycler.func_77946_l(), Ic2Resources.recycler), new MachineRecipeCategory(helper, "sawmill", Ic2Items.sawMill.func_77946_l(), Ic2Resources.sawmill), new LiquidFuelCategory(helper), new RareEarthCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ScrapBoxCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ElectorlyzerRecipeCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CannerRecipeCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new UraniumEnricherCategory(helper)});
    }

    public List<IUranium> createRecipeList() {
        ArrayList<IUranium> list = new ArrayList<IUranium>();
        for (IUranium uranium : TileEntityUraniumEnricher.RECIPE_LIST) {
            if (!uranium.isReEnrichedUran()) continue;
            list.add(uranium);
        }
        return list;
    }

    public List getCanRecipes() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(ClassicRecipes.canningMachine.getAllFuelTypes());
        for (Item item : Item.field_150901_e) {
            if (item instanceof IFuelableItem) {
                list.add(new FuelableCannerRecipeWrapper.FuelableItem(new ItemStack(item)));
            }
            if (item instanceof IFoamProvider) {
                list.add(new FuelableCannerRecipeWrapper.FuelableItem(new ItemStack(item), Ic2Items.constructionFoamPellet.func_77946_l(), 26));
            }
            if (!(item instanceof ItemFood)) continue;
            NonNullList items = NonNullList.func_191196_a();
            item.func_150895_a(CreativeTabs.field_78027_g, items);
            for (ItemStack itemStack : items) {
                FoodCanRecipeWrapper.FoodEntry entry = new FoodCanRecipeWrapper.FoodEntry((ItemFood)item, itemStack);
                if (entry.getCanAmount() <= 0) continue;
                list.add(entry);
            }
        }
        list.add(new FoodCanRecipeWrapper.FoodEntry(6, new ItemStack(Items.field_151105_aU)));
        for (Map.Entry<ICustomDamageItem, List<Tuple<Integer, Tuple<IRecipeInput, Integer>>>> entry : ClassicRecipes.canningMachine.getRepairMap().entrySet()) {
            ICustomDamageItem item = entry.getKey();
            for (Tuple<Integer, Tuple<IRecipeInput, Integer>> tuple : entry.getValue()) {
                list.add(new CannerRepairWrapper.RepairEntry(item, tuple));
            }
        }
        for (Map.Entry<ICustomDamageItem, List<Object>> entry : ClassicRecipes.canningMachine.getCanningMap().entrySet()) {
            ItemStack base = (ItemStack)entry.getKey();
            for (Tuple tuple : entry.getValue()) {
                list.add(new CannerFillWrapper.FillEntry(base, (Tuple<IRecipeInput, ItemStack>)tuple));
            }
        }
        return list;
    }

    public List<MachineRecipe> createMachineRecipes(IMachineRecipeList recipe, String id) {
        ArrayList<MachineRecipe> recipes = new ArrayList<MachineRecipe>();
        for (IMachineRecipeList.RecipeEntry entry : recipe.getRecipeMap()) {
            recipes.add(new MachineRecipe(id, entry));
        }
        return recipes;
    }
}

