/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.blocks.tileentity;

import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.recipe.RecipeModifierHelpers;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.classic.tile.IMachine;
import ic2.api.classic.tile.IStackOutput;
import ic2.api.classic.tile.MachineType;
import ic2.api.recipe.IRecipeInput;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityBasicElectricMachine;
import ic2.core.block.base.util.output.SimpleStackOutput;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.ArrayFilter;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.filters.MachineFilter;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.inventory.transport.wrapper.RangedInventoryWrapper;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ResourceLocation;
import trinsdar.ic2c_extras.blocks.container.ContainerThermalCentrifuge;
import trinsdar.ic2c_extras.recipes.Ic2cExtrasRecipes;
import trinsdar.ic2c_extras.util.GuiMachine;
import trinsdar.ic2c_extras.util.references.Ic2cExtrasLang;
import trinsdar.ic2c_extras.util.references.Ic2cExtrasResourceLocations;

public class TileEntityThermalCentrifuge
extends TileEntityBasicElectricMachine {
    @NetworkField(index=13)
    public int maxHeat = 500;
    @NetworkField(index=14)
    public int heat;
    private static final int defaultEu = 20;
    public static final String neededHeat = "minHeat";
    public static final int slotInput = 0;
    public static final int slotFuel = 1;
    public static final int slotOutput = 2;
    public static final int slotOutput2 = 3;
    public static final int slotOutput3 = 4;

    public TileEntityThermalCentrifuge() {
        super(5, 20, 400, 128);
        this.addGuiFields(new String[]{"heat", "maxHeat"});
    }

    public float getHeat() {
        return this.heat;
    }

    public float getMaxHeat() {
        return TileEntityThermalCentrifuge.getRequiredHeat(this.lastRecipe.getOutput());
    }

    public IMachineRecipeList.RecipeEntry getOutputFor(ItemStack input) {
        return Ic2cExtrasRecipes.thermalCentrifuge.getRecipeInAndOutput(input, false);
    }

    public ResourceLocation getGuiTexture() {
        return Ic2cExtrasResourceLocations.thermalCentrifuge;
    }

    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, new int[]{1});
        handler.registerDefaultSlotAccess(AccessRule.Import, new int[]{0});
        handler.registerDefaultSlotAccess(AccessRule.Export, new int[]{2, 3, 4});
        handler.registerDefaultSlotsForSide(RotationList.UP.invert(), new int[]{2, 3, 4});
        handler.registerDefaultSlotsForSide(RotationList.DOWN.invert(), new int[]{0});
        handler.registerInputFilter((IFilter)new ArrayFilter(new IFilter[]{CommonFilters.DischargeEU, new BasicItemFilter(Items.field_151137_ax), new BasicItemFilter(Ic2Items.suBattery)}), new int[]{1});
        handler.registerInputFilter(this.filter, new int[]{0});
        handler.registerOutputFilter(CommonFilters.NotDischargeEU, new int[]{1});
        handler.registerSlotType(SlotType.Fuel, new int[]{1});
        handler.registerSlotType(SlotType.Input, new int[]{0});
        handler.registerSlotType(SlotType.Output, new int[]{2, 3, 4});
    }

    public IHasInventory getInputInventory() {
        return new RangedInventoryWrapper((IHasInventory)this, new int[]{0}).setFilters((IFilter)new MachineFilter((IMachine)this));
    }

    public ResourceLocation getStartSoundFile() {
        return Ic2Sounds.extractorOp;
    }

    public ResourceLocation getInterruptSoundFile() {
        return Ic2Sounds.interruptingSound;
    }

    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerThermalCentrifuge(player.field_71071_by, this);
    }

    public IMachineRecipeList getRecipeList() {
        return Ic2cExtrasRecipes.thermalCentrifuge;
    }

    public MachineType getType() {
        return null;
    }

    public double getWrenchDropRate() {
        return 1.0;
    }

    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiMachine.ThermalCentrifugeGui.class;
    }

    public LocaleComp getBlockName() {
        return Ic2cExtrasLang.thermalCentrifuge;
    }

    protected EnumActionResult isRecipeStillValid(IMachineRecipeList.RecipeEntry entry) {
        if (this.heat >= TileEntityThermalCentrifuge.getRequiredHeat(entry.getOutput())) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean canWork() {
        return this.heat == this.maxHeat && super.canWork();
    }

    protected EnumActionResult canFillRecipeIntoOutputs(MachineOutput output) {
        List result = output.getAllOutputs();
        for (int i = 0; i < result.size() && i < 3; ++i) {
            ItemStack stack = this.getStackInSlot(2 + i);
            ItemStack extra = (ItemStack)result.get(i);
            if ((stack.func_190926_b() || StackUtil.isStackEqual((ItemStack)stack, (ItemStack)extra, (boolean)false, (boolean)true)) && stack.func_190916_E() + extra.func_190916_E() <= extra.func_77976_d()) continue;
            return EnumActionResult.PASS;
        }
        return EnumActionResult.SUCCESS;
    }

    public void operateOnce(IRecipeInput input, MachineOutput output, List<IStackOutput> list) {
        List result = output.getRecipeOutput(this.func_145831_w().field_73012_v, this.getTileData());
        for (int i = 0; i < result.size(); ++i) {
            list.add((IStackOutput)new SimpleStackOutput((ItemStack)result.get(i), 2 + i % 3));
        }
        this.consumeInput(input);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.lastRecipe != null && !((ItemStack)this.inventory.get(0)).func_190926_b() && this.energy > 0) {
            int newMaxHeat = (int)this.getMaxHeat();
            if (newMaxHeat != this.maxHeat) {
                this.maxHeat = newMaxHeat;
                this.getNetwork().updateTileGuiField((TileEntity)this, "maxHeat");
            }
            if ((float)this.heat < this.getMaxHeat()) {
                ++this.heat;
                this.getNetwork().updateTileGuiField((TileEntity)this, "heat");
            }
            if ((float)this.heat > this.getMaxHeat()) {
                this.heat = (int)this.getMaxHeat();
                this.getNetwork().updateTileGuiField((TileEntity)this, "heat");
            }
            this.useEnergy(1);
        } else if (this.heat > 0) {
            int newMaxHeat = 500;
            if (newMaxHeat != this.maxHeat) {
                this.maxHeat = newMaxHeat;
                this.getNetwork().updateTileGuiField((TileEntity)this, "maxHeat");
            }
            this.heat -= Math.min(this.heat, 4);
            this.getNetwork().updateTileGuiField((TileEntity)this, "heat");
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.heat = nbt.func_74762_e("Heat");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Heat", this.heat);
        return nbt;
    }

    public static int getRequiredHeat(MachineOutput output) {
        if (output == null || output.getMetadata() == null) {
            return 1;
        }
        return output.getMetadata().func_74762_e(neededHeat);
    }

    public static void addRecipe(IRecipeInput input, int hear, ItemStack ... output) {
        TileEntityThermalCentrifuge.addRecipe(input, hear, 8000, output);
    }

    public static void addRecipe(IRecipeInput input, int hear, int totalEu, ItemStack ... output) {
        TileEntityThermalCentrifuge.addRecipe(input, hear, TileEntityThermalCentrifuge.totalEu(totalEu), output);
    }

    public static void addRecipe(IRecipeInput input, int heat, RecipeModifierHelpers.IRecipeModifier[] modifiers, ItemStack ... output) {
        ArrayList<RecipeModifierHelpers.IRecipeModifier> outputlist = new ArrayList<RecipeModifierHelpers.IRecipeModifier>();
        NBTTagCompound nbt = new NBTTagCompound();
        for (RecipeModifierHelpers.IRecipeModifier iRecipeModifier : modifiers) {
            iRecipeModifier.apply(nbt);
        }
        nbt.func_74768_a(neededHeat, heat);
        if (heat <= 0) {
            nbt = null;
        }
        for (RecipeModifierHelpers.IRecipeModifier iRecipeModifier : output) {
            outputlist.add(iRecipeModifier);
        }
        TileEntityThermalCentrifuge.addRecipe(input, new MachineOutput(nbt, outputlist));
    }

    public static RecipeModifierHelpers.IRecipeModifier[] totalEu(int amount) {
        return new RecipeModifierHelpers.IRecipeModifier[]{RecipeModifierHelpers.ModifierType.RECIPE_LENGTH.create(amount / 20 - 400)};
    }

    public static void addRecipe(IRecipeInput input, MachineOutput output) {
        Ic2cExtrasRecipes.thermalCentrifuge.addRecipe(input, output, ((ItemStack)input.getInputs().get(0)).func_77977_a());
    }
}

