/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.blocks.tileentity.base;

import ic2.api.classic.audio.PositionSpec;
import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.classic.tile.IInfoTile;
import ic2.api.classic.tile.IMachine;
import ic2.api.classic.tile.IStackOutput;
import ic2.api.classic.tile.machine.IProgressMachine;
import ic2.api.energy.EnergyNet;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.api.recipe.IRecipeInput;
import ic2.core.IC2;
import ic2.core.audio.AudioSource;
import ic2.core.block.base.tile.TileEntityBasicElectricMachine;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.base.util.info.EnergyUsageInfo;
import ic2.core.block.base.util.info.ProgressInfo;
import ic2.core.block.base.util.info.misc.IEnergyUser;
import ic2.core.block.base.util.output.IStackRegistry;
import ic2.core.block.base.util.output.MultiSlotOutput;
import ic2.core.fluid.IC2Tank;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.transport.wrapper.RangedInventoryWrapper;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IOutputMachine;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.Predicate;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinsdar.ic2c_extras.util.recipelists.FluidCanningRecipeList;

public abstract class TileEntityFluidCannerBase
extends TileEntityElecMachine
implements IOutputMachine,
IProgressMachine,
IEnergyUser,
ITickable,
IHasGui,
INetworkTileEntityEventListener {
    @NetworkField(index=7)
    public int progress = 0;
    public int defaultEnergyConsume;
    public int defaultOperationLength;
    public int defaultMaxInput;
    public int defaultEnergyStorage;
    public int energyConsume;
    public int operationLength;
    public float progressPerTick;
    @NetworkField(index=8)
    public float soundLevel = 1.0f;
    @NetworkField(index=9)
    public int recipeOperation;
    @NetworkField(index=10)
    public int recipeEnergy;
    @NetworkField(index=11)
    public boolean redstoneInverted;
    @NetworkField(index=12)
    public boolean redstoneSensitive;
    public boolean defaultSensitive;
    public FluidCanningRecipeList.FluidCanningRecipe lastRecipe;
    public final boolean supportsUpgrades;
    public final int upgradeSlots;
    @NetworkField(index=13)
    public IC2Tank inputTank = new IC2Tank(10000);
    @NetworkField(index=14)
    public IC2Tank outputTank = new IC2Tank(10000);
    public static int slotInput;
    public static int slotOutput;
    public AudioSource audioSource;
    protected LinkedList<IStackOutput> outputs = new LinkedList();

    public TileEntityFluidCannerBase(int slots, int upgrades, int energyPerTick, int maxProgress, int maxinput) {
        super(slots + upgrades, maxinput);
        this.supportsUpgrades = upgrades > 0;
        this.upgradeSlots = upgrades;
        this.energyConsume = energyPerTick;
        this.defaultEnergyConsume = energyPerTick;
        this.operationLength = maxProgress;
        this.defaultOperationLength = maxProgress;
        this.defaultMaxInput = this.maxInput;
        this.defaultEnergyStorage = energyPerTick * maxProgress;
        this.defaultSensitive = false;
        this.progressPerTick = 1.0f;
        this.addNetworkFields(new String[]{"soundLevel", "redstoneInverted", "redstoneSensitive"});
        this.addGuiFields(new String[]{"recipeOperation", "recipeEnergy", "progress"});
        this.addInfos(new IInfoTile.InfoComponent[]{new EnergyUsageInfo((IEnergyUser)this), new ProgressInfo((IProgressMachine)this)});
    }

    public void func_73660_a() {
        boolean operate;
        this.handleRedstone();
        this.updateNeighbors();
        boolean noRoom = this.addToInventory();
        FluidCanningRecipeList.FluidCanningRecipe recipe = this.getRecipe();
        boolean canWork = this.canWork() && !noRoom;
        boolean bl = operate = canWork && recipe != null;
        if (operate) {
            this.handleChargeSlot(this.maxEnergy);
        }
        if (operate && this.energy >= this.energyConsume) {
            if (!this.getActive()) {
                this.getNetwork().initiateTileEntityEvent((TileEntity)this, 0, false);
            }
            this.setActive(true);
            this.progress = (int)((float)this.progress + this.progressPerTick);
            this.useEnergy(this.recipeEnergy);
            if (this.progress >= this.recipeOperation) {
                this.process(recipe);
                this.progress = 0;
                this.notifyNeighbors();
            }
            this.getNetwork().updateTileGuiField((TileEntity)this, "progress");
        } else {
            if (this.getActive()) {
                if (this.progress != 0) {
                    this.getNetwork().initiateTileEntityEvent((TileEntity)this, 1, false);
                } else {
                    this.getNetwork().initiateTileEntityEvent((TileEntity)this, 2, false);
                }
            }
            if (recipe == null && this.progress != 0) {
                this.progress = 0;
                this.getNetwork().updateTileGuiField((TileEntity)this, "progress");
            }
            this.setActive(false);
        }
        if (this.supportsUpgrades) {
            for (int i = 0; i < this.upgradeSlots; ++i) {
                ItemStack item = (ItemStack)this.inventory.get(i + this.inventory.size() - this.upgradeSlots);
                if (!(item.func_77973_b() instanceof IMachineUpgradeItem)) continue;
                ((IMachineUpgradeItem)item.func_77973_b()).onTick(item, (IMachine)this);
            }
        }
        this.updateComparators();
    }

    public void process(FluidCanningRecipeList.FluidCanningRecipe recipe) {
        ItemStack stack2;
        if (recipe.hasItemOutput()) {
            for (ItemStack stack2 : recipe.getOutputs().getRecipeOutput(this.func_145831_w().field_73012_v, this.getTileData())) {
                this.outputs.add((IStackOutput)new MultiSlotOutput(stack2, this.getOutputSlots()));
            }
        }
        IRecipeInput input = recipe.getInput();
        stack2 = (ItemStack)this.inventory.get(slotInput);
        if (stack2.func_77973_b().hasContainerItem(stack2)) {
            this.inventory.set(slotInput, (Object)stack2.func_77973_b().getContainerItem(stack2));
        } else {
            stack2.func_190918_g(input.getAmount());
        }
        this.inputTank.drain(recipe.getInputFluid(), true);
        if (recipe.hasFluidOutput()) {
            this.outputTank.fill(recipe.getOutputFluid(), true);
        }
        this.addToInventory();
        for (int i = 0; i < this.upgradeSlots; ++i) {
            ItemStack item = (ItemStack)this.inventory.get(i + this.inventory.size() - this.upgradeSlots);
            if (!(item.func_77973_b() instanceof IMachineUpgradeItem)) continue;
            ((IMachineUpgradeItem)item.func_77973_b()).onProcessFinished(item, (IMachine)this);
        }
    }

    protected FluidCanningRecipeList.FluidCanningRecipe getRecipe() {
        if (((ItemStack)this.inventory.get(slotInput)).func_190926_b()) {
            return null;
        }
        if (this.lastRecipe == FluidCanningRecipeList.INVALID_RECIPE) {
            return null;
        }
        if (this.lastRecipe != null && !this.checkRecipe(this.lastRecipe)) {
            this.lastRecipe = null;
            this.applyRecipeEffect(null);
        }
        if (this.lastRecipe == null) {
            this.lastRecipe = this.getRecipeList().getRecipe(new Predicate<FluidCanningRecipeList.FluidCanningRecipe>(){

                @Override
                public boolean test(FluidCanningRecipeList.FluidCanningRecipe t) {
                    return TileEntityFluidCannerBase.this.checkRecipe(t);
                }
            });
            if (this.lastRecipe == FluidCanningRecipeList.INVALID_RECIPE) {
                return null;
            }
            this.applyRecipeEffect(this.lastRecipe.getOutputs());
        }
        if (this.lastRecipe == null) {
            return null;
        }
        if (this.lastRecipe.hasItemOutput() && this.lastRecipe.hasFluidOutput()) {
            if (this.lastRecipe.getOutputFluid().isFluidEqual(this.outputTank.getFluid()) && this.outputTank.getFluidAmount() + this.lastRecipe.getOutputFluid().amount <= this.outputTank.getCapacity() || this.outputTank.getFluidAmount() == 0) {
                if (this.getStackInSlot(slotOutput).func_190926_b()) {
                    return this.lastRecipe;
                }
                for (ItemStack output : this.lastRecipe.getOutputs().getAllOutputs()) {
                    if (!StackUtil.isStackEqual((ItemStack)((ItemStack)this.inventory.get(slotOutput)), (ItemStack)output, (boolean)false, (boolean)true) || ((ItemStack)this.inventory.get(slotOutput)).func_190916_E() + output.func_190916_E() > ((ItemStack)this.inventory.get(slotOutput)).func_77976_d()) continue;
                    return this.lastRecipe;
                }
            }
        } else if (this.lastRecipe.hasItemOutput()) {
            if (this.getStackInSlot(slotOutput).func_190926_b()) {
                return this.lastRecipe;
            }
            for (ItemStack output : this.lastRecipe.getOutputs().getAllOutputs()) {
                if (!StackUtil.isStackEqual((ItemStack)((ItemStack)this.inventory.get(slotOutput)), (ItemStack)output, (boolean)false, (boolean)true) || ((ItemStack)this.inventory.get(slotOutput)).func_190916_E() + output.func_190916_E() > ((ItemStack)this.inventory.get(slotOutput)).func_77976_d()) continue;
                return this.lastRecipe;
            }
        } else if (this.lastRecipe.hasFluidOutput() && (this.lastRecipe.getOutputFluid().isFluidEqual(this.outputTank.getFluid()) && this.outputTank.getFluidAmount() + this.lastRecipe.getOutputFluid().amount <= this.outputTank.getCapacity() || this.outputTank.getFluidAmount() == 0)) {
            return this.lastRecipe;
        }
        return null;
    }

    public boolean addToInventory() {
        if (this.outputs.isEmpty()) {
            return false;
        }
        Iterator iter = this.outputs.iterator();
        while (iter.hasNext()) {
            IStackOutput output = (IStackOutput)iter.next();
            if (!output.addToInventory((IHasInventory)this)) continue;
            iter.remove();
        }
        return this.outputs.size() > 0;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        super.setStackInSlot(slot, stack);
        if (this.isSimulating() && this.lastRecipe == FluidCanningRecipeList.INVALID_RECIPE && this.isRecipeSlot(slot)) {
            this.lastRecipe = null;
        }
    }

    public void applyRecipeEffect(MachineOutput output) {
        if (output == null || output.getMetadata() == null) {
            if (this.recipeEnergy != this.energyConsume) {
                this.recipeEnergy = this.energyConsume;
                if (this.recipeEnergy < 1) {
                    this.recipeEnergy = 1;
                }
                this.getNetwork().updateTileGuiField((TileEntity)this, "recipeEnergy");
            }
            if (this.recipeOperation != this.operationLength) {
                this.recipeOperation = this.operationLength;
                if (this.recipeOperation < 1) {
                    this.recipeOperation = 1;
                }
                this.getNetwork().updateTileGuiField((TileEntity)this, "recipeOperation");
            }
            return;
        }
        NBTTagCompound nbt = output.getMetadata();
        double energyMod = nbt.func_74764_b("RecipeEnergyModifier") ? nbt.func_74769_h("RecipeEnergyModifier") : 1.0;
        int newEnergy = TileEntityBasicElectricMachine.applyModifier((int)this.energyConsume, (int)nbt.func_74762_e("RecipeEnergy"), (double)energyMod);
        if (newEnergy != this.recipeEnergy) {
            this.recipeEnergy = newEnergy;
            if (this.recipeEnergy < 1) {
                this.recipeEnergy = 1;
            }
            this.getNetwork().updateTileGuiField((TileEntity)this, "recipeEnergy");
        }
        double progMod = nbt.func_74764_b("RecipeTimeModifier") ? nbt.func_74769_h("RecipeTimeModifier") : 1.0;
        int newProgress = TileEntityBasicElectricMachine.applyModifier((int)this.operationLength, (int)nbt.func_74762_e("RecipeTime"), (double)progMod);
        if (newProgress != this.recipeOperation) {
            this.recipeOperation = newProgress;
            if (this.recipeOperation < 1) {
                this.recipeOperation = 1;
            }
            this.getNetwork().updateTileGuiField((TileEntity)this, "recipeOperation");
        }
    }

    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating()) {
            this.setOverclockRates();
        }
    }

    public void setOverclockRates() {
        this.lastRecipe = null;
        int extraProcessSpeed = 0;
        double processingSpeedMultiplier = 1.0;
        int extraProcessTime = 0;
        double processTimeMultiplier = 1.0;
        int extraEnergyDemand = 0;
        double energyDemandMultiplier = 1.0;
        int extraEnergyStorage = 0;
        double energyStorageMultiplier = 1.0;
        int extraTier = 0;
        float soundModfier = 1.0f;
        boolean redstonePowered = false;
        this.redstoneSensitive = this.defaultSensitive;
        for (int i = 0; i < 4; ++i) {
            ItemStack item = (ItemStack)this.inventory.get(i + this.inventory.size() - 4);
            if (!(item.func_77973_b() instanceof IMachineUpgradeItem)) continue;
            IMachineUpgradeItem upgrade = (IMachineUpgradeItem)item.func_77973_b();
            upgrade.onInstalling(item, (IMachine)this);
            extraProcessSpeed += upgrade.getExtraProcessSpeed(item, (IMachine)this) * item.func_190916_E();
            processingSpeedMultiplier *= Math.pow(upgrade.getProcessSpeedMultiplier(item, (IMachine)this), item.func_190916_E());
            extraProcessTime += upgrade.getExtraProcessTime(item, (IMachine)this) * item.func_190916_E();
            processTimeMultiplier *= Math.pow(upgrade.getProcessTimeMultiplier(item, (IMachine)this), item.func_190916_E());
            extraEnergyDemand += upgrade.getExtraEnergyDemand(item, (IMachine)this) * item.func_190916_E();
            energyDemandMultiplier *= Math.pow(upgrade.getEnergyDemandMultiplier(item, (IMachine)this), item.func_190916_E());
            extraEnergyStorage += upgrade.getExtraEnergyStorage(item, (IMachine)this) * item.func_190916_E();
            energyStorageMultiplier *= Math.pow(upgrade.getEnergyStorageMultiplier(item, (IMachine)this), item.func_190916_E());
            soundModfier = (float)((double)soundModfier * Math.pow(upgrade.getSoundVolumeMultiplier(item, (IMachine)this), item.func_190916_E()));
            extraTier += upgrade.getExtraTier(item, (IMachine)this) * item.func_190916_E();
            if (!upgrade.useRedstoneInverter(item, (IMachine)this)) continue;
            redstonePowered = true;
        }
        this.redstoneInverted = redstonePowered;
        this.progressPerTick = TileEntityBasicElectricMachine.applyFloatModifier((int)1, (int)extraProcessSpeed, (double)processingSpeedMultiplier);
        this.energyConsume = TileEntityBasicElectricMachine.applyModifier((int)this.defaultEnergyConsume, (int)extraEnergyDemand, (double)energyDemandMultiplier);
        this.operationLength = TileEntityBasicElectricMachine.applyModifier((int)this.defaultOperationLength, (int)extraProcessTime, (double)processTimeMultiplier);
        this.setMaxEnergy(TileEntityBasicElectricMachine.applyModifier((int)this.defaultEnergyStorage, (int)extraEnergyStorage, (double)energyStorageMultiplier));
        this.tier = this.baseTier + extraTier;
        if (this.tier > 13) {
            this.tier = 13;
        }
        this.maxInput = (int)EnergyNet.instance.getPowerFromTier(this.tier);
        if (this.energy > this.maxEnergy) {
            this.energy = this.maxEnergy;
        }
        this.soundLevel = soundModfier;
        if (this.progressPerTick < 0.01f) {
            this.progressPerTick = 0.01f;
        }
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
        if (this.energyConsume < 1) {
            this.energyConsume = 1;
        }
        if (this.lastRecipe == null || this.lastRecipe == FluidCanningRecipeList.INVALID_RECIPE) {
            this.applyRecipeEffect(null);
        } else {
            this.applyRecipeEffect(this.lastRecipe.getOutputs());
        }
        this.getNetwork().updateTileEntityField((TileEntity)this, "redstoneInverted");
        this.getNetwork().updateTileEntityField((TileEntity)this, "redstoneSensitive");
        this.getNetwork().updateTileEntityField((TileEntity)this, "soundLevel");
        this.getNetwork().updateTileGuiField((TileEntity)this, "maxInput");
        this.getNetwork().updateTileGuiField((TileEntity)this, "energy");
    }

    public boolean checkRecipe(FluidCanningRecipeList.FluidCanningRecipe entry) {
        if (entry.hasFluidInput() && !entry.matches((ItemStack)this.inventory.get(slotInput), this.inputTank.getFluid()) && this.inputTank.getFluidAmount() < entry.getInputFluid().amount) {
            return false;
        }
        return entry.matches((ItemStack)this.inventory.get(slotInput));
    }

    public abstract int[] getInputSlots();

    public abstract IFilter[] getInputFilters(int[] var1);

    public abstract boolean isRecipeSlot(int var1);

    public abstract int[] getOutputSlots();

    public abstract FluidCanningRecipeList getRecipeList();

    public boolean canWork() {
        if (!this.redstoneSensitive) {
            return true;
        }
        return this.isRedstonePowered();
    }

    public boolean supportsNotify() {
        return true;
    }

    public double getEnergy() {
        return this.energy;
    }

    public boolean useEnergy(double amount, boolean simulate) {
        if ((double)this.energy < amount) {
            return false;
        }
        if (!simulate) {
            this.useEnergy((int)amount);
        }
        return true;
    }

    public void setRedstoneSensitive(boolean active) {
        if (this.redstoneSensitive != active) {
            this.redstoneSensitive = active;
        }
    }

    public boolean isRedstoneSensitive() {
        return this.redstoneSensitive;
    }

    public boolean isRedstonePowered() {
        return this.redstoneInverted != super.isRedstonePowered();
    }

    public boolean isProcessing() {
        return this.getActive();
    }

    public boolean isValidInput(ItemStack par1) {
        return this.getRecipeList().isValidRecipeInput(par1);
    }

    public World getMachineWorld() {
        return this.func_145831_w();
    }

    public BlockPos getMachinePos() {
        return this.func_174877_v();
    }

    public int getEnergyUsage() {
        return this.recipeEnergy;
    }

    public float getProgress() {
        return this.progress;
    }

    public float getMaxProgress() {
        return this.recipeOperation;
    }

    public IHasInventory getOutputInventory() {
        return new RangedInventoryWrapper((IHasInventory)this, this.getOutputSlots());
    }

    public IHasInventory getInputInventory() {
        int[] input = this.getInputSlots();
        RangedInventoryWrapper result = new RangedInventoryWrapper((IHasInventory)this, input).addFilters(this.getInputFilters(input));
        return result;
    }

    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    public void onUnloaded() {
        if (this.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources((Object)this);
            this.audioSource.remove();
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    public ResourceLocation getStartSoundFile() {
        return Ic2Sounds.electricFurnaceLoop;
    }

    public ResourceLocation getInterruptSoundFile() {
        return Ic2Sounds.interruptingSound;
    }

    public void onNetworkEvent(int event) {
        if (this.audioSource != null && this.audioSource.isRemoved()) {
            this.audioSource = null;
        }
        if (this.audioSource == null && this.getStartSoundFile() != null) {
            this.audioSource = IC2.audioManager.createSource((Object)this, PositionSpec.Center, this.getStartSoundFile(), true, false, IC2.audioManager.defaultVolume * this.soundLevel);
        }
        if (event == 0) {
            if (this.audioSource != null) {
                this.audioSource.play();
            }
        } else if (event == 1) {
            if (this.audioSource != null) {
                this.audioSource.stop();
                if (this.getInterruptSoundFile() != null) {
                    IC2.audioManager.playOnce((Object)this, PositionSpec.Center, this.getInterruptSoundFile(), false, IC2.audioManager.defaultVolume * this.soundLevel);
                }
            }
        } else if (event == 2 && this.audioSource != null) {
            this.audioSource.stop();
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74762_e("progress");
        this.outputs.clear();
        NBTTagList list = nbt.func_150295_c("Results", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            IStackOutput output = IStackRegistry.INSTANCE.readNBT(list.func_150305_b(i));
            if (output == null) continue;
            this.outputs.add(output);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("progress", this.progress);
        NBTTagList list = new NBTTagList();
        for (IStackOutput item : this.outputs) {
            list.func_74742_a((NBTBase)IStackRegistry.INSTANCE.saveNBT(item));
        }
        nbt.func_74782_a("Results", (NBTBase)list);
        return nbt;
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    public boolean hasGui(EntityPlayer player) {
        return true;
    }
}

