/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.util.jei;

import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.core.platform.registry.Ic2Formatters;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import trinsdar.ic2c_extras.blocks.tileentity.TileEntityThermalCentrifuge;
import trinsdar.ic2c_extras.util.jei.JeiPlugin;
import trinsdar.ic2c_extras.util.references.Ic2cExtrasLang;

public class JeiThermalCentrifugeWrapper
extends BlankRecipeWrapper {
    IMachineRecipeList.RecipeEntry entry;

    public JeiThermalCentrifugeWrapper(IMachineRecipeList.RecipeEntry recipe) {
        this.entry = recipe;
    }

    public void getIngredients(IIngredients components) {
        components.setInputLists(ItemStack.class, Arrays.asList(this.entry.getInput().getInputs()));
        ArrayList<List<ItemStack>> outputs = new ArrayList<List<ItemStack>>();
        int count = 0;
        for (ItemStack stack : this.entry.getOutput().copy().getAllOutputs()) {
            outputs.add(Arrays.asList(stack));
            if (++count < 3) continue;
            break;
        }
        components.setOutputLists(ItemStack.class, outputs);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        FontRenderer font = minecraft.field_71466_p;
        font.func_78276_b(Ic2cExtrasLang.jeiHeat.getLocalizedFormatted(new Object[]{Ic2Formatters.bigFormat.format(TileEntityThermalCentrifuge.getRequiredHeat(this.entry.getOutput()))}), 44, 12, Color.gray.getRGB());
        font.func_78276_b("Ticks: " + JeiThermalCentrifugeWrapper.getEntryTicks(this.entry.getOutput()), 5, 60, Color.black.getRGB());
        font.func_78276_b("Seconds: " + (float)JeiThermalCentrifugeWrapper.getEntryTicks(this.entry.getOutput()) / 20.0f, 5, 70, Color.black.getRGB());
        font.func_78276_b("Cost: " + JeiThermalCentrifugeWrapper.getEntryTicks(this.entry.getOutput()) * 20 + " EU", 5, 80, Color.black.getRGB());
        if (JeiPlugin.debug) {
            font.func_78276_b("Recipe Id: " + this.entry.getRecipeID(), 5, 90, Color.black.getRGB());
        }
    }

    public static int getEntryTicks(MachineOutput output) {
        if (output == null || output.getMetadata() == null) {
            return 400;
        }
        return 400 + output.getMetadata().func_74762_e("RecipeTime");
    }
}

