/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting;

import com.google.common.collect.Iterables;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.RecipeRegistry;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.tiles.TileMachineController;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;

public class ActiveMachineRecipe {
    private final MachineRecipe recipe;
    private Map<ResourceLocation, NBTTagCompound> dataMap = new HashMap<ResourceLocation, NBTTagCompound>();
    private int tick = 0;

    public ActiveMachineRecipe(MachineRecipe recipe) {
        this.recipe = recipe;
    }

    public ActiveMachineRecipe(NBTTagCompound serialized) {
        this.recipe = RecipeRegistry.getRegistry().getRecipe(new ResourceLocation(serialized.func_74779_i("recipeName")));
        this.tick = serialized.func_74762_e("tick");
        if (serialized.func_150297_b("data", 9)) {
            NBTTagList listData = serialized.func_150295_c("data", 10);
            for (int i = 0; i < listData.func_74745_c(); ++i) {
                NBTTagCompound tag = listData.func_150305_b(i);
                String key = tag.func_74779_i("key");
                NBTTagCompound data = tag.func_74775_l("data");
                if (key.isEmpty()) continue;
                this.dataMap.put(new ResourceLocation(key), data);
            }
        }
    }

    public void reset() {
        this.tick = 0;
    }

    public MachineRecipe getRecipe() {
        return this.recipe;
    }

    @Nonnull
    public TileMachineController.CraftingStatus tick(TileMachineController ctrl, RecipeCraftingContext context) {
        if (this.isCompleted(ctrl, context)) {
            return TileMachineController.CraftingStatus.working();
        }
        RecipeCraftingContext.CraftingCheckResult check = context.ioTick(this.tick);
        if (!check.isFailure()) {
            ++this.tick;
            return TileMachineController.CraftingStatus.working();
        }
        this.tick = 0;
        return TileMachineController.CraftingStatus.failure((String)Iterables.getFirst(check.getUnlocalizedErrorMessages(), (Object)""));
    }

    public int getTick() {
        return this.tick;
    }

    @Nonnull
    public Map<ResourceLocation, NBTTagCompound> getData() {
        return this.dataMap;
    }

    @Nonnull
    public NBTTagCompound getOrCreateData(ResourceLocation key) {
        return this.dataMap.computeIfAbsent(key, k -> new NBTTagCompound());
    }

    public boolean isCompleted(TileMachineController controller, RecipeCraftingContext context) {
        int time = this.recipe.getRecipeTotalTickTime();
        time = Math.round(RecipeModifier.applyModifiers(context.getModifiers(RequirementTypesMM.REQUIREMENT_DURATION), RequirementTypesMM.REQUIREMENT_DURATION, null, time, false));
        return this.tick >= time;
    }

    public void start(RecipeCraftingContext context) {
        context.startCrafting();
    }

    public void complete(RecipeCraftingContext completionContext) {
        completionContext.finishCrafting();
    }

    public NBTTagCompound serialize() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("tick", this.tick);
        tag.func_74778_a("recipeName", this.recipe.getRegistryName().toString());
        NBTTagList listData = new NBTTagList();
        for (Map.Entry<ResourceLocation, NBTTagCompound> dataEntry : this.dataMap.entrySet()) {
            NBTTagCompound tagData = new NBTTagCompound();
            tagData.func_74778_a("key", dataEntry.getKey().toString());
            tagData.func_74782_a("data", (NBTBase)dataEntry.getValue());
        }
        tag.func_74782_a("data", (NBTBase)listData);
        return tag;
    }
}

