/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.CommonProxy;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.PreparedRecipe;
import hellfirepvp.modularmachinery.common.crafting.RecipeLoader;
import hellfirepvp.modularmachinery.common.crafting.adapter.RecipeAdapterAccessor;
import hellfirepvp.modularmachinery.common.data.DataLoadProfiler;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.ProgressManager;

public class RecipeRegistry {
    private static RecipeRegistry INSTANCE = new RecipeRegistry();
    private static Map<ResourceLocation, TreeMap<Integer, TreeSet<MachineRecipe>>> REGISTRY_RECIPE_BY_MACHINE = new HashMap<ResourceLocation, TreeMap<Integer, TreeSet<MachineRecipe>>>();
    private static Map<ResourceLocation, MachineRecipe> RECIPE_REGISTRY = new HashMap<ResourceLocation, MachineRecipe>();
    private List<PreparedRecipe> earlyRecipes = new LinkedList<PreparedRecipe>();

    private RecipeRegistry() {
    }

    public static RecipeRegistry getRegistry() {
        return INSTANCE;
    }

    @Nonnull
    public Iterable<MachineRecipe> getRecipesFor(DynamicMachine machine) {
        TreeMap<Integer, TreeSet<MachineRecipe>> recipes = REGISTRY_RECIPE_BY_MACHINE.get(machine.getRegistryName());
        if (recipes == null) {
            return Lists.newArrayList();
        }
        return Iterables.concat(recipes.values());
    }

    @Nullable
    public MachineRecipe getRecipe(ResourceLocation key) {
        return RECIPE_REGISTRY.get(key);
    }

    public void loadRecipeRegistry(@Nullable EntityPlayer player, boolean doRegister) {
        HashMap<ResourceLocation, MachineRecipe> sharedLoadRegistry = new HashMap<ResourceLocation, MachineRecipe>();
        Map<DynamicMachine, List<MachineRecipe>> recipes = this.loadRecipes(player, sharedLoadRegistry);
        if (doRegister) {
            this.registerRecipes(recipes);
        }
        recipes = this.loadAdapters(player, sharedLoadRegistry);
        if (doRegister) {
            this.registerRecipes(recipes);
        }
    }

    private Map<DynamicMachine, List<MachineRecipe>> loadRecipes(@Nullable EntityPlayer player, Map<ResourceLocation, MachineRecipe> sharedLoadRegistry) {
        ProgressManager.ProgressBar barRecipes = ProgressManager.push((String)"RecipeRegistry - Recipes", (int)3);
        barRecipes.step("Discovering Files");
        DataLoadProfiler profiler = new DataLoadProfiler();
        Map<RecipeLoader.FileType, List<File>> potentialRecipes = RecipeLoader.discoverDirectory(CommonProxy.dataHolder.getRecipeDirectory());
        barRecipes.step("Loading Recipes");
        List<MachineRecipe> recipes = RecipeLoader.loadRecipes(potentialRecipes.getOrDefault((Object)RecipeLoader.FileType.RECIPE, Lists.newArrayList()), this.earlyRecipes);
        DataLoadProfiler.StatusLine sl = profiler.createLine("Load-Phase: ");
        DataLoadProfiler.Status success = sl.appendStatus("%s recipes loaded");
        DataLoadProfiler.Status failed = sl.appendStatus("%s recipes failed");
        success.setCounter(recipes.size());
        Map<String, Exception> failures = RecipeLoader.captureFailedAttempts();
        failed.setCounter(failures.size());
        if (failures.size() > 0) {
            ModularMachinery.log.warn("Encountered " + failures.size() + " problems while loading recipes!");
            for (String fileName : failures.keySet()) {
                ModularMachinery.log.warn("Couldn't load recipe from file " + fileName);
                failures.get(fileName).printStackTrace();
            }
        }
        barRecipes.step("Validation");
        Map<DynamicMachine, List<MachineRecipe>> validRecipes = this.loadAndValidateRecipes(recipes, profiler, sharedLoadRegistry);
        profiler.printLines(player);
        ProgressManager.pop((ProgressManager.ProgressBar)barRecipes);
        return validRecipes;
    }

    private Map<DynamicMachine, List<MachineRecipe>> loadAdapters(@Nullable EntityPlayer player, Map<ResourceLocation, MachineRecipe> sharedLoadRegistry) {
        ProgressManager.ProgressBar barRecipes = ProgressManager.push((String)"RecipeRegistry - Adapters", (int)3);
        barRecipes.step("Discovering Adapter-Files");
        DataLoadProfiler profiler = new DataLoadProfiler();
        Map<RecipeLoader.FileType, List<File>> potentialRecipes = RecipeLoader.discoverDirectory(CommonProxy.dataHolder.getRecipeDirectory());
        barRecipes.step("Loading Adapters");
        List<MachineRecipe> recipes = RecipeLoader.loadAdapterRecipes(potentialRecipes.getOrDefault((Object)RecipeLoader.FileType.ADAPTER, Lists.newArrayList()));
        DataLoadProfiler.StatusLine sl = profiler.createLine("Load-Phase: ");
        DataLoadProfiler.Status success = sl.appendStatus("%s adapter-recipes loaded");
        DataLoadProfiler.Status failed = sl.appendStatus("%s adapter-recipes failed");
        success.setCounter(recipes.size());
        Map<String, Exception> failures = RecipeLoader.captureFailedAttempts();
        failed.setCounter(failures.size());
        if (failures.size() > 0) {
            ModularMachinery.log.warn("Encountered " + failures.size() + " problems while loading adapters!");
            for (String fileName : failures.keySet()) {
                ModularMachinery.log.warn("Couldn't load recipe from file " + fileName);
                failures.get(fileName).printStackTrace();
            }
        }
        barRecipes.step("Validation");
        Map<DynamicMachine, List<MachineRecipe>> validRecipes = this.loadAndValidateRecipes(recipes, profiler, sharedLoadRegistry);
        profiler.printLines(player);
        ProgressManager.pop((ProgressManager.ProgressBar)barRecipes);
        return validRecipes;
    }

    private Map<DynamicMachine, List<MachineRecipe>> loadAndValidateRecipes(List<MachineRecipe> recipes, DataLoadProfiler profiler, Map<ResourceLocation, MachineRecipe> sharedLoadRegistry) {
        DataLoadProfiler.StatusLine unknown = profiler.createLine("");
        DataLoadProfiler.Status unknownCounter = unknown.appendStatus("Unknown Machinery: %s");
        HashMap<DynamicMachine, Tuple> statusMap = new HashMap<DynamicMachine, Tuple>();
        HashMap<DynamicMachine, List<MachineRecipe>> out = new HashMap<DynamicMachine, List<MachineRecipe>>();
        for (MachineRecipe mr : recipes) {
            MachineRecipe other;
            DynamicMachine m = mr.getOwningMachine();
            if (m == null) {
                unknownCounter.incrementCounter();
                ModularMachinery.log.warn("MachineRecipe loaded for unknown machine: " + mr.getOwningMachineIdentifier() + " - responsible file: " + mr.getRecipeFilePath());
                continue;
            }
            Tuple status = (Tuple)statusMap.get(m);
            if (status == null) {
                DataLoadProfiler.StatusLine line = profiler.createLine(m.getRegistryName() + " (Recipes): ");
                status = new Tuple((Object)line.appendStatus("%s loaded"), (Object)line.appendStatus("%s failed"));
                statusMap.put(m, status);
            }
            DataLoadProfiler.Status loaded = (DataLoadProfiler.Status)status.func_76341_a();
            DataLoadProfiler.Status fail = (DataLoadProfiler.Status)status.func_76340_b();
            if (sharedLoadRegistry.containsKey(mr.getRegistryName()) && (other = sharedLoadRegistry.get(mr.getRegistryName())) != null) {
                ModularMachinery.log.warn("MachineRecipe with registryName " + mr.getRegistryName() + " already exists!");
                ModularMachinery.log.warn("Offending files: '" + mr.getRecipeFilePath() + "' and '" + other.getRecipeFilePath() + "' !");
                fail.incrementCounter();
                continue;
            }
            loaded.incrementCounter();
            sharedLoadRegistry.put(mr.getRegistryName(), mr);
            List recipeList = out.computeIfAbsent(mr.getOwningMachine(), r -> Lists.newArrayList());
            recipeList.add(mr);
        }
        return out;
    }

    public void registerRecipes(Map<DynamicMachine, List<MachineRecipe>> map) {
        for (DynamicMachine machine : map.keySet()) {
            List<MachineRecipe> recipes = map.get(machine);
            for (MachineRecipe recipe : recipes) {
                RECIPE_REGISTRY.put(recipe.getRegistryName(), recipe);
                Map recipeList = REGISTRY_RECIPE_BY_MACHINE.computeIfAbsent(machine.getRegistryName(), k -> new TreeMap());
                TreeSet recipeSet = recipeList.computeIfAbsent(recipe.getConfiguredPriority(), inte -> new TreeSet());
                recipeSet.add(recipe);
            }
        }
    }

    public void registerRecipeEarly(PreparedRecipe recipe) {
        this.earlyRecipes.add(recipe);
    }

    public void reloadAdapters() {
        for (RecipeAdapterAccessor accessor : RecipeLoader.recipeAdapters) {
            Map machineRecipeList = REGISTRY_RECIPE_BY_MACHINE.get(accessor.getOwningMachine());
            for (MachineRecipe cached : accessor.getCachedRecipes()) {
                TreeSet recipeTreeSet;
                RECIPE_REGISTRY.remove(cached.getRegistryName());
                if (machineRecipeList == null || (recipeTreeSet = (TreeSet)machineRecipeList.get(cached.getConfiguredPriority())) == null) continue;
                recipeTreeSet.remove(cached);
            }
        }
        for (RecipeAdapterAccessor accessor : RecipeLoader.recipeAdapters) {
            for (MachineRecipe recipe : accessor.loadRecipesForAdapter()) {
                RECIPE_REGISTRY.put(recipe.getRegistryName(), recipe);
                Map recipeList = REGISTRY_RECIPE_BY_MACHINE.computeIfAbsent(accessor.getOwningMachine(), k -> new TreeMap());
                TreeSet recipeSet = recipeList.computeIfAbsent(recipe.getConfiguredPriority(), inte -> new TreeSet());
                recipeSet.add(recipe);
            }
        }
    }

    public void clearLingeringRecipes() {
        this.earlyRecipes.clear();
    }
}

