/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.registry;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.adapter.RecipeAdapter;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementType;
import hellfirepvp.modularmachinery.common.crafting.tooltip.RequirementTip;
import hellfirepvp.modularmachinery.common.lib.RegistriesMM;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;

public class RegistryRegistries {
    private RegistryRegistries() {
    }

    public static void buildRegistries() {
        RegistryRegistries.makeRegistry(RegistriesMM.REQUIREMENT_TYPE_REGISTRY_NAME, RequirementType.class).create();
        RegistryRegistries.makeRegistry(RegistriesMM.COMPONENT_TYPE_REGISTRY_NAME, ComponentType.class).create();
        RegistryRegistries.makeRegistry(RegistriesMM.ADAPTER_REGISTRY_NAME, RecipeAdapter.class).create();
        RegistryRegistries.makeRegistry(RegistriesMM.REQUIREMENT_TIPS_REGISTRY_NAME, RequirementTip.class).create();
        RegistriesMM.ADAPTER_REGISTRY = RegistryManager.ACTIVE.getRegistry(RegistriesMM.ADAPTER_REGISTRY_NAME);
        RegistriesMM.COMPONENT_TYPE_REGISTRY = RegistryManager.ACTIVE.getRegistry(RegistriesMM.COMPONENT_TYPE_REGISTRY_NAME);
        RegistriesMM.REQUIREMENT_TYPE_REGISTRY = RegistryManager.ACTIVE.getRegistry(RegistriesMM.REQUIREMENT_TYPE_REGISTRY_NAME);
        RegistriesMM.REQUIREMENT_TIPS_REGISTRY = RegistryManager.ACTIVE.getRegistry(RegistriesMM.REQUIREMENT_TIPS_REGISTRY_NAME);
    }

    private static <T extends IForgeRegistryEntry<T>> RegistryBuilder<T> makeRegistry(ResourceLocation name, Class<T> type) {
        return new RegistryBuilder().setName(name).setType(type).setMaxID(Short.MAX_VALUE).disableSaving().allowModification();
    }
}

