/*
 * Decompiled with CFR 0.152.
 */
package techreborn;

import java.io.File;
import net.minecraft.block.BlockDispenser;
import net.minecraft.command.ICommand;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import reborncore.RebornCore;
import reborncore.api.recipe.RecipeHandler;
import reborncore.common.IModInfo;
import reborncore.common.multiblock.MultiblockEventHandler;
import reborncore.common.multiblock.MultiblockServerTickHandler;
import reborncore.common.network.RegisterPacketEvent;
import reborncore.common.util.LogHelper;
import reborncore.common.util.Torus;
import techreborn.api.TechRebornAPI;
import techreborn.blocks.cable.EnumCableType;
import techreborn.client.GuiHandler;
import techreborn.command.TechRebornDevCommand;
import techreborn.compat.CompatManager;
import techreborn.compat.ICompatModule;
import techreborn.config.ConfigTechReborn;
import techreborn.dispenser.BehaviorDispenseScrapbox;
import techreborn.entities.EntityNukePrimed;
import techreborn.events.BlockBreakHandler;
import techreborn.events.TRRecipeHandler;
import techreborn.events.TRTickHandler;
import techreborn.init.ModBlocks;
import techreborn.init.ModFluids;
import techreborn.init.ModItems;
import techreborn.init.ModLoot;
import techreborn.init.ModRecipes;
import techreborn.init.ModSounds;
import techreborn.init.ModTileEntities;
import techreborn.init.OreDict;
import techreborn.init.SubItemRetriever;
import techreborn.lib.ModInfo;
import techreborn.packets.PacketAesu;
import techreborn.packets.PacketAutoCraftingTableLock;
import techreborn.packets.PacketFusionControlSize;
import techreborn.packets.PacketIdsu;
import techreborn.packets.PacketRedstoneMode;
import techreborn.packets.PacketRefund;
import techreborn.packets.PacketRollingMachineLock;
import techreborn.proxies.CommonProxy;
import techreborn.tiles.fusionReactor.TileFusionControlComputer;
import techreborn.utils.StackWIPHandler;
import techreborn.world.OilLakeGenerator;
import techreborn.world.TechRebornWorldGen;
import techreborn.world.village.ModLootTables;
import techreborn.world.village.VillageComponentRubberPlantaion;
import techreborn.world.village.VillagePlantaionHandler;

@Mod(modid="techreborn", name="Tech Reborn", version="2.24.1.1017", dependencies="required-after:forge@[14.23.3.2694,);required-after:reborncore@[3.15.5,);after:jei@[4.12,);after:ic2;required-before:techreborn_compat", acceptedMinecraftVersions="[1.12,1.12.2]", certificateFingerprint="8727a3141c8ec7f173b87aa78b9b9807867c4e6b", guiFactory="techreborn.client.TechRebornGuiFactory")
public class Core {
    public static final boolean DEV_FEATURES = Boolean.parseBoolean(System.getProperty("techreborn.devFeatues", "false"));
    @SidedProxy(clientSide="techreborn.proxies.ClientProxy", serverSide="techreborn.proxies.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance
    public static Core INSTANCE;
    public static LogHelper logHelper;
    public static TechRebornWorldGen worldGen;
    public static File configDir;

    public Core() {
        FluidRegistry.enableUniversalBucket();
        MinecraftForge.EVENT_BUS.register(EnumCableType.class);
    }

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) throws IllegalAccessException, InstantiationException {
        event.getModMetadata().version = "2.24.1.1017";
        INSTANCE = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
        configDir = new File(new File(event.getModConfigurationDirectory(), "teamreborn"), "techreborn");
        worldGen = new TechRebornWorldGen();
        Core.worldGen.configFile = new File(configDir, "ores.json");
        CommonProxy.isChiselAround = Loader.isModLoaded((String)"ctm");
        TechRebornAPI.subItemRetriever = new SubItemRetriever();
        ModBlocks.init();
        ModTileEntities.init();
        ModFluids.init();
        ModItems.init();
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("techreborn", "nuke"), EntityNukePrimed.class, (String)"nuke", (int)0, (Object)INSTANCE, (int)160, (int)5, (boolean)true);
        ModFixs dataFixes = FMLCommonHandler.instance().getDataFixer().init("techreborn", 1);
        ModTileEntities.initDataFixer(dataFixes);
        CompatManager.INSTANCE.compatModules.forEach(compatModule -> compatModule.preInit(event));
        OreDict.init();
        proxy.preInit(event);
        logHelper.info((Object)"PreInitialization Complete");
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ModRecipes.init();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModLoot.init();
        MinecraftForge.EVENT_BUS.register((Object)new ModLoot());
        ModSounds.init();
        CompatManager.INSTANCE.compatModules.forEach(compatModule -> compatModule.init(event));
        proxy.init(event);
        worldGen.load();
        GameRegistry.registerWorldGenerator((IWorldGenerator)worldGen, (int)0);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OilLakeGenerator(), (int)0);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)new GuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new StackWIPHandler());
        MinecraftForge.EVENT_BUS.register((Object)new BlockBreakHandler());
        MinecraftForge.EVENT_BUS.register((Object)new TRRecipeHandler());
        MinecraftForge.EVENT_BUS.register((Object)new MultiblockEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new MultiblockServerTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)new TRTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)Core.worldGen.retroGen);
        if (ConfigTechReborn.enableRubberTreePlantation) {
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillagePlantaionHandler());
            MapGenStructureIO.func_143031_a(VillageComponentRubberPlantaion.class, (String)new ResourceLocation("techreborn", "rubberplantation").toString());
            ModLootTables.CHESTS_RUBBER_PLANTATION.toString();
        }
        if (BehaviorDispenseScrapbox.dispenseScrapboxes) {
            BlockDispenser.field_149943_a.func_82595_a((Object)ModItems.SCRAP_BOX, (Object)new BehaviorDispenseScrapbox());
        }
        Torus.genSizeMap((int)TileFusionControlComputer.maxCoilSize);
        logHelper.info((Object)"Initialization Complete");
    }

    @Mod.EventHandler
    public void postinit(FMLPostInitializationEvent event) throws Exception {
        CompatManager.INSTANCE.compatModules.forEach(compatModule -> compatModule.postInit(event));
        proxy.postInit(event);
        ModRecipes.postInit();
        logHelper.info((Object)(RecipeHandler.recipeList.size() + " recipes loaded"));
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new TechRebornDevCommand());
        for (ICompatModule compatModule : CompatManager.INSTANCE.compatModules) {
            compatModule.serverStarting(event);
        }
    }

    @SubscribeEvent
    public void LoadPackets(RegisterPacketEvent event) {
        event.registerPacket(PacketAesu.class, Side.SERVER);
        event.registerPacket(PacketIdsu.class, Side.SERVER);
        event.registerPacket(PacketRollingMachineLock.class, Side.SERVER);
        event.registerPacket(PacketFusionControlSize.class, Side.SERVER);
        event.registerPacket(PacketAutoCraftingTableLock.class, Side.SERVER);
        event.registerPacket(PacketRefund.class, Side.SERVER);
        event.registerPacket(PacketRedstoneMode.class, Side.SERVER);
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        logHelper.warn((Object)"Invalid fingerprint detected for TechReborn!");
        RebornCore.proxy.invalidFingerprints.add("Invalid fingerprint detected for TechReborn!");
    }

    static {
        logHelper = new LogHelper((IModInfo)new ModInfo());
    }
}

