/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.tier1;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.IToolDrop;
import reborncore.api.praescriptum.ingredients.output.ItemStackOutputIngredient;
import reborncore.api.praescriptum.recipes.Recipe;
import reborncore.api.praescriptum.recipes.RecipeHandler;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;

public abstract class TileMachine
extends TilePowerAcceptor
implements IToolDrop,
IInventoryProvider,
IContainerProvider {
    public final String name;
    public final int maxInput;
    public final int maxEnergy;
    public final Inventory inventory;
    public final RecipeHandler recipeHandler;
    protected final int energySlot;
    protected final int[] inputSlots;
    protected final int[] outputSlots;
    protected int progress = 0;
    protected int operationLength = 0;
    protected Recipe recipe = null;
    protected boolean isActive = false;

    public TileMachine(String name, int maxInput, int maxEnergy, int energySlot, int slots, RecipeHandler recipeHandler) {
        this(name, maxInput, maxEnergy, energySlot, slots, 64, recipeHandler);
    }

    public TileMachine(String name, int maxInput, int maxEnergy, int energySlot, int slots, int slotSize, RecipeHandler recipeHandler) {
        this(name, maxInput, maxEnergy, energySlot, slots, 64, new int[]{0}, new int[]{1}, recipeHandler);
    }

    public TileMachine(String name, int maxInput, int maxEnergy, int energySlot, int slots, int slotSize, int[] inputSlots, int[] outputSlots, RecipeHandler recipeHandler) {
        this.name = "Tile" + name;
        this.maxInput = maxInput;
        this.maxEnergy = maxEnergy;
        this.energySlot = energySlot;
        this.inventory = new Inventory(slots, name, slotSize, (TileEntity)this);
        this.inputSlots = inputSlots;
        this.outputSlots = outputSlots;
        this.recipeHandler = recipeHandler;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound data = tag.func_74775_l("TileMachine");
        this.progress = data.func_74764_b("progress") ? data.func_74762_e("progress") : 0;
        this.isActive = data.func_74764_b("isActive") && data.func_74767_n("isActive");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("progress", this.progress);
        data.func_74757_a("isActive", this.isActive);
        tag.func_74782_a("TileMachine", (NBTBase)data);
        return tag;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.charge(this.energySlot);
        boolean needsInventoryUpdate = false;
        if (this.canWork()) {
            int progressNeeded;
            if (!this.isActive) {
                this.isActive = true;
                this.setActive(true);
            }
            if (this.progress == 0) {
                needsInventoryUpdate = true;
            }
            if (this.progress < (progressNeeded = Math.max((int)((double)this.recipe.getOperationDuration() * (1.0 - this.getSpeedMultiplier())), 1))) {
                this.useEnergy(this.getEuPerTick(this.recipe.getEnergyCostPerTick()));
                ++this.progress;
            }
            if (this.progress >= progressNeeded) {
                this.finishWork();
                needsInventoryUpdate = true;
            }
        } else if (this.isActive) {
            this.isActive = false;
            this.setActive(false);
        }
        if (needsInventoryUpdate) {
            super.func_70296_d();
        }
    }

    public double getBaseMaxPower() {
        return this.maxEnergy;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return this.maxInput;
    }

    protected boolean canWork() {
        Optional maybeRecipe;
        boolean canUse;
        ImmutableList inputs = (ImmutableList)Arrays.stream(this.inputSlots).mapToObj(arg_0 -> ((Inventory)this.inventory).func_70301_a(arg_0)).filter(contents -> !contents.func_190926_b()).collect(ImmutableList.toImmutableList());
        if (inputs.isEmpty()) {
            return false;
        }
        if (this.recipe != null && !(canUse = this.recipeHandler.apply(this.recipe, inputs, ImmutableList.of(), true))) {
            this.reset();
        }
        if ((maybeRecipe = Optional.ofNullable(this.recipe)).isPresent()) {
            if (!this.canUseEnergy(this.getEuPerTick(this.recipe.getEnergyCostPerTick()))) {
                return false;
            }
            return this.recipe.getOutputIngredients().stream().filter(output -> output instanceof ItemStackOutputIngredient).map(output -> (ItemStack)output.ingredient).allMatch(output -> this.addToOutputs(output.func_77946_l(), true) == output.func_190916_E());
        }
        maybeRecipe = this.recipeHandler.findRecipe(inputs, ImmutableList.of());
        if (!maybeRecipe.isPresent()) {
            return false;
        }
        this.updateRecipe((Recipe)maybeRecipe.get());
        if (!this.canUseEnergy(this.getEuPerTick(this.recipe.getEnergyCostPerTick()))) {
            return false;
        }
        return this.recipe.getOutputIngredients().stream().filter(output -> output instanceof ItemStackOutputIngredient).map(output -> (ItemStack)output.ingredient).allMatch(output -> this.addToOutputs(output.func_77946_l(), true) == output.func_190916_E());
    }

    protected void finishWork() {
        ImmutableList inputs = (ImmutableList)Arrays.stream(this.inputSlots).mapToObj(arg_0 -> ((Inventory)this.inventory).func_70301_a(arg_0)).filter(contents -> !contents.func_190926_b()).collect(ImmutableList.toImmutableList());
        if (inputs.isEmpty()) {
            return;
        }
        this.recipeHandler.apply(this.recipe, inputs, ImmutableList.of(), false);
        this.recipe.getOutputIngredients().stream().filter(entry -> entry instanceof ItemStackOutputIngredient).map(output -> (ItemStack)output.ingredient).forEach(output -> this.addToOutputs(output.func_77946_l(), false));
        this.progress = 0;
    }

    protected void updateRecipe(Recipe recipe) {
        this.operationLength = recipe.getOperationDuration();
        this.recipe = recipe;
    }

    protected void reset() {
        this.progress = 0;
        this.operationLength = 0;
        this.recipe = null;
    }

    protected void setActive(boolean value) {
        Block block = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        if (block instanceof BlockMachineBase) {
            ((BlockMachineBase)block).setActive(Boolean.valueOf(value), this.field_145850_b, this.field_174879_c);
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getOperationLength() {
        return this.operationLength;
    }

    public void setOperationLength(int operationLength) {
        this.operationLength = operationLength;
    }

    public int getProgressScaled(int scale) {
        return this.progress == 0 || this.operationLength == 0 ? 0 : this.progress * scale / this.operationLength;
    }

    public int addToOutputs(ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return 0;
        }
        int remaining = stack.func_190916_E();
        for (int index : this.outputSlots) {
            if (remaining <= 0) break;
            ItemStack contents = this.inventory.func_70301_a(index);
            int transfered = Math.min(remaining, Math.min(this.inventory.func_70297_j_(), stack.func_77976_d()) - contents.func_190916_E());
            if (!contents.func_190926_b() && ItemUtils.isItemEqual((ItemStack)contents, (ItemStack)stack, (boolean)true, (boolean)true)) {
                if (!simulate) {
                    this.inventory.func_70299_a(index, ItemUtils.increaseSize((ItemStack)contents, (int)transfered));
                }
                remaining -= transfered;
                continue;
            }
            if (!contents.func_190926_b()) continue;
            if (!simulate) {
                ItemStack temp = ItemUtils.setSize((ItemStack)stack.func_77946_l(), (int)transfered);
                this.inventory.func_70299_a(index, temp);
            }
            remaining -= transfered;
        }
        return stack.func_190916_E() - remaining;
    }
}

