/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.tier1;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import reborncore.api.IToolDrop;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.FluidUtils;
import reborncore.common.util.Inventory;
import reborncore.common.util.Tank;

@RebornRegistry(modID="techreborn")
public class TilePump
extends TilePowerAcceptor
implements IToolDrop,
IInventoryProvider,
IContainerProvider {
    @ConfigRegistry(config="machines", category="pump", key="PumpInput", comment="Pump max input (Value in EU)")
    public static int maxInput = 32;
    @ConfigRegistry(config="machines", category="pump", key="PumpMaxEnergy", comment="Pump max energy (Value in EU)")
    public static int maxEnergy = 1000;
    @ConfigRegistry(config="machines", category="pump", key="PumpEUCost", comment="Pump cost for one block of fluid (Value in EU)")
    public static int pumpExtractEU = 20;
    public static final int TANK_CAPACITY = 8000;
    public final Inventory inventory = new Inventory(3, "TilePump", 64, (TileEntity)this);
    public final Tank tank = new Tank("TilePump", 8000, (TileLegacyMachineBase)this);

    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            if (FluidUtils.fillContainers((IFluidHandler)this.tank, (IInventory)this.inventory, (int)0, (int)1, (Fluid)this.tank.getFluidType())) {
                this.syncWithAll();
                this.tank.compareAndUpdate();
            }
            if (!this.tank.isFull() && this.tank.getCapacity() - this.tank.getFluidAmount() >= 1000 && this.canUseEnergy(pumpExtractEU)) {
                this.useEnergy(pumpExtractEU);
                this.tank.compareAndUpdate();
            }
        }
    }

    public void addInfo(List<String> info, boolean isRealTile) {
        super.addInfo(info, isRealTile);
        info.add(TextFormatting.LIGHT_PURPLE + "Eu per extract " + TextFormatting.GREEN + PowerSystem.getLocaliszedPower((int)pumpExtractEU));
        info.add(TextFormatting.LIGHT_PURPLE + "Speed: " + TextFormatting.GREEN + "1000mb/5 sec");
    }

    public static FluidStack drainBlock(World world, BlockPos pos, boolean doDrain) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
        if (fluid != null && FluidRegistry.isFluidRegistered((Fluid)fluid)) {
            if (block instanceof IFluidBlock) {
                IFluidBlock fluidBlock = (IFluidBlock)block;
                if (!fluidBlock.canDrain(world, pos)) {
                    return null;
                }
                return fluidBlock.drain(world, pos, doDrain);
            }
            int level = (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b);
            if (level != 0) {
                return null;
            }
            if (doDrain) {
                world.func_175698_g(pos);
            }
            return new FluidStack(fluid, 1000);
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.tank.readFromNBT(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.tank.writeToNBT(tagCompound);
        return tagCompound;
    }

    public double getBaseMaxPower() {
        return maxEnergy;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return maxInput;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        if (slotIndex == 1) {
            return itemStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        }
        return super.func_94041_b(slotIndex, itemStack);
    }

    public ItemStack getToolDrop(EntityPlayer entityPlayer) {
        return ItemStack.field_190927_a;
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("pump").player(player.field_71071_by).inventory().hotbar().addInventory().tile((IInventory)this).fluidSlot(0, 124, 35).outputSlot(1, 124, 55).energySlot(2, 8, 72).syncEnergyValue().addInventory().create((TileLegacyMachineBase)this);
    }

    @Nullable
    public Tank getTank() {
        return this.tank;
    }
}

