/*
 * Decompiled with CFR 0.152.
 */
package nc.render;

import nc.NuclearCraft;
import nc.render.BlockHighlightTracker;
import nc.util.NCMath;
import nc.util.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BlockHighlightHandler {
    private static BlockHighlightTracker getOverlayTracker() {
        return NuclearCraft.instance.blockOverlayTracker;
    }

    @SubscribeEvent
    public void highlightBlock(RenderWorldLastEvent event) {
        BlockPos pos = BlockHighlightHandler.getOverlayTracker().getHighlightPos();
        if (pos == null) {
            return;
        }
        long time = System.currentTimeMillis();
        if (time > BlockHighlightHandler.getOverlayTracker().getHighlightExpireTimeMillis()) {
            BlockHighlightHandler.getOverlayTracker().highlightBlock(null, -1L);
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double relativeX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
        double relativeY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
        double relativeZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
        float r = (float)NCMath.trapezoidalWave((double)time * 0.18, 0.0);
        float g = (float)NCMath.trapezoidalWave((double)time * 0.18, 120.0);
        float b = (float)NCMath.trapezoidalWave((double)time * 0.18, 240.0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179124_c((float)r, (float)g, (float)b);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179137_b((double)(-relativeX), (double)(-relativeY), (double)(-relativeZ));
        GlStateManager.func_179097_i();
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        float x = pos.func_177958_n();
        float y = pos.func_177956_o();
        float z = pos.func_177952_p();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        RenderHelper.renderBlockOutline(buffer, x, y, z, r, g, b, 1.0f);
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
    }
}

