/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.modules.playerstate;

import com.infinityraider.infinitylib.modules.playerstate.State;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.ThrowableImpactEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerStateHandler {
    private static final PlayerStateHandler INSTANCE = new PlayerStateHandler();
    private final HashMap<UUID, State> states = new HashMap();

    public static PlayerStateHandler getInstance() {
        return INSTANCE;
    }

    private PlayerStateHandler() {
    }

    State getState(EntityPlayer player) {
        if (!this.states.containsKey(player.func_110124_au())) {
            this.states.put(player.func_110124_au(), new State(player));
        }
        return this.states.get(player.func_110124_au());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityImpactEvent(ThrowableImpactEvent event) {
        EntityPlayer player;
        if (event.getRayTraceResult().field_72308_g instanceof EntityPlayer && this.getState(player = (EntityPlayer)event.getRayTraceResult().field_72308_g).isEthereal()) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityHurtEvent(LivingHurtEvent event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && this.getState(player = (EntityPlayer)event.getEntityLiving()).isInvulnerable()) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @SideOnly(value=Side.CLIENT)
    public void onPlayerRenderPreEvent(RenderPlayerEvent.Pre event) {
        this.cancelRenderEvent((RenderPlayerEvent)event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @SideOnly(value=Side.CLIENT)
    public void onPlayerRenderPostEvent(RenderPlayerEvent.Post event) {
        this.cancelRenderEvent((RenderPlayerEvent)event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @SideOnly(value=Side.CLIENT)
    public void onPlayerRenderEvent(RenderPlayerEvent.Specials.Pre event) {
        this.cancelRenderEvent((RenderPlayerEvent)event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @SideOnly(value=Side.CLIENT)
    public void onPlayerRenderEvent(RenderPlayerEvent.Specials.Post event) {
        this.cancelRenderEvent((RenderPlayerEvent)event);
    }

    @SideOnly(value=Side.CLIENT)
    private void cancelRenderEvent(RenderPlayerEvent event) {
        if (this.getState(event.getEntityPlayer()).isInvisible()) {
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onEntityTargetingEvent(LivingSetAttackTargetEvent event) {
        EntityLivingBase target = event.getTarget();
        EntityLivingBase attacker = event.getEntityLiving();
        if (target == null || attacker == null || !(target instanceof EntityPlayer) || !(attacker instanceof EntityLiving)) {
            return;
        }
        if (this.getState((EntityPlayer)target).isUndetectable()) {
            ((EntityLiving)attacker).func_70624_b(null);
        }
    }
}

