/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.crafttweaker;

import com.blakebr0.extendedcrafting.crafting.CombinationRecipe;
import com.blakebr0.extendedcrafting.crafting.CombinationRecipeManager;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.extendedcrafting.CombinationCrafting")
public class CombinationCrafting {
    @ZenMethod
    public static void addRecipe(IItemStack output, int cost, IItemStack input, IIngredient[] ingredients) {
        CraftTweakerAPI.apply((IAction)new Add(new CombinationRecipe(CombinationCrafting.toStack(output), cost, CombinationCrafting.toStack(input), CombinationCrafting.toObjects(ingredients))));
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, int cost, int perTick, IItemStack input, IIngredient[] ingredients) {
        CraftTweakerAPI.apply((IAction)new Add(new CombinationRecipe(CombinationCrafting.toStack(output), cost, perTick, CombinationCrafting.toStack(input), CombinationCrafting.toObjects(ingredients))));
    }

    @ZenMethod
    public static void remove(IItemStack target) {
        CraftTweakerAPI.apply((IAction)new Remove(CombinationCrafting.toStack(target)));
    }

    private static ItemStack toStack(IItemStack item) {
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        Object internal = item.getInternal();
        if (internal == null || !(internal instanceof ItemStack)) {
            CraftTweakerAPI.getLogger().logError("Not a valid item stack: " + item);
        }
        return (ItemStack)internal;
    }

    private static Object toObject(IIngredient ingredient) {
        if (ingredient == null) {
            return null;
        }
        if (ingredient instanceof IOreDictEntry) {
            return CombinationCrafting.toString((IOreDictEntry)ingredient);
        }
        if (ingredient instanceof IItemStack) {
            return CombinationCrafting.toStack((IItemStack)ingredient);
        }
        return null;
    }

    private static Object[] toObjects(IIngredient[] list) {
        if (list == null) {
            return null;
        }
        Object[] ingredients = new Object[list.length];
        for (int x = 0; x < list.length; ++x) {
            ingredients[x] = CombinationCrafting.toActualObject(list[x]);
        }
        return ingredients;
    }

    private static List toList(IIngredient[] list) {
        return Arrays.asList(CombinationCrafting.toObjects(list));
    }

    private static Object toActualObject(IIngredient ingredient) {
        if (ingredient == null) {
            return null;
        }
        if (ingredient instanceof IOreDictEntry) {
            return CombinationCrafting.toString((IOreDictEntry)ingredient);
        }
        if (ingredient instanceof IItemStack) {
            return CombinationCrafting.toStack((IItemStack)ingredient);
        }
        return null;
    }

    private static String toString(IOreDictEntry entry) {
        return entry.getName();
    }

    private static class Remove
    implements IAction {
        ItemStack remove;

        public Remove(ItemStack remove) {
            this.remove = remove;
        }

        public void apply() {
            CombinationRecipeManager.getInstance().removeRecipes(this.remove);
        }

        public String describe() {
            return "Removing all Combination Crafting recipes for " + this.remove.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        CombinationRecipe recipe;

        public Add(CombinationRecipe add) {
            this.recipe = add;
        }

        public void apply() {
            CombinationRecipeManager.getInstance().getRecipes().add(this.recipe);
        }

        public String describe() {
            return "Adding a Combination Crafting recipe for " + this.recipe.getOutput().func_82833_r();
        }
    }
}

