/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.crafttweaker;

import com.blakebr0.extendedcrafting.crafting.table.TableRecipeManager;
import com.blakebr0.extendedcrafting.crafting.table.TableRecipeShaped;
import com.blakebr0.extendedcrafting.crafting.table.TableRecipeShapeless;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.CraftingHelper;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.extendedcrafting.TableCrafting")
public class TableCrafting {
    @ZenMethod
    public static void addShaped(IItemStack output, IIngredient[][] ingredients) {
        TableCrafting.addShaped(0, output, ingredients);
    }

    @ZenMethod
    public static void addShaped(int tier, IItemStack output, IIngredient[][] ingredients) {
        if (tier > 4 || tier < 0) {
            CraftTweakerAPI.getLogger().logError("Unable to assign a tier to the Table Recipe for stack " + output.getDisplayName() + ". Tier cannot be greater than 4 or less than 0.");
            tier = 0;
        }
        int height = ingredients.length;
        int width = 0;
        for (IIngredient[] row : ingredients) {
            if (width >= row.length) continue;
            width = row.length;
        }
        NonNullList input = NonNullList.func_191197_a((int)(height * width), (Object)Ingredient.field_193370_a);
        int i = 0;
        for (int a = 0; a < height; ++a) {
            for (int b = 0; b < ingredients[a].length; ++b) {
                Ingredient ing = CraftingHelper.getIngredient((Object)TableCrafting.toObject(ingredients[a][b]));
                if (ing == null) {
                    ing = Ingredient.field_193370_a;
                }
                i = a * width + b;
                input.set(i, (Object)ing);
            }
        }
        CraftTweakerAPI.apply((IAction)new Add(new TableRecipeShaped(tier, TableCrafting.toStack(output), width, height, (NonNullList<Ingredient>)input)));
    }

    @ZenMethod
    public static void addShapedMirrored(IItemStack output, IIngredient[][] ingredients) {
        TableCrafting.addShapedMirrored(0, output, ingredients);
    }

    @ZenMethod
    public static void addShapedMirrored(int tier, IItemStack output, IIngredient[][] ingredients) {
        if (tier > 4 || tier < 0) {
            CraftTweakerAPI.getLogger().logError("Unable to assign a tier to the Table Recipe for stack " + output.getDisplayName() + ". Tier cannot be greater than 4 or less than 0.");
            tier = 0;
        }
        int height = ingredients.length;
        int width = 0;
        for (IIngredient[] row : ingredients) {
            if (width >= row.length) continue;
            width = row.length;
        }
        NonNullList input = NonNullList.func_191197_a((int)(height * width), (Object)Ingredient.field_193370_a);
        int i = 0;
        for (int a = 0; a < height; ++a) {
            for (int b = 0; b < ingredients[a].length; ++b) {
                Ingredient ing = CraftingHelper.getIngredient((Object)TableCrafting.toObject(ingredients[a][b]));
                if (ing == null) {
                    ing = Ingredient.field_193370_a;
                }
                i = a * width + b;
                input.set(i, (Object)ing);
            }
        }
        CraftTweakerAPI.apply((IAction)new Add(new TableRecipeShaped(tier, TableCrafting.toStack(output), width, height, (NonNullList<Ingredient>)input).setMirrored(true)));
    }

    @ZenMethod
    public static void addShapeless(IItemStack output, IIngredient[] ingredients) {
        TableCrafting.addShapeless(0, output, ingredients);
    }

    @ZenMethod
    public static void addShapeless(int tier, IItemStack output, IIngredient[] ingredients) {
        if (tier > 4 || tier < 0) {
            CraftTweakerAPI.getLogger().logError("Unable to assign a tier to the Table Recipe for stack " + output.getDisplayName() + ". Tier cannot be greater than 4 or less than 0.");
            tier = 0;
        }
        CraftTweakerAPI.apply((IAction)new Add(new TableRecipeShapeless(tier, TableCrafting.toStack(output), TableCrafting.toObjects(ingredients))));
    }

    @ZenMethod
    public static void remove(IItemStack target) {
        CraftTweakerAPI.apply((IAction)new Remove(TableCrafting.toStack(target)));
    }

    private static ItemStack toStack(IItemStack item) {
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        Object internal = item.getInternal();
        if (internal == null || !(internal instanceof ItemStack)) {
            CraftTweakerAPI.getLogger().logError("Not a valid item stack: " + item);
        }
        return (ItemStack)internal;
    }

    private static Object toObject(IIngredient ingredient) {
        if (ingredient == null) {
            return null;
        }
        if (ingredient instanceof IOreDictEntry) {
            return TableCrafting.toString((IOreDictEntry)ingredient);
        }
        if (ingredient instanceof IItemStack) {
            return TableCrafting.toStack((IItemStack)ingredient);
        }
        return null;
    }

    private static Object[] toObjects(IIngredient[] list) {
        if (list == null) {
            return null;
        }
        Object[] ingredients = new Object[list.length];
        for (int x = 0; x < list.length; ++x) {
            ingredients[x] = TableCrafting.toObject(list[x]);
        }
        return ingredients;
    }

    private static List toList(IIngredient[] list) {
        return Arrays.asList(TableCrafting.toObjects(list));
    }

    private static String toString(IOreDictEntry entry) {
        return entry.getName();
    }

    private static class Remove
    implements IAction {
        ItemStack remove;

        public Remove(ItemStack remove) {
            this.remove = remove;
        }

        public void apply() {
            TableRecipeManager.getInstance().removeRecipes(this.remove);
        }

        public String describe() {
            return "Removing all Table Crafting recipes for " + this.remove.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        IRecipe recipe;

        public Add(IRecipe add) {
            this.recipe = add;
        }

        public void apply() {
            TableRecipeManager.getInstance().getRecipes().add(this.recipe);
        }

        public String describe() {
            return "Adding a Table Crafting recipe for " + this.recipe.func_77571_b().func_82833_r();
        }
    }
}

