/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.blast;

import com.builtbroken.jlib.data.vector.IPos3D;
import icbm.classic.content.entity.EntityFlyingBlock;
import icbm.classic.content.entity.EntityLightBeam;
import icbm.classic.content.explosive.blast.Blast;
import icbm.classic.content.explosive.thread.ThreadLargeExplosion;
import icbm.classic.lib.transform.vector.Location;
import icbm.classic.lib.transform.vector.Pos;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlastBeam
extends Blast {
    protected Set<EntityFlyingBlock> feiBlocks = new HashSet<EntityFlyingBlock>();
    protected EntityLightBeam lightBeam;
    protected float red;
    protected float green;
    protected float blue;
    protected int radius = 5;

    public BlastBeam(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    @Override
    public void doPreExplode() {
        if (!this.world().field_72995_K) {
            this.world().func_72876_a(this.field_77283_e, this.location.x(), this.location.y(), this.location.z(), 4.0f, true);
            this.lightBeam = new EntityLightBeam(this.world(), this.location, 400, this.red, this.green, this.blue);
            this.world().func_72838_d((Entity)this.lightBeam);
            this.createAndStartThread(new ThreadLargeExplosion(this, (int)this.getBlastRadius(), 50.0f, this.field_77283_e));
        }
    }

    @Override
    public void doExplode() {
        if (!this.world().field_72995_K) {
            if (this.callCount > 100 / this.proceduralInterval() && this.isThreadCompleted()) {
                this.controller.endExplosion();
            }
            if (this.canFocusBeam(this.world(), this.location)) {
                int r = this.radius;
                for (int x = -r; x < r; ++x) {
                    for (int y = -r; y < r; ++y) {
                        for (int z = -r; z < r; ++z) {
                            BlockPos blockPos;
                            IBlockState state;
                            Block block;
                            double dist = MathHelper.func_76129_c((float)(x * x + y * y + z * z));
                            if (dist > (double)r || dist < (double)(r - 3) || (block = (state = this.field_77287_j.func_180495_p(blockPos = new BlockPos(this.location.x() + (double)x, this.location.y() + (double)y, this.location.z() + (double)z))).func_177230_c()) == null || block.isAir(state, (IBlockAccess)this.field_77287_j, blockPos) || state.func_185887_b(this.field_77287_j, blockPos) < 0.0f || this.world().field_73012_v.nextInt(2) <= 0) continue;
                            this.field_77287_j.func_175698_g(blockPos);
                            EntityFlyingBlock entity = new EntityFlyingBlock(this.world(), blockPos, state);
                            this.world().func_72838_d((Entity)entity);
                            this.feiBlocks.add(entity);
                            entity.pitchChange = 50.0f * this.world().field_73012_v.nextFloat();
                        }
                    }
                }
            } else {
                this.controller.endExplosion();
            }
            for (EntityFlyingBlock entity : this.feiBlocks) {
                Pos entityPosition = new Pos(entity);
                Pos centeredPosition = (Pos)entityPosition.add((IPos3D)((Object)this.location.multiply(-1.0)));
                centeredPosition.rotate(2.0);
                Location newPosition = (Location)this.location.add(centeredPosition);
                entity.field_70159_w /= 3.0;
                entity.field_70181_x /= 3.0;
                entity.field_70179_y /= 3.0;
                entity.func_70024_g((newPosition.x() - entityPosition.x()) * 0.5 * (double)this.proceduralInterval(), 0.09 * (double)this.proceduralInterval(), (newPosition.z() - entityPosition.z()) * 0.5 * (double)this.proceduralInterval());
                entity.yawChange += 3.0f * this.world().field_73012_v.nextFloat();
            }
        }
    }

    @Override
    public void doPostExplode() {
        if (!this.world().field_72995_K && this.lightBeam != null) {
            this.lightBeam.func_70106_y();
            this.lightBeam = null;
        }
    }

    public boolean canFocusBeam(World worldObj, Location position) {
        return position.canSeeSky();
    }

    @Override
    public int proceduralInterval() {
        return 4;
    }
}

