/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.thread;

import codechicken.lib.thread.ThreadOperationTimer;

public abstract class RestartableTask {
    public final String name;
    private Thread thread;
    private volatile boolean restart;
    private volatile boolean stopped;
    private ThreadOperationTimer timer;

    public RestartableTask(String name) {
        this.name = name;
    }

    private void start() {
        this.thread = new Thread(this.name){

            @Override
            public void run() {
                while (true) {
                    if (RestartableTask.this.stopped) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    if (!RestartableTask.this.restart) {
                        RestartableTask.this.execute();
                    }
                    if (RestartableTask.this.finish()) break;
                }
            }
        };
        this.thread.start();
    }

    private synchronized boolean finish() {
        if (this.restart) {
            this.restart = false;
            return false;
        }
        this.clearTasks();
        return true;
    }

    public void clearTasks() {
        this.thread = null;
        this.timer = null;
    }

    public synchronized void restart() {
        if (this.thread != null) {
            this.stopped = false;
            this.restart = true;
        } else {
            this.start();
        }
    }

    public synchronized void stop() {
        if (this.thread != null) {
            this.stopped = true;
            this.restart = true;
        }
    }

    public boolean interrupted() {
        return this.restart;
    }

    public synchronized ThreadOperationTimer getTimer(int timeout) {
        if (this.timer == null) {
            this.timer = ThreadOperationTimer.start(this.thread, timeout);
        }
        return this.timer;
    }

    public abstract void execute();
}

