/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.base.guide;

import com.bartz24.skyresources.registry.ModGuidePages;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;

public class GuideImage {
    public Map<BlockPos, IBlockState> blocks = new HashMap<BlockPos, IBlockState>();
    public Map<BlockPos, IBlockState> drawBlocks = new HashMap<BlockPos, IBlockState>();
    public Map<BlockPos, TileEntity> drawTEs = new HashMap<BlockPos, TileEntity>();
    public String imgAddress;
    public ImageWorld world = new ImageWorld(this);

    public GuideImage(String imgAddress) {
        this.imgAddress = imgAddress;
        this.blocks = ModGuidePages.imageDesigns.containsKey(imgAddress) ? ModGuidePages.imageDesigns.get(imgAddress) : new HashMap<BlockPos, IBlockState>();
    }

    public void draw(Minecraft mc, int x, int y, int width, int height, float partialTicks) {
        BlockRendererDispatcher renderer = mc.func_175602_ab();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(x + width / 2), (float)(y + height / 2), (float)150.0f);
        int min = 0;
        int max = 0;
        for (BlockPos pos : this.blocks.keySet()) {
            if (pos.func_177956_o() < min) {
                min = pos.func_177956_o();
                continue;
            }
            if (pos.func_177956_o() <= max) continue;
            max = pos.func_177956_o();
        }
        int layer = (int)(mc.func_71386_F() % (long)(2000 * (max - min + 1))) / 2000 + min;
        double sc = 150 / (max - min + 1);
        GlStateManager.func_179139_a((double)(-sc), (double)(-sc), (double)(-sc));
        GlStateManager.func_179114_b((float)-15.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(mc.func_71386_F() % 14400L) / 40.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176600_a);
        this.drawBlocks.clear();
        for (BlockPos pos : this.drawTEs.keySet()) {
            Minecraft.func_71410_x().field_71441_e.func_175713_t(pos);
        }
        this.drawTEs.clear();
        for (BlockPos pos : this.blocks.keySet()) {
            if (pos.func_177956_o() > layer) continue;
            this.drawBlocks.put(pos, this.blocks.get(pos));
        }
        for (BlockPos pos : this.drawBlocks.keySet()) {
            renderer.func_175018_a(this.drawBlocks.get(pos), pos, (IBlockAccess)this.world, Tessellator.func_178181_a().func_178180_c());
        }
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179121_F();
    }

    private static class ImageWorld
    implements IBlockAccess {
        private GuideImage image;

        public ImageWorld(GuideImage image) {
            this.image = image;
        }

        public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
            return this.func_180495_p(pos).isSideSolid((IBlockAccess)this, pos, side);
        }

        public IBlockState func_180495_p(BlockPos pos) {
            return this.image.drawBlocks.keySet().contains(pos) ? this.image.drawBlocks.get(pos) : Blocks.field_150350_a.func_176223_P();
        }

        public boolean func_175623_d(BlockPos pos) {
            return this.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a;
        }

        public Biome func_180494_b(BlockPos pos) {
            return Biomes.field_76772_c;
        }

        public int func_175627_a(BlockPos pos, EnumFacing direction) {
            return 0;
        }

        public WorldType func_175624_G() {
            return WorldType.field_77137_b;
        }

        public int func_175626_b(BlockPos pos, int lightValue) {
            return 0xF000F0;
        }

        public TileEntity func_175625_s(BlockPos pos) {
            return this.image.drawTEs.get(pos);
        }
    }
}

