/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.base.item;

import com.bartz24.skyresources.config.ConfigOptions;
import com.bartz24.skyresources.recipe.ProcessRecipe;
import com.bartz24.skyresources.recipe.ProcessRecipeManager;
import com.bartz24.skyresources.registry.ModCreativeTabs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class ItemWaterExtractor
extends Item
implements IFluidHandler {
    public static final int maxAmount = ConfigOptions.toolSettings.waterExtractorCapacity;
    FluidTank tank;
    public static final String[] extractorIcons = new String[]{"empty", "full1", "full2", "full3", "full4", "full5", "full6"};

    public ItemWaterExtractor() {
        this.field_77777_bU = 1;
        this.func_77637_a(ModCreativeTabs.tabMain);
        this.tank = new FluidTank(new FluidStack(FluidRegistry.WATER, 0), maxAmount);
        this.func_77655_b("skyresources.waterExtractor");
        this.setRegistryName("waterextractor");
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 70000;
    }

    public ItemStack onItemUseFinish(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!world.field_72995_K && timeLeft <= this.func_77626_a(stack) - 25) {
                this.readFromNBT(stack);
                Vec3d vec3d = player.func_174791_d().func_72441_c(0.0, (double)player.eyeHeight, 0.0);
                Vec3d vec3d1 = player.func_70040_Z();
                Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * 5.0, vec3d1.field_72448_b * 5.0, vec3d1.field_72449_c * 5.0);
                RayTraceResult rayTrace = world.func_147447_a(vec3d, vec3d2, false, false, true);
                if (rayTrace != null) {
                    BlockPos pos = rayTrace.func_178782_a();
                    EnumFacing blockHitSide = rayTrace.field_178784_b;
                    Block block = world.func_180495_p(pos).func_177230_c();
                    ProcessRecipe recipe = ProcessRecipeManager.waterExtractorExtractRecipes.getRecipe(new ItemStack(block, 1, block.func_176201_c(world.func_180495_p(pos))), 0.0f, false, false);
                    if (recipe != null) {
                        IBlockState recipeOut = Block.func_149634_a((Item)recipe.getOutputs().get(0).func_77973_b()).func_176203_a(recipe.getOutputs().get(0).func_77960_j());
                        this.tank.fill(recipe.getFluidOutputs().get(0).copy(), true);
                        this.writeToNBT(stack);
                        world.func_180501_a(pos, recipe.getOutputs().get(0) == ItemStack.field_190927_a ? Blocks.field_150350_a.func_176223_P() : recipeOut, 3);
                        world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187806_ee, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
                        return;
                    }
                    if (world.func_180495_p(pos.func_177971_a(blockHitSide.func_176730_m())) == Blocks.field_150355_j.func_176223_P() && this.tank.getFluidAmount() < maxAmount) {
                        world.func_175698_g(pos.func_177971_a(blockHitSide.func_176730_m()));
                        this.tank.fill(new FluidStack(FluidRegistry.WATER, 1000), true);
                        this.writeToNBT(stack);
                        world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187806_ee, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
                    }
                }
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        ItemStack stack = playerIn.func_184586_b(hand);
        this.readFromNBT(stack);
        if (this.tank.getFluid() == null) {
            return EnumActionResult.FAIL;
        }
        if (world.func_175625_s(pos) instanceof IFluidHandler) {
            IFluidHandler tile = (IFluidHandler)world.func_175625_s(pos);
            tile.fill(this.tank.getFluid(), true);
            this.writeToNBT(stack);
            return EnumActionResult.SUCCESS;
        }
        ProcessRecipe recipe = ProcessRecipeManager.waterExtractorInsertRecipes.getRecipe(new ArrayList<Object>(Arrays.asList(new ItemStack(block, 1, block.func_176201_c(world.func_180495_p(pos))), this.tank.getFluid().copy())), 0.0f, false, false);
        if (recipe != null) {
            IBlockState recipeOut = Block.func_149634_a((Item)recipe.getOutputs().get(0).func_77973_b()).func_176203_a(recipe.getOutputs().get(0).func_77960_j());
            world.func_180501_a(pos, recipeOut, 3);
            this.tank.drain(new FluidStack(FluidRegistry.WATER, recipe.getFluidInputs().get((int)0).amount), true);
            this.writeToNBT(stack);
            world.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187806_ee, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
            return EnumActionResult.SUCCESS;
        }
        if (this.tank.getFluidAmount() >= 1000 && playerIn.func_70093_af()) {
            if (block == Blocks.field_150431_aC && (Integer)iblockstate.func_177229_b((IProperty)BlockSnow.field_176315_a) < 1) {
                side = EnumFacing.UP;
            } else if (!block.func_176200_f((IBlockAccess)world, pos)) {
                pos = pos.func_177972_a(side);
            }
            if (!playerIn.func_175151_a(pos, side, stack) || stack.func_190916_E() == 0) {
                return EnumActionResult.FAIL;
            }
            if (FluidUtil.tryPlaceFluid((EntityPlayer)playerIn, (World)world, (BlockPos)pos, (IFluidHandler)this.tank, (FluidStack)this.tank.getFluid())) {
                this.writeToNBT(stack);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.FAIL;
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer player) {
        itemStack.func_77982_d(new NBTTagCompound());
        this.readFromNBT(itemStack);
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null) {
            int filled = this.tank.fill(resource, doFill);
            return filled;
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource != null) {
            return this.tank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        this.readFromNBT(stack);
        tooltip.add("Water: " + this.tank.getFluidAmount() + " mB");
    }

    public int getMaxAmount() {
        return maxAmount;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new FluidHandlerItemStack(stack, maxAmount);
    }

    public void writeToNBT(ItemStack stack) {
        stack.func_77982_d(new NBTTagCompound());
        this.tank.writeToNBT(stack.func_77978_p());
    }

    public void readFromNBT(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        this.tank.readFromNBT(stack.func_77978_p());
    }
}

