/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.jei.combustion;

import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;

public class CombustionRecipeCategory
extends BlankRecipeCategory {
    private static final int[] slotInputStacks = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final int slotOutput = 9;
    private final IDrawable background;
    private IDrawable heatBar;
    private final String localizedName = I18n.func_74837_a((String)"jei.skyresources.recipe.combustion", (Object[])new Object[0]);

    public CombustionRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("skyresources", "textures/gui/jei/combustion.png"), 0, 0, 137, 71);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(new ResourceLocation("skyresources", "textures/gui/guiIcons.png"), 59, 14, 8, 69);
        this.heatBar = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public void drawExtras(Minecraft minecraft) {
        this.heatBar.draw(minecraft, 128, 1);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public String getUid() {
        return "skyresources:combustion";
    }

    public void setRecipe(IRecipeLayout layout, IRecipeWrapper wrapper, IIngredients ingredients) {
        for (int i : slotInputStacks) {
            layout.getItemStacks().init(i, true, i % 3 * 18 + 3, i / 3 * 18 + 9);
        }
        layout.getItemStacks().init(9, false, 97, 27);
        List inputs = ingredients.getInputs(ItemStack.class);
        for (int i = 0; i < inputs.size(); ++i) {
            layout.getItemStacks().set(slotInputStacks[i], (List)inputs.get(i));
        }
        List outputs = ingredients.getOutputs(ItemStack.class);
        layout.getItemStacks().set(9, (List)outputs.get(0));
    }

    public String getModName() {
        return "Sky Resources 2";
    }
}

