/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.network;

import com.bartz24.skyresources.alchemy.item.ItemCondenser;
import com.bartz24.skyresources.alchemy.tile.TileAlchemyFusionTable;
import com.bartz24.skyresources.base.tile.TileCasing;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class DumpMessage
implements IMessage {
    public int machine;
    public int x;
    public int y;
    public int z;

    public DumpMessage() {
    }

    public DumpMessage(int machineType, BlockPos machinePos) {
        this.machine = machineType;
        this.x = machinePos.func_177958_n();
        this.y = machinePos.func_177956_o();
        this.z = machinePos.func_177952_p();
    }

    public void fromBytes(ByteBuf buf) {
        this.machine = buf.readInt();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.machine);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public static class DumpMessageHandler
    implements IMessageHandler<DumpMessage, IMessage> {
        public IMessage onMessage(DumpMessage message, MessageContext ctx) {
            WorldServer world = ctx.getServerHandler().field_147369_b.func_71121_q();
            if (!world.func_175667_e(message.getPos())) {
                return null;
            }
            TileEntity te = world.func_175625_s(message.getPos());
            if (message.machine == 0 && te instanceof TileAlchemyFusionTable) {
                TileAlchemyFusionTable fusion = (TileAlchemyFusionTable)te;
                fusion.setCurItemLeft(0.0f);
                fusion.setCurYield(0.0);
            } else if (message.machine == 1 && te instanceof TileCasing) {
                TileCasing casing = (TileCasing)te;
                if (!casing.machineStored.func_190926_b() && casing.getMachine() instanceof ItemCondenser) {
                    casing.machineData.func_74768_a("time", 0);
                    casing.machineData.func_74776_a("left", 0.0f);
                    casing.machineData.func_74782_a("itemUsing", (NBTBase)ItemStack.field_190927_a.func_77955_b(new NBTTagCompound()));
                }
            }
            return null;
        }
    }
}

