/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.plugin.ctweaker;

import com.bartz24.skyresources.base.HeatSources;
import com.bartz24.skyresources.plugin.ctweaker.CraftTweakerPlugin;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.skyresources.heatsources")
public class MTHeatSources {
    @ZenMethod
    public static void add(IItemStack stack, int heatValue) {
        if (!(CraftTweakerPlugin.toStack(stack).func_77973_b() instanceof ItemBlock)) {
            CraftTweakerAPI.logError((String)"Input block is not block. Did not add source.");
            return;
        }
        MTHeatSources.addRecipe(CraftTweakerPlugin.toStack(stack), heatValue);
    }

    @ZenMethod
    public static void remove(IItemStack stack) {
        if (!(CraftTweakerPlugin.toStack(stack).func_77973_b() instanceof ItemBlock)) {
            CraftTweakerAPI.logError((String)"Input block is not block. Did not remove source.");
            return;
        }
        MTHeatSources.removeRecipe(CraftTweakerPlugin.toStack(stack));
    }

    public static void addRecipe(ItemStack stack, int val) {
        CraftTweakerAPI.apply((IAction)new AddHeatSource(stack, val));
    }

    public static void removeRecipe(ItemStack stack) {
        CraftTweakerAPI.apply((IAction)new RemoveHeatSource(stack));
    }

    public static class RemoveHeatSource
    implements IAction {
        private final ItemStack stack;

        public RemoveHeatSource(ItemStack stack) {
            this.stack = stack;
        }

        public void apply() {
            Block block = Block.func_149634_a((Item)this.stack.func_77973_b());
            HeatSources.removeCTHeatSource(block.func_176203_a(this.stack.func_77960_j()));
        }

        public String describe() {
            return "Removing Heat Source value for " + this.stack.func_82833_r();
        }
    }

    private static class AddHeatSource
    implements IAction {
        private final ItemStack stack;
        private final int val;

        public AddHeatSource(ItemStack stack, int val) {
            this.stack = stack;
            this.val = val;
        }

        public void apply() {
            Block block = Block.func_149634_a((Item)this.stack.func_77973_b());
            HeatSources.addCTHeatSource(block.func_176203_a(this.stack.func_77960_j()), this.val);
        }

        public String describe() {
            return "Adding Heat Source value for " + this.stack.func_82833_r();
        }
    }
}

