/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.plugin.thermal;

import com.bartz24.skyresources.base.HeatSources;
import com.bartz24.skyresources.base.guide.SkyResourcesGuide;
import com.bartz24.skyresources.config.ConfigOptions;
import com.bartz24.skyresources.plugin.IModPlugin;
import com.bartz24.skyresources.registry.ModBlocks;
import com.bartz24.skyresources.registry.ModFluids;
import com.bartz24.skyresources.registry.ModItems;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class ThermalPlugin
implements IModPlugin {
    @Override
    public void preInit() {
    }

    @Override
    public void init() {
        if (ConfigOptions.pluginSettings.thermalExpansionSettings.addSpecialMagmaCrucibleRecipes) {
            this.addCrucibleRecipe(new FluidStack(ModFluids.crystalFluid, 1000), new ItemStack(ModItems.alchemyComponent, 1, 1), 3500);
            this.addCrucibleRecipe(new FluidStack(FluidRegistry.LAVA, 1000), new ItemStack(ModBlocks.blazePowderBlock), 55000);
        }
        Item wrench = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("thermalfoundation", "wrench"));
        Block pyrotheum = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("thermalfoundation", "fluid_pyrotheum"));
        if (ConfigOptions.pluginSettings.thermalExpansionSettings.addPyrotheumHeatSource) {
            HeatSources.addHeatSource(pyrotheum.func_176223_P(), 10);
        }
        SkyResourcesGuide.addPage("thermal", "guide.skyresources.misc", new ItemStack(wrench));
    }

    @Override
    public void postInit() {
    }

    @Override
    public void initRenderers() {
    }

    public void addCrucibleRecipe(FluidStack out, ItemStack in, int energy) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("output", (NBTBase)out.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a("input", (NBTBase)in.func_77955_b(new NBTTagCompound()));
        tag.func_74768_a("energy", energy);
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"addcruciblerecipe", (NBTTagCompound)tag);
    }
}

