/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.registry;

import com.bartz24.skyresources.alchemy.item.AlchemyItemComponent;
import com.bartz24.skyresources.alchemy.item.DirtyGemItem;
import com.bartz24.skyresources.alchemy.item.ItemOreAlchDust;
import com.bartz24.skyresources.alchemy.render.CrucibleTESR;
import com.bartz24.skyresources.alchemy.tile.CrucibleTile;
import com.bartz24.skyresources.base.MachineVariants;
import com.bartz24.skyresources.base.entity.EntityHeavyExplosiveSnowball;
import com.bartz24.skyresources.base.entity.EntityHeavySnowball;
import com.bartz24.skyresources.base.entity.RenderEntityItem;
import com.bartz24.skyresources.base.item.BaseItemComponent;
import com.bartz24.skyresources.base.item.ItemWaterExtractor;
import com.bartz24.skyresources.base.render.CasingTESR;
import com.bartz24.skyresources.base.tile.TileCasing;
import com.bartz24.skyresources.registry.ModBlocks;
import com.bartz24.skyresources.registry.ModFluids;
import com.bartz24.skyresources.registry.ModItems;
import com.bartz24.skyresources.technology.item.TechItemComponent;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class ModRenderers {
    public static void preInit() {
        int i;
        ModRenderers.mapFluidState(ModFluids.crystalFluid);
        for (i = 0; i < AlchemyItemComponent.getNames().size(); ++i) {
            ModRenderers.registerItemRenderer(ModItems.alchemyComponent, i);
        }
        for (i = 0; i < ItemOreAlchDust.getNames().size(); ++i) {
            ModRenderers.registerItemRenderer(ModItems.oreAlchDust, i, true);
        }
        for (i = 0; i < DirtyGemItem.getNames().size(); ++i) {
            ModRenderers.registerItemRenderer(ModItems.dirtyGem, i, true);
        }
        for (i = 0; i < BaseItemComponent.getNames().size(); ++i) {
            ModRenderers.registerItemRenderer(ModItems.baseComponent, i);
        }
        for (i = 0; i < TechItemComponent.getNames().size(); ++i) {
            ModRenderers.registerItemRenderer(ModItems.techComponent, i);
        }
        ModRenderers.registerItemRenderer(ModItems.cactusFruit);
        ModRenderers.registerItemRenderer(ModItems.fleshySnowNugget);
        ModRenderers.registerItemRenderer(ModItems.heavySnowball);
        ModRenderers.registerItemRenderer(ModItems.heavyExpSnowball);
        ModRenderers.registerItemRenderer(ModItems.cactusKnife);
        ModRenderers.registerItemRenderer(ModItems.stoneKnife);
        ModRenderers.registerItemRenderer(ModItems.ironKnife);
        ModRenderers.registerItemRenderer(ModItems.diamondKnife);
        ModRenderers.registerItemRenderer(ModItems.stoneGrinder);
        ModRenderers.registerItemRenderer(ModItems.ironGrinder);
        ModRenderers.registerItemRenderer(ModItems.diamondGrinder);
        ModRenderers.registerItemRenderer(ModItems.alchemicalInfusionStone);
        ModRenderers.registerItemRenderer(ModItems.healthGem);
        ModRenderers.registerItemRenderer(ModItems.survivalistFishingRod);
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.cactusFruitNeedle));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.compressedCoalBlock));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.alchemicalGlass));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.coalInfusedBlock));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.sandyNetherrack));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.darkMatterBlock));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.lightMatterBlock));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.heavySnow));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.dryCactus));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.silverfishDisruptor));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.miniFreezer));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.ironFreezer));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.lightFreezer));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.crucible));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.fluidDropper));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.blazePowderBlock));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.petrifiedWood));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.petrifiedPlanks));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.magmafiedStone));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.dirtFurnace));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.darkMatterWarper));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.endPortalCore));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.lifeInfuser));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.lifeInjector));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.crucibleInserter));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.rockCrusher));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.rockCleaner));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.combustionCollector));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.combustionController));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.quickDropper));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.aqueousConcentrator));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.aqueousDeconcentrator));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.fusionTable));
        ModRenderers.registerItemRenderer(Item.func_150898_a((Block)ModBlocks.wildlifeAttractor));
        ModRenderers.registerItemRenderer(ModItems.sandstoneInfusionStone);
        ModRenderers.registerItemRenderer(ModItems.redSandstoneInfusionStone);
        ModRenderers.registerVariantsDefaulted(ModBlocks.casing, MachineVariants.class, "variant");
        ModRenderers.registerVariantsDefaulted(ModItems.condenser, MachineVariants.class, "variant");
        ModRenderers.registerVariantsDefaulted(ModItems.combustionHeater, MachineVariants.class, "variant");
        ModRenderers.registerVariantsDefaulted(ModItems.heatProvider, MachineVariants.class, "variant");
        ModRenderers.registerVariantsDefaulted(ModItems.alchComponent, MachineVariants.class, "variant");
        ModRenderers.registerVariantsDefaulted(ModItems.heatComponent, MachineVariants.class, "variant");
        ModelBakery.registerItemVariants((Item)ModItems.waterExtractor, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("skyresources:WaterExtractor.empty", "inventory"), new ModelResourceLocation("skyresources:WaterExtractor.full1", "inventory"), new ModelResourceLocation("skyresources:WaterExtractor.full2", "inventory"), new ModelResourceLocation("skyresources:WaterExtractor.full3", "inventory"), new ModelResourceLocation("skyresources:WaterExtractor.full4", "inventory"), new ModelResourceLocation("skyresources:WaterExtractor.full5", "inventory"), new ModelResourceLocation("skyresources:WaterExtractor.full6", "inventory")});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.waterExtractor, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                NBTTagCompound tagCompound = stack.func_77978_p();
                int amount = ((ItemWaterExtractor)stack.func_77973_b()).getTank().getFluidAmount();
                int level = (int)((float)amount * 6.0f / (float)((ItemWaterExtractor)stack.func_77973_b()).getMaxAmount());
                if (level < 0) {
                    level = 0;
                } else if (level > 6) {
                    level = 6;
                }
                return new ModelResourceLocation(stack.func_77973_b().getRegistryName() + "." + ItemWaterExtractor.extractorIcons[level], "inventory");
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityHeavySnowball.class, (IRenderFactory)new IRenderFactory<EntityHeavySnowball>(){

            public RenderEntityItem createRenderFor(RenderManager manager) {
                return new RenderEntityItem(manager, new ItemStack(ModItems.heavySnowball));
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityHeavyExplosiveSnowball.class, (IRenderFactory)new IRenderFactory<EntityHeavyExplosiveSnowball>(){

            public RenderEntityItem createRenderFor(RenderManager manager) {
                return new RenderEntityItem(manager, new ItemStack(ModItems.heavyExpSnowball));
            }
        });
    }

    public static void init() {
        Minecraft.func_71410_x().getItemColors().func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (stack.func_77960_j() < 0 || stack.func_77960_j() >= ItemOreAlchDust.getNames().size()) {
                    return -1;
                }
                return ItemOreAlchDust.oreInfos.get((int)stack.func_77960_j()).color;
            }
        }, new Item[]{ModItems.oreAlchDust});
        Minecraft.func_71410_x().getItemColors().func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (stack.func_77960_j() < 0 || stack.func_77960_j() >= ModItems.gemList.size()) {
                    return -1;
                }
                return ModItems.gemList.get((int)stack.func_77960_j()).color;
            }
        }, new Item[]{ModItems.dirtyGem});
        ClientRegistry.bindTileEntitySpecialRenderer(CrucibleTile.class, (TileEntitySpecialRenderer)new CrucibleTESR());
        ClientRegistry.bindTileEntitySpecialRenderer(TileCasing.class, (TileEntitySpecialRenderer)new CasingTESR());
    }

    public static void registerItemRenderer(Item item, int meta, ResourceLocation name) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{name});
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
    }

    public static void registerItemRenderer(Item item, int meta) {
        ModRenderers.registerItemRenderer(item, meta, new ResourceLocation(item.getRegistryName().toString() + meta));
    }

    public static void registerItemRenderer(Item item, int meta, boolean global) {
        if (!global) {
            ModRenderers.registerItemRenderer(item, meta);
        } else {
            ModRenderers.registerItemRenderer(item, meta, item.getRegistryName());
        }
    }

    public static void registerItemRenderer(Item item) {
        ModRenderers.registerItemRenderer(item, item.getRegistryName());
    }

    public static void registerItemRenderer(Item item, ResourceLocation name) {
        ModRenderers.registerItemRenderer(item, 0, name);
    }

    public static void registerBlockRenderer(Block block, IStateMapper mapper, int ... metadata) {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174954_c().func_178121_a(block, mapper);
    }

    private static <T extends Enum<T>> void registerVariantsDefaulted(Block b, Class<T> enumclazz, String variantHeader) {
        Item item = Item.func_150898_a((Block)b);
        for (Enum e : (Enum[])enumclazz.getEnumConstants()) {
            String variantName = variantHeader + "=" + ((IStringSerializable)e).func_176610_l().toLowerCase();
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)e.ordinal(), (ModelResourceLocation)new ModelResourceLocation(b.getRegistryName(), variantName));
        }
    }

    private static <T extends Enum<T>> void registerVariantsDefaulted(Item item, Class<T> enumclazz, String variantHeader) {
        for (Enum e : (Enum[])enumclazz.getEnumConstants()) {
            String variantName = variantHeader + "=" + ((IStringSerializable)e).func_176610_l().toLowerCase();
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)e.ordinal(), (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), variantName));
        }
    }

    public static void mapFluidState(Fluid fluid) {
        Block block = fluid.getBlock();
        Item item = Item.func_150898_a((Block)block);
        FluidStateMapper mapper = new FluidStateMapper(fluid);
        if (item != null) {
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
        }
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
    }

    static class FluidStateMapper
    extends StateMapperBase
    implements ItemMeshDefinition {
        public final ModelResourceLocation location;

        public FluidStateMapper(Fluid fluid) {
            this.location = new ModelResourceLocation("skyresources:fluid_block", fluid.getName());
        }

        @Nonnull
        protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
            return this.location;
        }

        @Nonnull
        public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
            return this.location;
        }
    }
}

