/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.technology.tile;

import com.bartz24.skyresources.base.tile.TileGenericPower;
import com.bartz24.skyresources.config.ConfigOptions;
import com.bartz24.skyresources.recipe.ProcessRecipe;
import com.bartz24.skyresources.recipe.ProcessRecipeManager;
import com.bartz24.skyresources.registry.ModBlocks;
import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileAqueousConcentrator
extends TileGenericPower
implements ITickable,
IFluidHandler {
    private int curProgress;
    FluidTank tank = new FluidTank(4000);

    public TileAqueousConcentrator() {
        super("aqueousConcentrator", 100000, 2000, 0, 2, new int[]{1}, new int[]{0});
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.concentratorMode()) {
                this.updateConcentrate();
            } else {
                this.updateDeconcentrate();
            }
            this.func_70296_d();
        }
    }

    public int getProgress() {
        return this.curProgress;
    }

    private void updateConcentrate() {
        if (this.tank.getFluid() != null) {
            ProcessRecipe recipe = ProcessRecipeManager.waterExtractorInsertRecipes.getRecipe(Arrays.asList(this.getInventory().getStackInSlot(0), this.tank.getFluid().copy()), 0.0f, false, false);
            if (this.curProgress < 100 && this.getEnergyStored() >= ConfigOptions.machineSettings.aqueousConcentratorPowerUsage && recipe != null && (float)this.tank.getFluidAmount() >= recipe.getIntParameter() && this.getInventory().insertInternalItem(1, recipe.getOutputs().get(0).func_77946_l(), true).func_190926_b()) {
                this.internalExtractEnergy(ConfigOptions.machineSettings.aqueousConcentratorPowerUsage, false);
                this.curProgress += ConfigOptions.machineSettings.aqueousConcentratorSpeed;
            } else if (recipe == null) {
                this.curProgress = 0;
            }
            if (this.curProgress >= 100 && this.getInventory().insertInternalItem(1, recipe.getOutputs().get(0).func_77946_l(), true).func_190926_b() && recipe != null) {
                this.getInventory().insertInternalItem(1, recipe.getOutputs().get(0).func_77946_l(), false);
                this.tank.drain(recipe.getFluidInputs().get((int)0).amount, true);
                this.getInventory().getStackInSlot(0).func_190918_g(1);
                this.curProgress = 0;
            }
        }
    }

    private void updateDeconcentrate() {
        ProcessRecipe recipe;
        ProcessRecipe processRecipe = recipe = this.getInventory().getStackInSlot(0).func_190926_b() ? null : ProcessRecipeManager.waterExtractorExtractRecipes.getRecipe(this.getInventory().getStackInSlot(0), 0.0f, false, false);
        if (this.curProgress < 100 && this.getEnergyStored() >= ConfigOptions.machineSettings.aqueousDeconcentratorPowerUsage && recipe != null && this.tank.getFluidAmount() + recipe.getFluidOutputs().get((int)0).amount <= this.tank.getCapacity() && this.getInventory().insertInternalItem(1, recipe.getOutputs().get(0).func_77946_l(), true).func_190926_b()) {
            this.internalExtractEnergy(ConfigOptions.machineSettings.aqueousDeconcentratorPowerUsage, false);
            this.curProgress += ConfigOptions.machineSettings.aqueousDeconcentratorSpeed;
        } else if (recipe == null) {
            this.curProgress = 0;
        }
        if (this.curProgress >= 100 && this.getInventory().insertInternalItem(1, recipe.getOutputs().get(0).func_77946_l(), true).func_190926_b() && recipe != null) {
            this.getInventory().insertInternalItem(1, recipe.getOutputs().get(0).func_77946_l(), false);
            this.tank.fill(recipe.getFluidOutputs().get(0), true);
            this.getInventory().getStackInSlot(0).func_190918_g(1);
            this.curProgress = 0;
        }
    }

    public boolean concentratorMode() {
        return this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == ModBlocks.aqueousConcentrator;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74768_a("progress", this.curProgress);
        this.tank.writeToNBT(compound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.curProgress = compound.func_74762_e("progress");
        this.tank.readFromNBT(compound);
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.concentratorMode() && resource != null && resource.getFluid() == FluidRegistry.WATER) {
            int filled = this.tank.fill(resource, doFill);
            return filled;
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (!this.concentratorMode()) {
            return this.tank.drain(resource, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (!this.concentratorMode()) {
            return this.tank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return super.getCapability(capability, facing);
    }
}

