/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.technology.tile;

import com.bartz24.skyresources.base.tile.TileGenericPower;
import com.bartz24.skyresources.config.ConfigOptions;
import com.bartz24.skyresources.recipe.ProcessRecipe;
import com.bartz24.skyresources.recipe.ProcessRecipeManager;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileRockCleaner
extends TileGenericPower
implements ITickable,
IFluidHandler {
    private int powerUsage;
    private int curProgress;
    private NonNullList<ItemStack> bufferStacks;
    FluidTank tank;

    public TileRockCleaner() {
        super("rockCleaner", 100000, 2000, 0, 4, new int[]{1, 2, 3}, new int[]{0});
        this.powerUsage = ConfigOptions.machineSettings.rockCleanerPowerUsage;
        this.bufferStacks = NonNullList.func_191196_a();
        this.tank = new FluidTank(4000);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.getRedstoneSignal() == 0) {
            if (this.bufferStacks.size() > 0 && !this.fullOutput()) {
                this.addToOutput(1);
                this.addToOutput(2);
                this.addToOutput(3);
            } else {
                boolean hasRecipes = this.hasRecipes();
                if (this.curProgress < 100 && this.getEnergyStored() >= this.powerUsage && hasRecipes && this.tank.getFluidAmount() >= 250 && this.bufferStacks.size() == 0) {
                    this.internalExtractEnergy(this.powerUsage, false);
                    this.curProgress += ConfigOptions.machineSettings.rockCleanerSpeed;
                } else if (!hasRecipes) {
                    this.curProgress = 0;
                }
                if (this.curProgress >= 100 && hasRecipes) {
                    List<ProcessRecipe> recipes = ProcessRecipeManager.cauldronCleanRecipes.getRecipes();
                    for (ProcessRecipe r : recipes) {
                        if (!((ItemStack)r.getInputs().get(0)).func_77969_a(this.getInventory().getStackInSlot(0)) || this.field_145850_b.field_72995_K) continue;
                        float chance = r.getIntParameter() * 2.0f;
                        if (chance >= 1.0f) {
                            this.bufferStacks.add((Object)r.getOutputs().get(0).func_77946_l());
                            continue;
                        }
                        if (!(this.field_145850_b.field_73012_v.nextFloat() <= chance)) continue;
                        this.bufferStacks.add((Object)r.getOutputs().get(0).func_77946_l());
                    }
                    this.tank.drain(250, true);
                    this.getInventory().getStackInSlot(0).func_190918_g(1);
                    this.curProgress = 0;
                }
            }
        }
        this.func_70296_d();
    }

    public void addToOutput(int slot) {
        if (this.bufferStacks.size() > 0) {
            ItemStack stack = this.getInventory().insertInternalItem(slot, (ItemStack)this.bufferStacks.get(this.bufferStacks.size() - 1), false);
            this.bufferStacks.set(this.bufferStacks.size() - 1, (Object)stack);
            if (((ItemStack)this.bufferStacks.get(this.bufferStacks.size() - 1)).func_190926_b()) {
                this.bufferStacks.remove(this.bufferStacks.size() - 1);
            }
        }
    }

    public boolean fullOutput() {
        return !this.getInventory().getStackInSlot(1).func_190926_b() && !this.getInventory().getStackInSlot(2).func_190926_b() && !this.getInventory().getStackInSlot(3).func_190926_b();
    }

    public boolean hasRecipes() {
        List<ProcessRecipe> recipes = ProcessRecipeManager.cauldronCleanRecipes.getRecipes();
        for (ProcessRecipe r : recipes) {
            if (r == null || !this.getInventory().getStackInSlot(0).func_77969_a((ItemStack)r.getInputs().get(0)) || ((ItemStack)r.getInputs().get(0)).func_190926_b() || this.getInventory().getStackInSlot(0).func_190926_b() || r.getOutputs().get(0).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public int getProgress() {
        return this.curProgress;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74782_a("buffer", (NBTBase)this.bufferListWrite());
        compound.func_74768_a("progress", this.curProgress);
        this.tank.writeToNBT(compound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.bufferListRead(compound.func_74775_l("buffer"));
        this.curProgress = compound.func_74762_e("progress");
        this.tank.readFromNBT(compound);
    }

    public NBTTagCompound bufferListWrite() {
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < this.bufferStacks.size(); ++i) {
            if (((ItemStack)this.bufferStacks.get(i)).func_190926_b()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            ((ItemStack)this.bufferStacks.get(i)).func_77955_b(itemTag);
            nbtTagList.func_74742_a((NBTBase)itemTag);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Items", (NBTBase)nbtTagList);
        return nbt;
    }

    public void bufferListRead(NBTTagCompound nbt) {
        NBTTagList tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTags = tagList.func_150305_b(i);
            this.bufferStacks.add((Object)new ItemStack(itemTags));
        }
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && resource.getFluid() == FluidRegistry.WATER) {
            int filled = this.tank.fill(resource, doFill);
            return filled;
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return super.getCapability(capability, facing);
    }
}

