/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.utilities;

import java.util.Arrays;

public class RayWorldCacheMap {
    private static final int FREE_KEY = 0;
    private int[] m_keys;
    private Object[] m_values;
    private Object m_freeValue;
    private final float m_fillFactor;
    private int m_threshold;
    private int m_size;
    private int m_mask;
    private static final int INT_PHI = -1640531527;

    public RayWorldCacheMap(int size2, float fillFactor) {
        if (fillFactor <= 0.0f || fillFactor >= 1.0f) {
            throw new IllegalArgumentException("FillFactor must be in (0, 1)");
        }
        if (size2 <= 0) {
            throw new IllegalArgumentException("Size must be positive!");
        }
        int capacity = RayWorldCacheMap.arraySize(size2, fillFactor);
        this.m_mask = capacity - 1;
        this.m_fillFactor = fillFactor;
        this.m_keys = new int[capacity];
        this.m_values = new Object[capacity];
        this.m_threshold = (int)((float)capacity * fillFactor);
    }

    public void clear() {
        Arrays.fill(this.m_keys, 0);
        Arrays.fill(this.m_values, null);
        this.m_size = 0;
        this.m_freeValue = null;
    }

    public Object get(int key) {
        if (key == 0) {
            return this.m_freeValue;
        }
        int idx = RayWorldCacheMap.phiMix(key) & this.m_mask;
        int k = this.m_keys[idx];
        if (k == key) {
            return this.m_values[idx];
        }
        if (k == 0) {
            return null;
        }
        int startIdx = idx;
        while ((idx = idx + 1 & this.m_mask) != startIdx) {
            k = this.m_keys[idx];
            if (k == 0) {
                return null;
            }
            if (k != key) continue;
            return this.m_values[idx];
        }
        return null;
    }

    public Object put(int key, Object value) {
        if (key == 0) {
            Object ret = this.m_freeValue;
            if (this.m_freeValue == null) {
                ++this.m_size;
            }
            this.m_freeValue = value;
            return ret;
        }
        int ptr = RayWorldCacheMap.phiMix(key) & this.m_mask;
        int k = this.m_keys[ptr];
        if (k == 0) {
            this.m_keys[ptr] = key;
            this.m_values[ptr] = value;
            if (this.m_size >= this.m_threshold) {
                this.rehash(this.m_keys.length * 2);
            } else {
                ++this.m_size;
            }
            return null;
        }
        if (k == key) {
            Object ret = this.m_values[ptr];
            this.m_values[ptr] = value;
            return ret;
        }
        do {
            if ((k = this.m_keys[ptr = ptr + 1 & this.m_mask]) != 0) continue;
            this.m_keys[ptr] = key;
            this.m_values[ptr] = value;
            if (this.m_size >= this.m_threshold) {
                this.rehash(this.m_keys.length * 2);
            } else {
                ++this.m_size;
            }
            return null;
        } while (k != key);
        Object ret = this.m_values[ptr];
        this.m_values[ptr] = value;
        return ret;
    }

    public int size() {
        return this.m_size;
    }

    private void rehash(int newCapacity) {
        this.m_threshold = (int)((float)newCapacity * this.m_fillFactor);
        this.m_mask = newCapacity - 1;
        int oldCapacity = this.m_keys.length;
        int[] oldKeys = this.m_keys;
        Object[] oldValues = this.m_values;
        this.m_keys = new int[newCapacity];
        this.m_values = new Object[newCapacity];
        this.m_size = this.m_freeValue != null ? 1 : 0;
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldKeys[i] == 0) continue;
            this.put(oldKeys[i], oldValues[i]);
        }
    }

    private static long nextPowerOfTwo(long x2) {
        if (x2 == 0L) {
            return 1L;
        }
        --x2;
        x2 |= x2 >> 1;
        x2 |= x2 >> 2;
        x2 |= x2 >> 4;
        x2 |= x2 >> 8;
        x2 |= x2 >> 16;
        return (x2 | x2 >> 32) + 1L;
    }

    private static int arraySize(int expected, float f) {
        long s = Math.max(2L, RayWorldCacheMap.nextPowerOfTwo((long)Math.ceil((float)expected / f)));
        if (s > 0x40000000L) {
            throw new IllegalArgumentException("Too large (" + expected + " expected elements with load factor " + f + ")");
        }
        return (int)s;
    }

    private static int phiMix(int x2) {
        int h = x2 * -1640531527;
        return h ^ h >> 16;
    }
}

