/*
 * Decompiled with CFR 0.152.
 */
package com.mramericanmike.cropdusting.configuration;

import com.mramericanmike.cropdusting.configuration.ConfigValues;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigurationHandler {
    public static Configuration configuration;
    public static final String CATEGORY_GENERAL = "general";

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            ConfigurationHandler.loadConfiguration();
        }
    }

    public static void loadConfiguration() {
        ConfigValues.enableFarts = configuration.getBoolean("enableFarts", CATEGORY_GENERAL, ConfigValues.enableFarts, "Enable the Farts sounds. If false you only get particles effects");
        ConfigValues.effectRadius = configuration.getInt("effectRadius", CATEGORY_GENERAL, ConfigValues.effectRadius, 1, 7, "The radius of effect for the fartings around the X and Z axis - Y Axis is default to 1 below and 1 above the player stading");
        ConfigValues.updateTimer = configuration.getInt("updateTimer", CATEGORY_GENERAL, ConfigValues.updateTimer, 10, 500, "1 every X times the farting will try to grow crops around the player");
        ConfigValues.fartEvery = configuration.getInt("fartEvery", CATEGORY_GENERAL, ConfigValues.fartEvery, 50, 2000, "1 every X times the cycle run the player will actually fart [Random Chances]");
        ConfigValues.enablePoop = configuration.getBoolean("enablePoop", CATEGORY_GENERAL, ConfigValues.enablePoop, "Enables Poop - Can be used on dirt to create fertile dirt");
        ConfigValues.enablePigs = configuration.getBoolean("enablePigs", CATEGORY_GENERAL, ConfigValues.enablePigs, "Enables Pigs - Pigs with certain names can grow crops");
        ConfigValues.effectPigRadius = configuration.getInt("effectPigRadius", CATEGORY_GENERAL, ConfigValues.effectPigRadius, 1, 7, "The radius of effect for the fartings around the X and Z axis - Y Axis is default to 1 below and 1 above the player stading");
        ConfigValues.pigChances = configuration.getInt("pigChances", CATEGORY_GENERAL, ConfigValues.pigChances, 10, 100, "1 in X chances a valid pig will try to make crops grow [Pigs need to have a valid name]");
        ConfigValues.validPigsNames = configuration.getStringList("validPigsNames", CATEGORY_GENERAL, ConfigValues.validPigsNames, "List of names that named pigs will make crops grow [enablePigs must be true]");
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("cropdusting")) {
            ConfigurationHandler.loadConfiguration();
        }
    }
}

