/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.tesslocator.block.part;

import com.latmod.mods.tesslocator.block.TileTesslocator;
import com.latmod.mods.tesslocator.block.part.AdvancedTesslocatorPart;
import com.latmod.mods.tesslocator.block.part.EnumPartType;
import com.latmod.mods.tesslocator.data.TessNet;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class AdvancedEnergyTesslocatorPart
extends AdvancedTesslocatorPart
implements IEnergyStorage {
    private final LinkedList<AdvancedEnergyTesslocatorPart> temp = new LinkedList();
    public int mode = 0;
    public int energy = 0;

    public AdvancedEnergyTesslocatorPart(TileTesslocator t, EnumFacing f) {
        super(t, f);
    }

    @Override
    public EnumPartType getType() {
        return EnumPartType.ADVANCED_ENERGY;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        if (this.mode > 0) {
            nbt.func_74774_a("output_mode", (byte)this.mode);
        }
        if (this.energy > 0) {
            nbt.func_74768_a("energy", this.energy);
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.mode = nbt.func_74771_c("output_mode");
        this.energy = nbt.func_74762_e("energy");
    }

    @Override
    public boolean hasCapability(Capability<?> capability) {
        return capability == CapabilityEnergy.ENERGY;
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability) {
        return (T)(capability == CapabilityEnergy.ENERGY ? this : null);
    }

    @Override
    public void update(TessNet net) {
        if (this.energy <= 0) {
            return;
        }
        if (this.mode == 0) {
            int e;
            IEnergyStorage outHandler;
            TileEntity outEntity = this.getFacingTile();
            if (outEntity != null && (outHandler = (IEnergyStorage)outEntity.getCapability(CapabilityEnergy.ENERGY, this.facing.func_176734_d())) != null && outHandler.canReceive() && (e = outHandler.receiveEnergy(this.energy, false)) > 0) {
                this.energy -= e;
                this.block.func_70296_d();
            }
            return;
        }
        this.temp.clear();
        for (AdvancedTesslocatorPart part : TessNet.SERVER.get(this.getKey())) {
            if (part == this || !(part instanceof AdvancedEnergyTesslocatorPart)) continue;
            AdvancedEnergyTesslocatorPart part1 = (AdvancedEnergyTesslocatorPart)part;
            if (part1.mode == 1) continue;
            this.temp.add(part1);
        }
        if (this.temp.isEmpty()) {
            return;
        }
        int p = Math.min(this.energy / this.temp.size(), 256);
        if (p > 0 && this.energy >= p) {
            int e = this.energy;
            for (AdvancedEnergyTesslocatorPart t : this.temp) {
                this.energy -= t.receiveEnergy(p, false);
                if (this.energy >= p) continue;
                break;
            }
            if (this.energy != e) {
                this.block.func_70296_d();
            }
        }
    }

    @Override
    public void onRightClick(EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af() && player.func_184586_b(hand).func_190926_b()) {
            this.mode = 1 - this.mode;
            this.block.func_70296_d();
            this.block.rerender();
        } else {
            super.onRightClick(player, hand);
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (maxReceive <= 0 || this.energy >= this.getMaxEnergyStored()) {
            return 0;
        }
        int energyReceived = Math.min(this.getMaxEnergyStored() - this.energy, maxReceive);
        if (!simulate) {
            this.energy += energyReceived;
            this.block.func_70296_d();
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (maxExtract <= 0 || this.energy <= 0) {
            return 0;
        }
        int energyExtracted = Math.min(this.energy, maxExtract);
        if (!simulate) {
            this.energy -= energyExtracted;
            this.block.func_70296_d();
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return 4000000;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }
}

