/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.tesslocator.block.part;

import com.latmod.mods.tesslocator.TesslocatorConfig;
import com.latmod.mods.tesslocator.block.TileTesslocator;
import com.latmod.mods.tesslocator.block.part.BasicTesslocatorPart;
import com.latmod.mods.tesslocator.block.part.EnumPartType;
import com.latmod.mods.tesslocator.block.part.TesslocatorPart;
import com.latmod.mods.tesslocator.data.TessNet;
import com.latmod.mods.tesslocator.gui.ContainerBasicFluidTesslocator;
import com.latmod.mods.tesslocator.gui.GuiBasicFluidTesslocator;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.ItemStackHandler;

public class BasicFluidTesslocatorPart
extends BasicTesslocatorPart
implements IFluidHandler {
    private static final IFluidTankProperties[] NO_PROPERTIES = new IFluidTankProperties[0];
    private final BasicFluidTesslocatorPart[] temp = new BasicFluidTesslocatorPart[5];
    public static boolean ignoreMarkDirty = false;
    public FluidStack inputFilter = null;
    public FluidStack outputFilter = null;
    public final ItemStackHandler other = new ItemStackHandler(2){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.isItemValid(slot, stack) ? super.insertItem(slot, stack, simulate) : stack;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return stack.func_77973_b() == Items.field_151114_aO;
            }
            if (slot == 1) {
                return stack.func_77973_b() == Items.field_151045_i;
            }
            return false;
        }

        public int getStackLimit(int slot, ItemStack stack) {
            if (slot == 0) {
                return TesslocatorConfig.basic_fluid.speed_boost_max;
            }
            if (slot == 1) {
                return TesslocatorConfig.basic_fluid.stack_boost_max;
            }
            return 0;
        }

        protected void onContentsChanged(int slot) {
            if (!ignoreMarkDirty) {
                BasicFluidTesslocatorPart.this.block.func_70296_d();
            }
        }
    };
    public int cooldown = 0;
    public int currentPart = 0;

    public BasicFluidTesslocatorPart(TileTesslocator t, EnumFacing f) {
        super(t, f);
    }

    @Override
    public EnumPartType getType() {
        return EnumPartType.BASIC_FLUID;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        if (this.inputFilter != null) {
            this.inputFilter.amount = 1000;
            nbt.func_74782_a("input_filter", (NBTBase)this.inputFilter.writeToNBT(new NBTTagCompound()));
        }
        if (this.outputFilter != null) {
            this.outputFilter.amount = 1000;
            nbt.func_74782_a("output_filter", (NBTBase)this.outputFilter.writeToNBT(new NBTTagCompound()));
        }
        NBTTagList otherTag = new NBTTagList();
        for (int i = 0; i < this.other.getSlots(); ++i) {
            if (this.other.getStackInSlot(i).func_190926_b()) continue;
            NBTTagCompound nbt1 = this.other.getStackInSlot(i).serializeNBT();
            nbt1.func_74774_a("slot", (byte)i);
            otherTag.func_74742_a((NBTBase)nbt1);
        }
        if (!otherTag.func_82582_d()) {
            nbt.func_74782_a("other", (NBTBase)otherTag);
        }
        if (this.cooldown > 0) {
            nbt.func_74774_a("cooldown", (byte)this.cooldown);
        }
        if (this.currentPart > 0) {
            nbt.func_74774_a("current_part", (byte)this.currentPart);
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.inputFilter = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("input_filter"));
        this.outputFilter = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("output_filter"));
        this.other.setSize(2);
        NBTTagList otherTag = nbt.func_150295_c("other", 10);
        for (int i = 0; i < otherTag.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = otherTag.func_150305_b(i);
            ItemStack stack = new ItemStack(nbt1);
            if (stack.func_190926_b()) continue;
            ignoreMarkDirty = true;
            this.other.setStackInSlot((int)nbt1.func_74771_c("slot"), stack);
            ignoreMarkDirty = false;
        }
        this.cooldown = nbt.func_74771_c("cooldown") & 0xFF;
        this.currentPart = nbt.func_74771_c("current_part") & 0xFF;
    }

    @Override
    public boolean hasCapability(Capability<?> capability) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this : null);
    }

    @Override
    public void update(TessNet net) {
        if (this.mode == 0) {
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        this.cooldown = TesslocatorConfig.basic_fluid.speed_boost_starting - (int)((double)this.other.getStackInSlot(0).func_190916_E() * TesslocatorConfig.basic_fluid.speed_boost_multiplier);
        this.moveFluid();
    }

    private void moveFluid() {
        int tempParts = 0;
        for (TesslocatorPart part : this.block.parts) {
            if (part == this || !(part instanceof BasicFluidTesslocatorPart)) continue;
            BasicFluidTesslocatorPart part1 = (BasicFluidTesslocatorPart)part;
            if (part1.mode == 1) continue;
            this.temp[tempParts] = part1;
            ++tempParts;
        }
        if (tempParts == 0) {
            return;
        }
        TileEntity tileEntity = this.getFacingTile();
        if (tileEntity == null) {
            return;
        }
        IFluidHandler handler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.facing.func_176734_d());
        if (handler == null) {
            return;
        }
        int stackBoost = this.other.getStackInSlot(1).func_190916_E() + 1;
        for (int x = 0; x < stackBoost; ++x) {
            int fill;
            IFluidHandler outHandler;
            TileEntity outEntity;
            FluidStack stack;
            if (this.outputFilter == null) {
                stack = handler.drain(8000, false);
            } else {
                this.outputFilter.amount = 8000;
                stack = handler.drain(this.outputFilter, false);
                this.outputFilter.amount = 1000;
            }
            if (stack == null) {
                return;
            }
            int i = this.currentPart % tempParts;
            if ((this.temp[i].inputFilter == null || this.temp[i].inputFilter.isFluidEqual(stack)) && (outEntity = this.temp[i].getFacingTile()) != null && (outHandler = (IFluidHandler)outEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.temp[i].facing.func_176734_d())) != null && (fill = outHandler.fill(stack, true)) > 0) {
                if (this.outputFilter == null) {
                    handler.drain(fill, true);
                } else {
                    this.outputFilter.amount = fill;
                    handler.drain(this.outputFilter, true);
                    this.outputFilter.amount = 1000;
                }
            }
            ++this.currentPart;
            if (this.currentPart < 256) continue;
            this.currentPart = 0;
        }
    }

    @Override
    public void drop(World world, BlockPos pos) {
        super.drop(world, pos);
        for (int i = 0; i < this.other.getSlots(); ++i) {
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.other.getStackInSlot(i));
        }
    }

    @Override
    @Nullable
    public Container getGuiContainer(EntityPlayer player) {
        return new ContainerBasicFluidTesslocator(this, player);
    }

    @Override
    @Nullable
    public Object getGuiScreen(Container container) {
        return new GuiBasicFluidTesslocator((ContainerBasicFluidTesslocator)container);
    }

    public IFluidTankProperties[] getTankProperties() {
        return NO_PROPERTIES;
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }
}

